/*************************************************************************
 *
 *  $RCSfile: viewshe4.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/27 15:06:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sfx2/docfile.hxx>
#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif
#ifndef _SFX_PRINTER_HXX 
#include <sfx2/printer.hxx>
#endif

#ifndef _SVX_FLOAT3D_HXX
#include <svx/float3d.hxx>
#endif

#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SVX_FLOAT3D_HXX
#include <svx/float3d.hxx>
#endif
#ifndef _SVX_F3DCHILD_HXX
#include <svx/f3dchild.hxx>
#endif

#ifndef _CLIPLISTENER_HXX
#include <svtools/cliplistener.hxx>
#endif


#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0

//sfxcore.hxx

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <sfx2/viewfac.hxx>
#endif

#include <svx/sizeitem.hxx>

#ifndef _SFX_HRC
#include <sfx2/sfx.hrc>
#endif
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------
#include <svtools/style.hrc>
#include <svx/dialogs.hrc>

#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif

#include "chwindow.hxx"
#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "schview.hxx"
#include "schresid.hxx"

#define _SBX_HXX 0
#include "viewshel.hxx"
#include "fusel.hxx"
#include "dgrdata.hxx"
#include "schhids.h"

#ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif

#include "ChXChartView.hxx"


/*************************************************************************
|*
|* SFX-Slotmap und Standardinterface deklarieren
|*
\************************************************************************/

#define SchViewShell
#include "schslots.hxx"


SFX_IMPL_INTERFACE( SchViewShell, SfxViewShell, SchResId( STR_CHARTVIEWSHELL ))
// from macro: void SchViewShell::InitInterface_Impl()
{
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
								SchResId( RID_DRAW_TOOLBOX ));
	SFX_FEATURED_CHILDWINDOW_REGISTRATION( SchDiagramDataWrapper::GetChildWindowId(), SCH_UI_FEATURE_OWN_DATA );
	SFX_FEATURED_CHILDWINDOW_REGISTRATION( Svx3DChildWindow::GetChildWindowId(), SCH_UI_FEATURE_THREE_D );
}

SFX_IMPL_VIEWFACTORY(SchViewShell, SchResId(STR_DEFAULTVIEW))
{
	SFX_VIEW_REGISTRATION(SchChartDocShell);
}

TYPEINIT1(SchViewShell, SfxViewShell);

/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

void SchViewShell::Construct(SchChartDocShell& rDocSh)
{
	bUserKnowsTranslation=FALSE;
	// Hilfe-ID setzen
	SetHelpId( HID_SCH_VIEWSHELL_DOCUMENT );

	bRepaintPossible = TRUE;
	bFirstStart      = TRUE;

    OutputDevice * pOutDev = GetWindow();
	pChView          = new SchView(&rDocSh, pOutDev, this);

	// Muss Namen haben, damit Basic ueber OLE funktioniert
	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "View" )));

	SetPool(&rDocSh.GetDoc().GetPool());
	SetUndoManager(rDocSh.GetUndoManager());
	SetRepeatTarget(pChView);

	// Initialisierungen der Zeichen-(Bildschirm-)Attribute
	pChView->SetGridCoarse(Size(1000, 1000));
	pChView->SetSnapGrid(Size(1000, 1000));
	pChView->SetGridVisible(FALSE);
	pChView->SetGridSnap(FALSE);
	pChView->SetDragStripes(FALSE);
	pChView->SetFrameDragSingles(TRUE);
	pChView->SetNoDragXorPolys(TRUE);

	SetZoom(100);
	pChView->ShowPagePgNum(0, Point(0, 0));

	// Darstellung von Gruppierungen disablen, dies ist
	// im Chart nicht erwuenscht...
	pChView->SetVisualizeEnteredGroup(FALSE);

	// Selektionsfunktion starten
//	SfxRequest aReq(SID_TOOL_SELECT, pChView->GetDoc().GetItemPool());
	SfxRequest aReq(SID_TOOL_SELECT, 0, pChView->GetDoc().GetItemPool());
	FuPermanent(aReq);

    // #109912# Transfer Arabic/Hindi Cipher setting from RefDevice to Window
    if( pOutDev )
    {
        OutputDevice * pRefDev = rDocSh.GetRefDevice();
        if( pRefDev )
        {
            pOutDev->SetDigitLanguage( pRefDev->GetDigitLanguage() );
        }
        else
        {
            DBG_ERROR( "No RefDevice" );
        }
    }
    else
    {
        DBG_ERROR( "Invalid Window" );
    }

    // remember the UNO Controller
    mpUNOController = new ChXChartView( this );

	::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow > aTmpRef;
	GetViewFrame()->GetFrame()->GetFrameInterface()->setComponent( aTmpRef, mpUNOController );

    pChView->SetSolidMarkHdl( TRUE );
    StartListening( rDocSh );
}

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

SchViewShell::SchViewShell(SfxViewFrame* pFrame, Window* pParent) :
	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST |
						 SFX_VIEW_OPTIMIZE_EACH |
						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
						 SFX_VIEW_DISABLE_ACCELS |
						 SFX_VIEW_CAN_PRINT),
	pFuActual(NULL),
	pFuOld(NULL),
	nCurrentObjectBar(0),
	bObjectBarSwitchEnabled(TRUE),
	pTempFuActual(NULL),
	pDocSh( (SchChartDocShell*) GetViewFrame()->GetObjectShell() ),
	mpClipEvtLstnr(NULL),
    mp3DFlyerReference(NULL),
	mbPastePossible(FALSE),
    mbTextPastePossible(FALSE),
    mpUNOController( NULL ),
    mbBroadcastSelectionChanges( sal_True ),
    mbPendingSelectionChange( sal_False )
{
	SchWindow* pWin = new SchWindow(&pFrame->GetWindow());
	SetWindow(pWin);
	pWin->SetViewShell(this);

	Construct(*(SchChartDocShell*)pFrame->GetObjectShell());
}

/*************************************************************************
|*
|* Standard-Konstruktor (2)
|*
\************************************************************************/

SchViewShell::SchViewShell(SfxViewFrame* pFrame,
						   SfxViewShell* pOldShell) :
	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST |
						 SFX_VIEW_OPTIMIZE_EACH |
						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
						 SFX_VIEW_DISABLE_ACCELS |
						 SFX_VIEW_CAN_PRINT),
	pFuActual(NULL),
	pFuOld(NULL),
	nCurrentObjectBar(0),
	bObjectBarSwitchEnabled(TRUE),
	pTempFuActual(NULL),
	pDocSh( (SchChartDocShell*) GetViewFrame()->GetObjectShell() ),
	mpClipEvtLstnr(NULL),
    mp3DFlyerReference(NULL),
	mbPastePossible(FALSE),
    mbTextPastePossible(FALSE),
    mpUNOController( NULL ),
    mbBroadcastSelectionChanges( sal_True ),
    mbPendingSelectionChange( sal_False )
{
	SchWindow* pWin = new SchWindow(&pFrame->GetWindow());
	SetWindow(pWin);
	pWin->SetViewShell(this);

	Construct(*(SchChartDocShell*)pFrame->GetObjectShell());
}

/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/

SchViewShell::SchViewShell(SfxViewFrame* pFrame,
						   const SchViewShell& rShell) :
	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST |
						 SFX_VIEW_OPTIMIZE_EACH |
						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
						 SFX_VIEW_DISABLE_ACCELS |
						 SFX_VIEW_CAN_PRINT),
	pFuActual(NULL),
	pFuOld(NULL),
	nCurrentObjectBar(0),
	bObjectBarSwitchEnabled(TRUE),
	pTempFuActual(NULL),
	pDocSh( (SchChartDocShell*) GetViewFrame()->GetObjectShell() ),
	mpClipEvtLstnr(NULL),
    mp3DFlyerReference(NULL),
	mbPastePossible(FALSE),
    mbTextPastePossible(FALSE),
    mpUNOController( NULL ),
    mbBroadcastSelectionChanges( sal_True ),
    mbPendingSelectionChange( sal_False )
{
	SchWindow* pWin = new SchWindow(&pFrame->GetWindow());
	SetWindow(pWin);
	pWin->SetViewShell(this);

	Construct(*(SchChartDocShell*) pFrame->GetObjectShell());
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchViewShell::~SchViewShell()
{
    if( NULL != pDocSh )
        EndListening( *pDocSh );

    // #96642# Remove references to items within Svx3DWin
    // (maybe do a listening sometime in Svx3DWin)
    USHORT nId = Svx3DChildWindow::GetChildWindowId();
    SfxChildWindow* pWindow = GetViewFrame() ? GetViewFrame()->GetChildWindow(nId) : NULL;
    if( pWindow )
    {
        Svx3DWin* p3DWin = static_cast< Svx3DWin* >( pWindow->GetWindow() );
        if( p3DWin )
            p3DWin->DocumentReload();
    }

	SwitchObjectBar(0);

	// Umschaltung der ObjectBarShells unterdruecken, sonst versucht die
	// sterbende Funktion eventuell die ObjectBars zu wechseln. Die
	// entsprechende Shell ist aber schon vom SFX vom Dispatcher-Stack
	// genommen worden.
	bObjectBarSwitchEnabled = FALSE;

	if (pFuActual)
	{
		if (pFuOld == pFuActual)
			pFuOld = NULL;

		pFuActual->Deactivate();
		delete pFuActual;
		pFuActual = NULL;
	}

	if (pFuOld)
	{
		delete pFuOld;
		pFuOld = NULL;
	}

    // remove listener for system clipboard
	if ( mpClipEvtLstnr )
	{
		mpClipEvtLstnr->AddRemoveListener( GetWindow(), FALSE );
		mpClipEvtLstnr->release();
	}

	delete pChView;

	delete GetWindow();
	SetWindow( NULL );	// #76782#

	// Shells fuer Object Bars loeschen
	// vorm Zerstoeren der ObjectBarShells den Dispatcher flushen
	GetViewFrame()->GetDispatcher()->Flush();

	SfxShell* pObjBarShell = (SfxShell*)aShellTable.First();
	while (pObjBarShell)
	{
		delete pObjBarShell;
		pObjBarShell = (SfxShell*)aShellTable.Next();
	}
}

/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird vom Fenster an die Viewshell und
|* die aktuelle Funktion weitergeleitet
|*
\************************************************************************/

void SchViewShell::Paint(const Rectangle& rRect)
{
	SchWindow        *pWin = GetWindow();
	ChartModel &rDoc = ((SchChartDocShell*)GetViewFrame()->GetObjectShell())->GetDoc();

	if (!rDoc.IsInitialized())
	{
		rDoc.Initialize();
		Invalidate ();
		pWin->Invalidate ();
	}
	else pChView->InitRedraw(pWin, Region(rRect));

	if (pFuActual) pFuActual->Paint(rRect, pWin);
}

/*************************************************************************
|*
|* View ermitteln
|*
\************************************************************************/

SchView* SchViewShell::GetView() const
{
	return pChView;
}

/*************************************************************************
|*
|* Vorbereitung fuers Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/
void SchViewShell::PreparePrint(PrintDialog* pPrintDialog)
{
}


/*************************************************************************
|*
|* Drucken; virtuell, wird vom SFX aufgerufen
|*
\************************************************************************/

USHORT SchViewShell::Print(SfxProgress &rProgress,
								PrintDialog* pPrintDialog)
{
	SfxPrinter* pPrinter = GetPrinter();

	if (pPrinter)
	{
		BOOL bModified = ((SchChartDocShell*)GetViewFrame()->GetObjectShell())->IsModified ();

		SfxViewShell::Print (rProgress, pPrintDialog);

		// MapMode einstellen
		MapMode aOldMap = pPrinter->GetMapMode();
		pChView->GetDoc().AdjustPrinter();

        // tell printer if there are any transparent objects in the chart
        if( ! pPrinter->InitJob( GetWindow(), pChView->GetDoc().HasTransparentObjects()))
        {
            // user pressed 'Cancel'
            return 0;
        }

		SchView* pPrintView = new SchView ((SchChartDocShell*)GetViewFrame()->GetObjectShell(),
										   pPrinter, this);

		pPrinter->StartPage();
		pPrintView->ShowPagePgNum(0, Point());
		pPrintView->InitRedraw(pPrinter, Region (Rectangle(Point(), pPrinter->GetOutputSize())));
		pPrinter->EndPage();

		delete pPrintView;
		pPrinter->SetMapMode(aOldMap);
		((SchChartDocShell*)GetViewFrame()->GetObjectShell())->SetModified (FALSE);
	}

	return 0;
}

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

FASTBOOL SchViewShell::Command(const CommandEvent& rCEvt)
{
	BOOL bResult = FALSE;

	// pop-up menu
	if (rCEvt.GetCommand() == COMMAND_CONTEXTMENU && !pChView->IsAction())
	{
		GetWindow()->ReleaseMouse();

		ChartModel& rDoc = pChView->GetDoc();
		BOOL bAxisChart     = rDoc.IsAxisChart();
		USHORT nRId	= 0;

		if( !pChView->HasMarkedObj() )
			nRId = RID_FORMAT_POPUP;
		else if( rDoc.Is3DChart() )
		{
			if( bAxisChart )
				nRId = RID_3D_POPUP;
			else
				nRId = RID_3D_PIE_POPUP;
		}
		else
		{
			if( !bAxisChart || rDoc.IsNetChart() )
				nRId = RID_2D_PIE_POPUP;
			else
				nRId = RID_2D_POPUP;
		}
		if( nRId != 0 )
			GetViewFrame()->GetDispatcher()->ExecutePopup( SchResId( nRId ) );

		bResult = TRUE;
	}
	// UNIX-stlye selection clipboard usually with
	// middle mouse button
	else if( rCEvt.GetCommand() == COMMAND_PASTESELECTION )
	{
		Window* pWin = GetWindow();
		TransferableDataHelper aDataHelper(
			TransferableDataHelper::CreateFromSelection( pWin ) );

		if( aDataHelper.GetTransferable().is())
		{
			Point aPos;
			if( pWin )
				aPos = pWin->PixelToLogic( rCEvt.GetMousePosPixel());

			pChView->InsertData( aDataHelper, aPos, DND_ACTION_COPY, FALSE );
		}

		bResult = TRUE;
	}
	else if( pFuActual )
		bResult = pFuActual->Command( rCEvt );

	return bResult;
}

/*************************************************************************
|*
|* Wird gerufen, wenn sich der Selektionszustand der View aendert
|*
\************************************************************************/

void SchViewShell::SelectionHasChanged()
{
	Invalidate();

	// 3d flyer window
	USHORT nId = Svx3DChildWindow::GetChildWindowId();
	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
	if( pWindow )
	{
		Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
		if( p3DWin )
		{
			SfxBoolItem aItem( SID_3D_STATE, TRUE );
			GetViewFrame()->GetDispatcher()->Execute( SID_3D_STATE, SFX_CALLMODE_ASYNCHRON |
													  SFX_CALLMODE_RECORD, &aItem, 0L );
		}
	}

    if( mbBroadcastSelectionChanges )
    {
        pChView->UpdateSelectionClipboard( FALSE );

        if( mpUNOController != NULL )
            mpUNOController->fireSelectionChangeListener();

        mbPendingSelectionChange = sal_False;
    }
    else
        mbPendingSelectionChange = sal_True;
}

/*************************************************************************
|*
|* aktuellen Drucker des Dokuments zurueckgeben
|*
\************************************************************************/

SfxPrinter* SchViewShell::GetPrinter(BOOL bCreate)
{
	return (*(SchChartDocShell*)GetViewFrame()->
								GetObjectShell()).GetPrinter();
}

/*************************************************************************
|*
|* neuen Drucker fuer die Applikation setzen
|*
\************************************************************************/

USHORT SchViewShell::SetPrinter(SfxPrinter* pNewPrinter, USHORT nDiffFlags)
{
	(*(SchChartDocShell*)GetViewFrame()->
		GetObjectShell()).SetPrinter(pNewPrinter);
	return 0;
}

/*************************************************************************
|*
|* PrepareClose, ggfs. Texteingabe beenden, damit andere Viewshells ein
|* aktualisiertes Textobjekt vorfinden
|*
\************************************************************************/

USHORT SchViewShell::PrepareClose(BOOL bUI,BOOL b) //#63638#
{
	USHORT nClosing=SfxViewShell::PrepareClose(bUI,b);

	if(nClosing)
	{
		if (pFuActual && pFuActual->GetSlotID() == SID_TEXTEDIT)
			pChView->EndTextEdit();
	}
	return nClosing;
}


/** Returns TRUE if the corresponding feature is available,
    eg it returns only true if the chart is three dimensional
    and the 3d effect flyer is to be displayed
*/
BOOL SchViewShell::HasUIFeature( ULONG nFeature )
{
    switch( nFeature )
    {
        case SCH_UI_FEATURE_THREE_D:
            if( pDocSh )
                return pDocSh->GetDoc().IsReal3D();
            return FALSE;

        case SCH_UI_FEATURE_OWN_DATA:
            // ToDo: If chart is inside Calc/Writer using external data, FALSE
            // should be returned. It currently works in a different way (hack)
            return TRUE;

        default:
            DBG_ERRORFILE( "Unknown UI Feature requested!" );
            return FALSE;
    }
}

void SchViewShell::AllowSelectionChangeBroadcasts( sal_Bool bAllow )
{
    if( bAllow != mbBroadcastSelectionChanges )
    {
        mbBroadcastSelectionChanges = bAllow;
        if( sal_True == mbBroadcastSelectionChanges &&
            sal_True == mbPendingSelectionChange )
        {
            SelectionHasChanged();
        }
    }
}

// SfxListener

void SchViewShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    if( rHint.ISA( SchVisAreaChangedHint ) &&
        NULL != mpUNOController )
    {
        Rectangle aRect = static_cast< const SchVisAreaChangedHint & >( rHint ).getNewRect();
        ::com::sun::star::awt::Rectangle aAwtRect(
            aRect.Left(), aRect.Top(), aRect.GetWidth(), aRect.GetHeight() );
        mpUNOController->changeVisArea( aAwtRect );
    }
    else
        SfxViewShell::Notify( rBC, rHint );
}


// ________________________________________
//
//  SuspendSelectionChangeBroadcasting
// ________________________________________

SuspendSelectionChangeBroadcasting::SuspendSelectionChangeBroadcasting( SchViewShell *  pViewShell ) :
        mpViewShell( pViewShell )
{
    if( mpViewShell )
        mpViewShell->AllowSelectionChangeBroadcasts( sal_False );    
}

SuspendSelectionChangeBroadcasting::~SuspendSelectionChangeBroadcasting()
{
    if( mpViewShell )
        mpViewShell->AllowSelectionChangeBroadcasts( sal_True );
}

// __________ SchVisAreaChangedHint __________

TYPEINIT0( SchVisAreaChangedHint );

SchVisAreaChangedHint::SchVisAreaChangedHint( const Rectangle & rNewRect )
{
    maNewRect = rNewRect;
}

SchVisAreaChangedHint::SchVisAreaChangedHint()
{}

SchVisAreaChangedHint::~SchVisAreaChangedHint()
{}

const Rectangle &  SchVisAreaChangedHint::getNewRect() const
{
    return  maNewRect;
}
