/*************************************************************************
 *
 *  $RCSfile: kernel9xentry.c,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2000/11/22 14:05:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>

//------------------------------------------------------------------------------
// globales
//------------------------------------------------------------------------------

typedef DWORD ( WINAPI * GetLongPathNameA_Proc_T ) (
  LPCSTR lpszShortPath, // file name
  LPSTR lpszLongPath,   // path buffer
  DWORD cchBuffer        // size of path buffer 
);
GetLongPathNameA_Proc_T lpfnGetLongPathNameA_98 = 0;

//------------------------------------------------------------------------------
// DllMain
//------------------------------------------------------------------------------

BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved )
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:
			{
				OSVERSIONINFO osvi;
				HMODULE		  hModKernel32;
				BOOL		  bIsWin98;
				
				osvi.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
				GetVersionEx( &osvi );
				
				bIsWin98 = ( VER_PLATFORM_WIN32_WINDOWS == osvi.dwPlatformId ) && 
						   ( osvi.dwMinorVersion > 0 );
				
				if ( bIsWin98 )
				{
					hModKernel32 = GetModuleHandleA( "kernel32.dll" );
					if ( NULL != hModKernel32 )
					{										
						// there is a GetLongPathName function under Win98 but only
						// a non-unicode version
						lpfnGetLongPathNameA_98 = ( GetLongPathNameA_Proc_T )GetProcAddress(
							hModKernel32, "GetLongPathNameA" );
					}
				}
			}
			break;

		case DLL_PROCESS_DETACH:
			break;
	
		case DLL_THREAD_ATTACH:			
			break;

		case DLL_THREAD_DETACH:			
			break;
	}

	return TRUE;
}
 
