/*************************************************************************
 *
 *  $RCSfile: osxlocale.c,v $
 *
 *  $Revision: 1.2.10.1.12.1 $
 *
 *  last change: $Author: khendricks $ $Date: 2004/05/28 15:39:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sal/types.h>

#include <premac.h>
#include <CoreServices/CoreServices.h>
#include <CoreFoundation/CoreFoundation.h>
#include <postmac.h>

/*
 * macxp_getOSXLocale
 *
 * Grab current locale from system.
 */
int macxp_getOSXLocale( char *locale, sal_uInt32 bufferLen )
{
	LocaleRef		lref;
	CFArrayRef	aref;
	CFStringRef	sref;
	CFStringRef    locNameRef;
     
	aref = (CFArrayRef)CFPreferencesCopyAppValue( CFSTR( "AppleLanguages" ), kCFPreferencesCurrentApplication );
	if ( aref != NULL )
	{
		if ( (CFGetTypeID(aref) == CFArrayGetTypeID()) && (CFArrayGetCount(aref) > 0) )
		{
			sref = (CFStringRef)CFArrayGetValueAtIndex( aref, 0 );
			if ( (sref != NULL) && (CFGetTypeID(sref) == CFStringGetTypeID()) )
			{
#if (BUILD_OS_MAJOR==10) && (BUILD_OS_MINOR==3)
// Panther code
				// This function only exists in Panther and above
				locNameRef = CFLocaleCreateCanonicalLocaleIdentifierFromString( kCFAllocatorDefault,  sref );

				if ( locNameRef != NULL )
				{
					CFStringGetCString( locNameRef, locale, bufferLen, kCFStringEncodingASCII );
					CFRelease( locNameRef );

					// If its just en, we want en_US.  Since all the locales are also
					// UTF-8, we'll append UTF-8 to the end of all returned locales
					if ( strcmp(locale, "en") == 0 )
						strlcpy( locale, "en_US", bufferLen );
//					else if ( strchr(locale, '.') == NULL )
//						strlcat( locale, ".UTF-8", bufferLen );
        				// For Japanese locale, just "ja" is not sufficient.
					// Use "ja_JP.UTF-8" instead.
					if ( (strlen(locale) == 2) && (strncmp(locale, "ja", 2) == 0) )
						strlcpy( locale, "ja_JP.UTF-8", bufferLen );
				}
				else
					fprintf( stderr, "Could not get Canonical Locale Identifier from AppleLanguages value!\n" );
#endif

#if (BUILD_OS_MAJOR == 10) && (BUILD_OS_MINOR == 2)
// Jaguar code
				if ( CFStringGetCString( sref, locale, bufferLen, CFStringGetSystemEncoding() ) )
				{
					LocaleRefFromLocaleString( locale, &lref );
					LocaleRefGetPartString( lref, kLocaleAllPartsMask, bufferLen, locale );

					/* Hack for US english locales.  OS X returns only "en", but we want
					* "en_US".  So add it.
					*/
					if ( (strlen(locale) == 2) && (strncmp(locale, "en", 2) == 0) )
						strncat( locale, "_US", bufferLen - strlen(locale) - 1 );
        				// For Japanese locale, just "ja" is not sufficient.
					// Use "ja_JP.UTF-8" instead.
					if ( (strlen(locale) == 2) && (strncmp(locale, "ja", 2) == 0) )
						strlcpy( locale, "ja_JP.UTF-8", bufferLen );
				}
#endif
			}
			else
				fprintf( stderr, "Could not get array index 0 value of CFPref AppleLanguages!\n" );
		}

		CFRelease( aref );
     }
     else
          fprintf( stderr, "Could not get value of CFPref AppleLanguages!  Please reset your locale in the International control panel.\n" );

	return( noErr );
}


/*
 * macxp_OSXConvertCFEncodingToIANACharSetName
 *
 * Convert a CoreFoundation text encoding to an IANA charset name.
 */
int macxp_OSXConvertCFEncodingToIANACharSetName( char *buffer, unsigned int bufferLen, CFStringEncoding cfEncoding )
{
	CFStringRef	sCFEncodingName;

	sCFEncodingName = CFStringConvertEncodingToIANACharSetName( cfEncoding );
	CFStringGetCString( sCFEncodingName, buffer, bufferLen, cfEncoding );

	return( noErr );
}
