/*************************************************************************
 *
 *  $RCSfile: sbaexpl1.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OFA_SBAEXPL1_HXX
#define _OFA_SBAEXPL1_HXX

#ifndef _OFA_SBAEXPL_HXX
#include "sbaexpl.hxx"
#endif

#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif

#ifndef _EXPCONT_HXX //autogen
#include <sfx2/expcont.hxx>
#endif

#ifndef _EXPLMENU_HXX //autogen
#include <sfx2/explmenu.hxx>
#endif

#ifndef _ICON_HXX //autogen
#include <vcl/icon.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif


class SbaObject;
class SbaDatabase;

//-------------------------------------------------------------------------
// Container von Tabellen(Explorer)

class SbaTableContainer: public SbaDBFolder
{
	friend class SbaTableContent;
	friend class SbaDatabaseContainer;

public:
	TYPEINFO();
	SbaTableContainer();

	virtual Image GetImage( SfxExplorerContentImage eImage );

protected:
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual void Load(BOOL);
	virtual Icon GetIcon();
	virtual String ToURL() const;
	virtual String GetUniqueName();
	virtual void CallWizardImpl();

private:
	DECL_LINK(OnCompress, void* );
	DECL_LINK( OnRelations, void* );
};

//-------------------------------------------------------------------------
// eine Tabelle

class SbaTableContent: public SbaDBContent
{
	Link aRenameLink;
protected:
	SbaTableContent():SbaDBContent(dbTable, CONTENT_INPLACECONSTRUCTION |
								   CONTENT_URLTOOPEN |
								   CONTENT_BROWSERVIEWAVAILABLE, TRUE){}

public:
	TYPEINFO();
	SbaTableContent(const String& rTitle, SbaDatabase* pDatabase);
	SbaTableContent(SbaDBDef& rObj);

protected:
	virtual Image GetImage( SfxExplorerContentImage eImage );
	virtual BOOL Initialize(const String&);
	virtual BOOL Initialize(SfxExplorerContent* pParent);
	virtual void Open(const String& rTargetFrame);
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual BOOL TitleEdited(SfxExplorerContentView*, const String& rNewTitel);
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);
	virtual BOOL Save();
	virtual void Destroy();

private:
	DECL_LINK(OnAddressbook, String* );
	DECL_LINK(OnRename, SfxContextMenuData*);
	DECL_LINK(OnDesignView, void* );
};


//-------------------------------------------------------------------------
// eine Datenbankview, wird nur zum erzeugen benoetigt
class SbaViewContent: public SbaTableContent
{
	Link aRenameLink;
	SbaViewContent(){}

public:
	TYPEINFO();

protected:
	virtual BOOL Initialize(SfxExplorerContent* pParent);
};


#endif


