package org.netbeans.modules.openoffice.wizard.panels.service;


import java.io.File;
import javax.swing.filechooser.FileFilter;

public class IDLFilter extends FileFilter {
    public final static String idl = "idl";
    
    // Accept all directories and all idl files.
    public boolean accept( File file ) {
        if ( file.isDirectory() ) {
            return true;
        }
        
        String extension = this.getExtension( file );
        if ( extension != null ) {
            if ( extension.equals( this.idl ) ) {
                return true;
            } else {
                return false;
            }
        }
        
        return false;
    }
    
    // The description of this filter
    public String getDescription() {
        return "UNO IDL Files";
    }
    
    /*
     * Get the extension of a file.
     */
    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');
        
        if ( i > 0 &&  i < s.length() - 1 ) {
            ext = s.substring( i + 1 ).toLowerCase();
        }
        return ext;
    }
}
