/*************************************************************************
 *
 *  $RCSfile: AccessController.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dbo $ $Date: 2000/12/21 13:34:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.security;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;

import com.sun.star.security.Permission;
import com.sun.star.security.XPrivilegedAction;
import com.sun.star.security.XAccessController;
import com.sun.star.security.XAccessControlContext;


//==================================================================================================
public class AccessController implements XAccessController,
										 XServiceInfo
{
    private static final boolean DEBUG = true;
	private static final String SERVICE_NAME = "com.sun.star.security.AccessController";

	//______________________________________________________________________________________________
	static final java.security.Permission toJavaPermission( Permission perm_ )
		throws com.sun.star.uno.RuntimeException
	{
		// no actions for runtime permission
		if (perm_.PermissionType.equals( "java.security.AllPermission" ))
		{
			if (DEBUG)
				System.err.println( "constructing " + perm_.PermissionType + "( String )..." );
			return new java.security.AllPermission( perm_.PermissionTarget );
		}
		if (perm_.PermissionType.equals( "java.lang.RuntimePermission" ))
		{
			if (DEBUG)
				System.err.println( "constructing " + perm_.PermissionType + "( String )..." );
			return new java.lang.RuntimePermission( perm_.PermissionTarget );
		}
		if (perm_.PermissionType.equals( "java.net.NetPermission" ))
		{
			if (DEBUG)
				System.err.println( "constructing " + perm_.PermissionType + "( String )..." );
			return new java.net.NetPermission( perm_.PermissionTarget );
		}
		if (perm_.PermissionType.equals( "java.security.SecurityPermission" ))
		{
			if (DEBUG)
				System.err.println( "constructing " + perm_.PermissionType + "( String )..." );
			return new java.security.SecurityPermission( perm_.PermissionTarget );
		}
		
		// find perm type
		Class type;
		try
		{
			type = Class.forName( perm_.PermissionType );
		}
		catch (Throwable exc)
		{
			if (DEBUG)
				System.err.println( "permission type not found!" );
			throw new com.sun.star.uno.RuntimeException(
				"permission type not found: " + exc.getMessage(), null );
		}
		// find ctor and construct permission
		java.security.Permission perm;
		// two strings
		try
		{
			perm = (java.security.Permission)type.getConstructor(
				new Class [] { String.class, String.class } ).newInstance(
					new Object [] { perm_.PermissionTarget, perm_.PermissionActions } );
			if (DEBUG)
				System.err.println( "constructing " + perm_.PermissionType + "( String, String )..." );
		}
		catch (Throwable exc)
		{
			// one string
			try
			{
				perm = (java.security.Permission)type.getConstructor(
					new Class [] { String.class } ).newInstance(
						new Object [] { perm_.PermissionTarget } );
				if (DEBUG)
					System.err.println( "constructing " + perm_.PermissionType + "( String )..." );
			}
			catch (Throwable exc1)
			{
				// def
				try
				{
					perm = (java.security.Permission)type.newInstance();
					if (DEBUG)
						System.err.println( "constructing " + perm_.PermissionType + "()..." );
				}
				catch (Throwable exc2)
				{
					if (DEBUG)
						System.err.println( "no appr ctor found!" );
					throw new com.sun.star.uno.RuntimeException(
						"no appropriate ctor found for permission: " + exc2.getMessage(), null );
				}
			}
		}
		return perm;
	}
	//______________________________________________________________________________________________
	static final Permission toPermission( java.security.Permission perm_ )
		throws com.sun.star.uno.RuntimeException
	{
		return new Permission(
			perm_.getClass().getName(), perm_.getName(), perm_.getActions() );
	}
	
	//______________________________________________________________________________________________
	public static final void rethrowException( java.security.PrivilegedActionException exc )
		throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException
	{
		Exception e = exc.getException();
		
		if (DEBUG)
			System.err.println( "> privileged action exception occured: " + e );
		
		if (e instanceof java.security.AccessControlException)
		{
			throw new com.sun.star.security.AccessControlException(
				e.getMessage(), null,
				toPermission( ((java.security.AccessControlException)e).getPermission() ) );
		}
		if (e instanceof java.lang.SecurityException)
		{
			throw new com.sun.star.uno.SecurityException(
				e.getMessage(), null );
		}
		if (e instanceof com.sun.star.uno.Exception)
		{
			throw (com.sun.star.uno.Exception)e;
		}
		
		if (DEBUG)
			System.err.println( "> unrecognized exception occured: " + e );
		throw new com.sun.star.uno.RuntimeException(
			e.getMessage(), null );
	}
	
	// XAccessController
	//______________________________________________________________________________________________
    public void checkPermission( Permission perm )
		throws com.sun.star.security.AccessControlException, com.sun.star.uno.RuntimeException
	{
		if (DEBUG)
			System.err.println( "> checkPermission( " + perm.PermissionType + " ) ..." );
		try
		{
			java.security.AccessController.checkPermission( toJavaPermission( perm ) );
		}
		catch (java.security.AccessControlException exc)
		{
			throw new com.sun.star.security.AccessControlException(
				exc.getMessage(), this, toPermission( exc.getPermission() ) );
		}
	}
	//______________________________________________________________________________________________
    public Object doPrivileged( XPrivilegedAction action, XAccessControlContext restriction )
		throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException
	{
		try
		{
			if (restriction == null)
			{
				return java.security.AccessController.doPrivileged(
					new PrivilegedExceptionAction( action ) );
			}
			else
			{
				return java.security.AccessController.doPrivileged(
					new PrivilegedExceptionAction( action ),
					AccessControlContext.getContext( restriction ) );
			}
		}
		catch (java.security.PrivilegedActionException exc)
		{
			rethrowException( exc );
			return null; // for dummy
		}
	}
	//______________________________________________________________________________________________
    public XAccessControlContext getContext()
		throws com.sun.star.uno.RuntimeException
	{
		return new AccessControlContext( java.security.AccessController.getContext() );
	}
	
	// XServiceInfo
    //______________________________________________________________________________________________
    public String getImplementationName() 
		throws com.sun.star.uno.RuntimeException
    {
        return AccessController.class.getName();
    }
    //______________________________________________________________________________________________
    public boolean supportsService( String serviceName ) 
		throws com.sun.star.uno.RuntimeException
    {
		return serviceName.equals( SERVICE_NAME );
    }
    //______________________________________________________________________________________________
    public String [] getSupportedServiceNames() 
		throws com.sun.star.uno.RuntimeException
	{
        return new String [] { SERVICE_NAME };
	}
	
	/**
	 * Returns the service factory for the <code>ServiceManager</code>. If the given implementation name 
	 * does not equal to the <code>ServiceManagers</code> class name null will be returned.
	 * <p>
	 * @return     the factory for the <code>ServiceManager</code>.
	 * @param      implName		the implementation name of the of the service. 
	 *                          Must be equal to <code>com.sun.star.comp.servicemanager.ServicManager</code>
	 * @param	   multiFactory	refernce of the <code>MultiServiceFactory</code>. This parameter will be ignored.
	 * @param	   regKey		the root key of the registry. This parameter will be ignored. 	
	 */
  	public static XSingleServiceFactory getServiceFactory(
		String implName, 
		XMultiServiceFactory multiFactory, 
		XRegistryKey regKey )
	{
	    if (implName.equals( AccessController.class.getName() ))
		{
			return new ServiceFactory(
				AccessController.class,
				new String [] { SERVICE_NAME } );
		}
		return null;
	}
}
