/*************************************************************************
 *
 *  $RCSfile: vdevcache.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: aw $ $Date: 2000/11/13 10:39:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _VDEVCACHE_HXX
#define _VDEVCACHE_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

class ImpVDCache;

//////////////////////////////////////////////////////////////////////////////

class VDevCacheEntry
{
	// pos and size
	Point						maPosition;
	Size						maSize;

	// tree position
	VDevCacheEntry*				mpParent;
	VDevCacheEntry*				mpLeft;
	VDevCacheEntry*				mpRight;

	// free list entry
	VDevCacheEntry*				mpNext;
	VDevCacheEntry*				mpPrev;

public:
	VDevCacheEntry(const Point& rPos, const Size& rSize, VDevCacheEntry* pParent)
	:	maPosition(rPos), maSize(rSize), mpParent(pParent),
		mpLeft(0L), mpRight(0L), mpNext(0L), mpPrev(0L)
	{}
	~VDevCacheEntry()
	{ if(mpLeft) delete mpLeft; if(mpRight) delete mpRight;	}

	VDevCacheEntry* GetParent() const { return mpParent; }
	VDevCacheEntry* GetLeft() const { return mpLeft; }
	VDevCacheEntry* GetRight() const { return mpRight; }
	const Point& GetPosition() const { return maPosition; }
	const Size& GetSize() const { return maSize; }

	// ONLY to be called by internal, reorganizing instances
	void ImpSetLeftRight(VDevCacheEntry* pNewL, VDevCacheEntry* pNewR) 
		{ mpLeft = pNewL; mpRight = pNewR; }
	void ImpSetParent(VDevCacheEntry* pNew) { mpParent = pNew; }

	BOOL IsSplit() const { return (mpLeft != 0L); }
	void SplitHorizontal(sal_uInt32 nLength);
	void SplitVertical(sal_uInt32 nLength);
	void Melt();

	VDevCacheEntry* GetNext() const { return mpNext; }
	VDevCacheEntry* GetPrev() const { return mpPrev; }
	void SetNext(VDevCacheEntry* pNew) { mpNext = pNew; }
	void SetPrev(VDevCacheEntry* pNew) { mpPrev = pNew; }
	BOOL IsInFreeList() const { return (mpNext || mpPrev); }
};

//////////////////////////////////////////////////////////////////////////////

class VDevCache
{
	ImpVDCache*					mpImp;

public:
	VDevCache(sal_uInt32 nInitialEdgeLen = 256);
	~VDevCache();

	// allocate area and fill from rSrcDev
	VDevCacheEntry* Allocate(const Point& rSrcPt,
		const Size& rSrcSize, const OutputDevice& rSrcDev);

	// copy from VDev to rDstDev
	void Copy(VDevCacheEntry* pEntry, const Point& rDstPt, OutputDevice& rDstDev);

	// copy only part from VDev to rDstDev
	void CopyPart(VDevCacheEntry* pEntry, const Point& rDstPt, 
		const Size& rDstSize, const Point& rSrcPntOffset, OutputDevice& rDstDev);

	// free area
	void Free(VDevCacheEntry* pEntry);

	// get used VDev (for copy from/to)
	const VirtualDevice& GetVDev() const;
};

//////////////////////////////////////////////////////////////////////////////

#endif // _VDEVCACHE_HXX
