/*************************************************************************
 *
 *  $RCSfile: b2dmbmp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: aw $ $Date: 2002/02/26 14:14:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_MBMP_HXX
#define _B2D_MBMP_HXX

#ifndef _B2D_MBASE_HXX
#include "b2dmbase.hxx"
#endif

//************************************************************
//   InterActionObjectBitmap
//************************************************************

class B2dIAOBitmapObj : public B2dIAObject
{
	// the Bitmap itself
	Bitmap						aBmp;

	// center of the Bitmap
	UINT16						nCenterX;
	UINT16						nCenterY;

	// shall the BaseColor be used to create transparence?
	unsigned					bUseTransCol : 1;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

public:
    TYPEINFO();
	B2dIAOBitmapObj(B2dIAOManager* pMan, Point aPos, const Bitmap& rBmp, 
		UINT16 nCenX = 0, UINT16 nCenY = 0, BOOL bUseTransCol = FALSE, 
		Color aTransCol = Color(COL_WHITE));
	virtual ~B2dIAOBitmapObj();

	const Bitmap& GetBitmap() const { return aBmp; }
	void SetBitmap(const Bitmap& rNew);

	BOOL IsTransparenceUsed() const { return bUseTransCol; }
	void SetTransparenceUsed(BOOL bNew);

	UINT16 GetCenterX() const { return nCenterX; }
	UINT16 GetCenterY() const { return nCenterY; }
	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
};

//************************************************************
//   InterActionObjectBitmapEx
//************************************************************

class B2dIAOBitmapEx : public B2dIAObject
{
	// the Bitmap itself
	BitmapEx					aBmpEx;

	// center of the Bitmap
	UINT16						nCenterX;
	UINT16						nCenterY;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

public:
    TYPEINFO();
	B2dIAOBitmapEx(B2dIAOManager* pMan, Point aPos, const BitmapEx& rBmpEx,
		UINT16 nCenX = 0, UINT16 nCenY = 0);
	virtual ~B2dIAOBitmapEx();

	const BitmapEx& GetBitmapEx() const { return aBmpEx; }
	void SetBitmapEx(const BitmapEx& rNew);

	UINT16 GetCenterX() const { return nCenterX; }
	UINT16 GetCenterY() const { return nCenterY; }
	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
};

//************************************************************
//   InterActionObjectBitmapExReference
//************************************************************

class B2dIAOBitmapExReference : public B2dIAObject
{
	// the Bitmap itself
	BitmapEx*					pBmpEx;

	// center of the Bitmap
	UINT16						nCenterX;
	UINT16						nCenterY;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

public:
    TYPEINFO();
	B2dIAOBitmapExReference(B2dIAOManager* pMan, Point aPos, BitmapEx* pBEx,
		UINT16 nCenX = 0, UINT16 nCenY = 0);
	virtual ~B2dIAOBitmapExReference();

	const BitmapEx* GetBitmapEx() const { return pBmpEx; }
	void SetBitmapEx(BitmapEx* pNew);

	UINT16 GetCenterX() const { return nCenterX; }
	UINT16 GetCenterY() const { return nCenterY; }
	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
};

//************************************************************
//   InterActionObjectAnimBitmapExReference
//************************************************************

// #97016# II
class B2dIAOAnimBmapExRef : public B2dIAObject
{
	// start step value
	UINT16						nStartCount;
	UINT16						nStartAdd;

	// the Bitmaps themselves
	BitmapEx*					pBmpEx1;
	BitmapEx*					pBmpEx2;

	// centers of the Bitmaps
	UINT16						nCenterX1;
	UINT16						nCenterY1;
	UINT16						nCenterX2;
	UINT16						nCenterY2;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

	// React on animation (optional)
	virtual void AnimationStep(UINT32 nAnimCounter);

public:
    TYPEINFO();
	B2dIAOAnimBmapExRef(
		B2dIAOManager* pMan, Point aPos, 
		BitmapEx* pBEx1, BitmapEx* pBEx2,
		UINT16 nCenX1 = 0, UINT16 nCenY1 = 0,
		UINT16 nCenX2 = 0, UINT16 nCenY2 = 0);
	virtual ~B2dIAOAnimBmapExRef();

	const BitmapEx* GetBitmapEx1() const { return pBmpEx1; }
	const BitmapEx* GetBitmapEx2() const { return pBmpEx2; }
	void SetBitmapEx1(BitmapEx* pNew);
	void SetBitmapEx2(BitmapEx* pNew);

	UINT16 GetCenterX1() const { return nCenterX1; }
	UINT16 GetCenterY1() const { return nCenterY1; }
	void SetCenterXY1(UINT16 nNewX, UINT16 nNewY);

	UINT16 GetCenterX2() const { return nCenterX2; }
	UINT16 GetCenterY2() const { return nCenterY2; }
	void SetCenterXY2(UINT16 nNewX, UINT16 nNewY);
};


#endif          // _B2D_MBMP_HXX
