/*************************************************************************
 *
 *  $RCSfile: register.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <address.hxx>
#include <usr/services.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <services.hxx>
#include <ldap.hxx>
#include <sdb.hxx>
#include <merging.hxx>
#include <xml.hxx>
#include <stream.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif

XInterfaceRef createAddressBookServices( const XMultiServiceFactoryRef& xMgr )
{
	UsrAny aServiceName( L"stardiv.one.address.AddressBookSource" );
	return xMgr->createInstanceWithArguments( 
		L"stardiv.one.address.MultiServiceFactory", 
		Sequence<UsrAny>(&aServiceName, 1 ) );
}


extern "C" BOOL EXTERN_SERVICE_CALLTYPE exService_writeRegEntry(
	const UNO_INTERFACE( XRegistryKey )* xUnoKey )
{
	XRegistryKeyRef xKey;
	XRegistryKeyRef xCreateKey;
	uno2smart( xKey, *xUnoKey );

  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceMerging.V10/UNO/SERVICES/stardiv.one.address.AddressBookSourceMerging"); // Impl Name
  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceMerging.V10/UNO/SERVICES/stardiv.one.address.AddressBookSource"); // Impl Name
  	xCreateKey = xKey->createKey(L"/stardiv.one.address.AddressBookSourceMerging.V10/Properties/UIName");
  	xCreateKey->setStringValue( L"Merging" );

  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceLDAP.V10/UNO/SERVICES/stardiv.one.address.AddressBookSourceLDAP"); // Impl Name
  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceLDAP.V10/UNO/SERVICES/stardiv.one.address.AddressBookSource"); // Impl Name
  	xCreateKey = xKey->createKey(L"/stardiv.one.address.AddressBookSourceLDAP.V10/Properties/UIName");
  	xCreateKey->setStringValue( L"LDAP" );

  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceSimpleDatabase.V10/UNO/SERVICES/stardiv.one.address.AddressBookSourceSimpleDatabase"); // Impl Name
  	xKey->createKey(L"/stardiv.one.address.AddressBookSourceSimpleDatabase.V10/UNO/SERVICES/stardiv.one.address.AddressBookSource"); // Impl Name
  	xCreateKey = xKey->createKey(L"/stardiv.one.address.AddressBookSourceLDAP.V10/Properties/UIName");
  	xCreateKey->setStringValue( L"SimpleDatabase" );

	xKey->createKey(L"/stardiv.one.address.AddressBookSourceSchedule.V10/UNO/SERVICES/stardiv.one.address.AddressBookSourceSchedule"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookSourceSchedule.V10/UNO/SERVICES/stardiv.one.address.AddressBookSource"); // Impl Name
	xCreateKey = xKey->createKey(L"/stardiv.one.address.AddressBookSourceSchedule.V10/Properties/UIName");
	xCreateKey->setStringValue( L"Schedule" );

	xKey->createKey(L"/stardiv.one.address.MultiServiceFactory.V10/UNO/SERVICES/stardiv.one.address.MultiServiceFactory"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookQueryParser.V10/UNO/SERVICES/stardiv.one.address.AddressBookQueryParser"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookSimpleSourceAdapter.V10/UNO/SERVICES/stardiv.one.address.AddressBookSimpleSourceAdapter"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookResultSetDescriptor.V10/UNO/SERVICES/stardiv.one.address.AddressBookResultSetDescriptor"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookServices.V10/UNO/SERVICES/stardiv.one.address.AddressBookServices"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookSources.V10/UNO/SERVICES/stardiv.one.address.AddressBookSources"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.SynchronAndAsynchronJobFactory.V10/UNO/SERVICES/stardiv.one.address.SynchronAndAsynchronJobFactory"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookSourceAccess.V10/UNO/SERVICES/stardiv.one.address.AddressBookSourceAccess"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.AddressBookCursor.V10/UNO/SERVICES/stardiv.one.address.AddressBookCursor"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.DatabaseDriverAddressBookSettings.V10/UNO/SERVICES/stardiv.one.address.DatabaseDriverAddressBookSettings"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.XMLImport.V10/UNO/SERVICES/stardiv.one.address.XMLImport"); // Impl Name
	xKey->createKey(L"/stardiv.one.address.InputStream.V10/UNO/SERVICES/stardiv.one.address.InputStream"); // Impl Name
	
	return TRUE;
}


extern "C" UNO_INTERFACE(XInterface) EXTERN_SERVICE_CALLTYPE exService_getFactory
(
	const sal_Unicode* implementationName,
	const UNO_INTERFACE(XMultiServiceFactory)* xUnoFact,
	const UNO_INTERFACE(XRegistryKey)* xUnoKey )
{
	UString implName( implementationName );
	XMultiServiceFactoryRef xMan;
	XRegistryKeyRef xKey;
	uno2smart( xMan, *xUnoFact );
	uno2smart( xKey, *xUnoKey );
	
	XInterfaceRef 			xRet;
	XServiceProviderRef xSSI;

	if( 0 );
	else if (implName == L"stardiv.one.address.InputStream.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.InputStream";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookInputStream::createInstance, aServices );
	}
	else if (implName == L"stardiv.one.address.XMLImport.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.XMLImport";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OXMLReader::createInstance, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSourceMerging.V10")
	{
		Sequence<UString> aServices(2);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSourceMerging";
		aServices.getArray()[ 1 ] = 
			L"stardiv.one.address.AddressBookSource";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookSourceMerging::create, aServices );
	}
	else if (implName == L"stardiv.one.address.DatabaseDriverAddressBookSettings.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.DatabaseDriverAddressBookSettings";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			OAddressBookDatabaseDriverSettings::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSourceSimpleDatabase.V10")
	{
		Sequence<UString> aServices(2);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSourceSimpleDatabase";
		aServices.getArray()[ 1 ] = 
			L"stardiv.one.address.AddressBookSource";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookSourceSimpleDatabase::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSourceLDAP.V10")
	{
		Sequence<UString> aServices(2);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSourceLDAP";
		aServices.getArray()[ 1 ] = 
			L"stardiv.one.address.AddressBookSource";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookSourceLDAP::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSourceSchedule.V10")
	{
		Sequence<UString> aServices(2);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSourceSchedule";
		aServices.getArray()[ 1 ] = 
			L"stardiv.one.address.AddressBookSource";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookSourceSchedule::create, aServices );
	}
//  	else if (implName == L"stardiv.one.address.AddressBookSimpleSourceAdapter.V10")
//  	{
//  		Sequence<UString> aServices(1);
//  		aServices.getArray()[ 0 ] = 
//  			L"stardiv.one.address.AddressBookSimpleSourceAdapter";
//  		xRet = createSingleFactory( 
//  			xMan, implementationName,
//  			OAddressBookSimpleSourceAdapter::createInstance, aServices );
//  	}
	else if (implName == L"stardiv.one.address.AddressBookResultSetDescriptor.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookResultSetDescriptor";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OResultSetDescriptor::createInstance, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookServices.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookServices";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			createAddressBookServices, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookQueryParser.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookQueryParser";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			OAddressBookQueryParser::createInstance, aServices );
	}
	else if (implName == L"stardiv.one.address.MultiServiceFactory.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.MultiServiceFactory";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OMultiServiceFactory::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSources.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSources";
		xRet = createOneInstanceFactory( 
			xMan, implementationName,
			OAddressBookSources::createInstance, aServices );
	}
	else if (implName == L"stardiv.one.address.SynchronAndAsynchronJobFactory.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.SynchronAndAsynchronJobFactory";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OGeneralJobFactory::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookSourceAccess.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookSourceAccess";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookSourceAccess::create, aServices );
	}
	else if (implName == L"stardiv.one.address.AddressBookCursor.V10")
	{
		Sequence<UString> aServices(1);
		aServices.getArray()[ 0 ] = 
			L"stardiv.one.address.AddressBookCursor";
		xRet = createSingleFactory( 
			xMan, implementationName,
			OAddressBookCursor::create, aServices );
	}
	UNO_INTERFACE(XInterface) xUnoRet = {0, 0};
	if( xRet.is() ) smart2uno( xRet, xUnoRet );
	return xUnoRet;
}


