/*************************************************************************
 *
 *  $RCSfile: TableFieldData.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: oj $ $Date: 2001/02/05 09:26:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_TABLEFIELDDATA_HXX
#include "TableFieldData.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_STREAMSECTION_HXX_
#include <comphelper/streamsection.hxx>
#endif
#ifndef _COMPHELPER_BASIC_IO_HXX_
#include <comphelper/basicio.hxx>
#endif

using namespace dbaui;
using namespace comphelper;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::uno;
DBG_NAME(OTableFieldData);
//------------------------------------------------------------------------------
OTableFieldData::OTableFieldData()
{
	DBG_CTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
OTableFieldData::OTableFieldData( const ::rtl::OUString& rFieldName, const ::rtl::OUString& rTableName, const ::rtl::OUString& rAliasName ) :
	m_aFieldName( rFieldName ),
	m_aTableName( rTableName ),
	m_aAliasName( rAliasName )
{
	DBG_CTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
OTableFieldData::~OTableFieldData()
{
	DBG_DTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
void OTableFieldData::Load(const Reference< XObjectInputStream>& _rxIn)
{
	DBG_CHKTHIS(OTableFieldData,NULL);
	OStreamSection aSection(_rxIn.get());
	_rxIn >> m_aFieldName;
	_rxIn >> m_aTableName;
	_rxIn >> m_aAliasName;
	_rxIn >> m_nColWidth;
}
//------------------------------------------------------------------------------
void OTableFieldData::Save(const Reference< XObjectOutputStream>& _rxOut)
{
	DBG_CHKTHIS(OTableFieldData,NULL);
	OStreamSection aSection(_rxOut.get());

	_rxOut << m_aFieldName;
	_rxOut << m_aTableName;
	_rxOut << m_aAliasName;
	_rxOut << m_nColWidth;
}
// -----------------------------------------------------------------------------

