/*************************************************************************
 *
 *  $RCSfile: uno2c.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dbo $ $Date: 2001/04/20 13:38:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _UNO_DATA_H_
#include <uno/data.h>
#endif
#ifndef _UNO_ANY2_H_
#include <uno/any2.h>
#endif

#include "c_bridge.hxx"


namespace c_uno
{

//==================================================================================================
static void uno2c_call(
	unoInterfaceProxy * pThis, sal_Int32 nFtableCall,
	typelib_TypeDescriptionReference * pReturnTypeRef,
	sal_Int32 nParams, typelib_MethodParameter * pParams,
	void * pUnoReturn, void * pUnoArgs[], uno_Any ** ppUnoExc ) SAL_THROW( () )
{
	OSL_ENSURE( sizeof (void *) == 4 && sizeof (sal_Int32) == 4, "### unexpected type sizes!" );
	
	// max space for: this, exc, [ret ptr], params ...
	char * pStack = (char *)alloca( 12 + (nParams * sizeof (sal_Int64)) );
	char * pStackStart = pStack;
	
	// push this
	*(void **)pStack = pThis->pCI;
	pStack += 4;
	uno_Any aExc;
	// push exc out
	*(void **)pStack = &aExc;
	pStack += 4;
	
	// return
	typelib_TypeDescription * pReturnTypeDescr = 0;
	if (pReturnTypeRef && pReturnTypeRef->eTypeClass != typelib_TypeClass_VOID)
	{
		if (pReturnTypeRef->eTypeClass <= typelib_TypeClass_ENUM &&
			pReturnTypeRef->eTypeClass != typelib_TypeClass_ANY)
		{
			*(void **)pStack = pUnoReturn;
		}
		else
		{
			TYPELIB_DANGER_GET( &pReturnTypeDescr, pReturnTypeRef );
			OSL_ENSURE( pReturnTypeDescr, "### expected return type description!" );
			*(void **)pStack = alloca( pReturnTypeDescr->nSize );
		}
		pStack += 4;
	}

	// prepare stack params
	void ** pCArgs  = (void **)alloca( 3 * sizeof (void *) * nParams );
	// indizes of values this have to be converted (interface conversion c<=>uno)
	sal_Int32 * pTempIndizes = (sal_Int32 *)(pCArgs + nParams);
	// type descriptions for reconversions
	typelib_TypeDescription ** ppTempParamTypeDescr = (typelib_TypeDescription **)(pCArgs + (2 * nParams));
	sal_Int32 nTempIndizes = 0;

	for ( sal_Int32 nPos = 0; nPos < nParams; ++nPos )
	{
		typelib_MethodParameter const & rParam = pParams[ nPos ];
		typelib_TypeClass tc = rParam.pTypeRef->eTypeClass;
		
		if (rParam.bOut) // inout/out, only pointers
		{
			if (tc != typelib_TypeClass_ANY && tc <= typelib_TypeClass_ENUM)
			{
				*(void **)pStack = pUnoArgs[ nPos ];
			}
			else
			{
				// convert to c
				typelib_TypeDescription * pParamTypeDescr = 0;
				TYPELIB_DANGER_GET( &pParamTypeDescr, rParam.pTypeRef );
				OSL_ASSERT( pParamTypeDescr && pParamTypeDescr->eTypeClass == tc );
				*(void **)pStack = pCArgs[ nPos ] = alloca( pParamTypeDescr->nSize );
				
				if (rParam.bIn)
				{
					::uno_copyAndConvertData(
						pCArgs[ nPos ], pUnoArgs[ nPos ],
						pParamTypeDescr, &pThis->pBridge->aUno2C );
				}
				
				ppTempParamTypeDescr[ nTempIndizes ] = pParamTypeDescr;
				pTempIndizes[ nTempIndizes ] = nPos;
				++nTempIndizes;
			}
		}
		else // pure in
		{
			if (tc > typelib_TypeClass_ENUM || tc == typelib_TypeClass_ANY)
			{
				// convert to c
				typelib_TypeDescription * pParamTypeDescr = 0;
				TYPELIB_DANGER_GET( &pParamTypeDescr, rParam.pTypeRef );
				OSL_ASSERT( pParamTypeDescr && pParamTypeDescr->eTypeClass == tc );
				
				if (tc == typelib_TypeClass_INTERFACE || tc == typelib_TypeClass_SEQUENCE)
				{
					pCArgs[ nPos ] = pStack;
				}
				else
				{
					pCArgs[ nPos ] = alloca( pParamTypeDescr->nSize );
					*(void **)pStack = pCArgs[ nPos ];
				}
				
				::uno_copyAndConvertData(
					pCArgs[ nPos ], pUnoArgs[ nPos ],
					pParamTypeDescr, &pThis->pBridge->aUno2C );
				
				ppTempParamTypeDescr[ nTempIndizes ] = pParamTypeDescr;
				pTempIndizes[ nTempIndizes ] = nPos;
				++nTempIndizes;
			}
			else
			{
				switch (tc)
				{
				case typelib_TypeClass_BOOLEAN:
				case typelib_TypeClass_BYTE:
					*(sal_Int8 *)pStack = *(sal_Int8 *)pUnoArgs[ nPos ];
					break;
				case typelib_TypeClass_CHAR:
				case typelib_TypeClass_SHORT:
				case typelib_TypeClass_UNSIGNED_SHORT:
					*(sal_Int16 *)pStack = *(sal_Int16 *)pUnoArgs[ nPos ];
					break;
				case typelib_TypeClass_HYPER:
				case typelib_TypeClass_UNSIGNED_HYPER:
				case typelib_TypeClass_DOUBLE:
					*(sal_Int64 *)pStack = *(sal_Int64 *)pUnoArgs[ nPos ];
					pStack += 4; // extra long
					break;
				case typelib_TypeClass_STRING:
				case typelib_TypeClass_TYPE:
					*(void **)pStack = *(void **)pUnoArgs[ nPos ];
					break;
				default:
					*(sal_Int32 *)pStack = *(sal_Int32 *)pUnoArgs[ nPos ];
				}
			}
		}
		pStack += 4;
	}
	
	// call c function
	if (CUNO_EXCEPTION_OCCURED( call_c_function(
		((void **)*pThis->pCI)[ nFtableCall ], pStackStart, (pStack - pStackStart) / 4 ) ))
	{
		// temporary in/inout params
		while (nTempIndizes--)
		{
			sal_Int32 nIndex = pTempIndizes[ nTempIndizes ];
			typelib_TypeDescription * pParamTypeDescr = ppTempParamTypeDescr[ nTempIndizes ];
			
			if (pParams[ nIndex ].bIn) // is in/inout => was constructed
			{
				::uno_destructData( pCArgs[ nIndex ], pParamTypeDescr, c_release );
			}
			
			TYPELIB_DANGER_RELEASE( pParamTypeDescr );
		}
		
		if (pReturnTypeDescr)
		{
			TYPELIB_DANGER_RELEASE( pReturnTypeDescr );
		}
		
		// signal exception
		::uno_type_any_constructAndConvert(
			*ppUnoExc, aExc.pData, aExc.pType, &pThis->pBridge->aC2Uno );
		::uno_any_destruct( &aExc, c_release );
	}
	else // no exception occured
	{
		// temporary in/inout params
		while (nTempIndizes--)
		{
			sal_Int32 nIndex = pTempIndizes[ nTempIndizes ];
			typelib_TypeDescription * pParamTypeDescr = ppTempParamTypeDescr[ nTempIndizes ];
			
			if (pParams[ nIndex ].bIn) // in/inout
			{
				if (pParams[ nIndex ].bOut) // inout => assign
				{
					::uno_destructData( pUnoArgs[ nIndex ], pParamTypeDescr, 0 );
					// write back
					::uno_copyAndConvertData(
						pUnoArgs[ nIndex ], pCArgs[ nIndex ], pParamTypeDescr,
						&pThis->pBridge->aC2Uno );
				}
			}
			else // pure out
			{
				// write back
				::uno_copyAndConvertData(
					pUnoArgs[ nIndex ], pCArgs[ nIndex ], pParamTypeDescr,
					&pThis->pBridge->aC2Uno );
			}
			// destroy temp c param
			::uno_destructData( pCArgs[ nIndex ], pParamTypeDescr, c_release );
			
			TYPELIB_DANGER_RELEASE( pParamTypeDescr );
		}
		
		if (pReturnTypeDescr)
		{
			::uno_copyAndConvertData(
				pUnoReturn, ((void **)pStackStart)[ 2 ], pReturnTypeDescr,
				&pThis->pBridge->aC2Uno );
			// destroy temp c return
			::uno_destructData( ((void **)pStackStart)[ 2 ], pReturnTypeDescr, c_release );
			TYPELIB_DANGER_RELEASE( pReturnTypeDescr );
		}

		// no exception
		*ppUnoExc = 0;
	}
}

//==================================================================================================
extern "C" void SAL_CALL unoInterfaceProxy_dispatch(
	uno_Interface * pUnoI, const typelib_TypeDescription * pMemberDescr,
	void * pUnoRet, void * pUnoArgs[], uno_Any ** ppUnoExc ) SAL_THROW_EXTERN_C()
{
	// is my surrogate
	unoInterfaceProxy * pThis = static_cast< unoInterfaceProxy * >( pUnoI );
	typelib_InterfaceTypeDescription * pTypeDescr = pThis->pTypeDescr;
	
	switch (pMemberDescr->eTypeClass)
	{
	case typelib_TypeClass_INTERFACE_ATTRIBUTE:
	{
		// determine ftable call index
		sal_Int32 nMemberPos = ((typelib_InterfaceMemberTypeDescription *)pMemberDescr)->nPosition;
		OSL_ENSURE( nMemberPos < pTypeDescr->nAllMembers, "### member pos out of range!" );
		
		sal_Int32 nFtableCall = pTypeDescr->pMapMemberIndexToFunctionIndex[ nMemberPos ];
		OSL_ENSURE( nFtableCall < pTypeDescr->nMapFunctionIndexToMemberIndex, "### illegal ftable index!" );
		
		if (pUnoRet)
		{
			// dependent dispatch
			uno2c_call(
				pThis, nFtableCall,
				((typelib_InterfaceAttributeTypeDescription *)pMemberDescr)->pAttributeTypeRef,
				0, 0, // no params
				pUnoRet, pUnoArgs, ppUnoExc );
		}
		else
		{
			// is SET
			typelib_MethodParameter aParam;
			aParam.pTypeRef = ((typelib_InterfaceAttributeTypeDescription *)pMemberDescr)->pAttributeTypeRef;
			aParam.bIn = sal_True;
			aParam.bOut = sal_False;
			
			// dependent dispatch
			uno2c_call(
				pThis, nFtableCall +1, // get, then set method
				0, // indicates VOID
				1, &aParam,
				pUnoRet, pUnoArgs, ppUnoExc );
		}
		
		break;
	}
	case typelib_TypeClass_INTERFACE_METHOD:
	{
		// determine ftable call index
		sal_Int32 nMemberPos = ((typelib_InterfaceMemberTypeDescription *)pMemberDescr)->nPosition;
		OSL_ENSURE( nMemberPos < pTypeDescr->nAllMembers, "### member pos out of range!" );
		
		sal_Int32 nFtableCall = pTypeDescr->pMapMemberIndexToFunctionIndex[nMemberPos];
		OSL_ENSURE( nFtableCall < pTypeDescr->nMapFunctionIndexToMemberIndex, "### illegal ftable index!" );
		
		switch (nFtableCall) // standard calls
		{
		case 0: // queryInterface() opt
		{
			typelib_TypeDescription * pTD = 0;
			TYPELIB_DANGER_GET( &pTD, *(typelib_TypeDescriptionReference **)pUnoArgs[ 0 ] );
			OSL_ASSERT( pTD );
			
			uno_Interface * pInterface = 0;
			(*pThis->pBridge->pUnoEnv->getRegisteredInterface)(
				pThis->pBridge->pUnoEnv,
				(void **)&pInterface, pThis->oid.pData, (typelib_InterfaceTypeDescription *)pTD );
			
			if (pInterface)
			{
				::uno_any_construct( reinterpret_cast< uno_Any * >( pUnoRet ), &pInterface, pTD, 0 );
				(*pInterface->release)( pInterface );
				*ppUnoExc = 0;
				TYPELIB_DANGER_RELEASE( pTD );
				break;
			}
			TYPELIB_DANGER_RELEASE( pTD );

			void * pStack[ 4 ];
			uno_Any aExc;
			com_sun_star_uno_XInterface * pCRet;
			pStack[ 0 ] = pThis->pCI;
			pStack[ 1 ] = &aExc;
			pStack[ 2 ] = &pCRet;
			pStack[ 3 ] = *(typelib_TypeDescriptionReference **)pUnoArgs[ 0 ];
			
			if (CUNO_EXCEPTION_OCCURED( call_c_function(
				((void **)*pThis->pCI)[ nFtableCall ], pStack, 4 ) ))
			{
				// pass exception
				::uno_type_any_constructAndConvert(
					*ppUnoExc, aExc.pData, aExc.pType, &pThis->pBridge->aC2Uno );
				::uno_any_destruct( &aExc, c_release );
			}
			else
			{
				if (pCRet)
				{
					::uno_type_any_constructAndConvert(
						(uno_Any *)pUnoRet, &pCRet,
						*(typelib_TypeDescriptionReference **)pUnoArgs[ 0 ],
						&pThis->pBridge->aC2Uno );
					CUNO_CALL(pCRet)->release( pCRet );
				}
				else
				{
					::uno_any_construct( (uno_Any *)pUnoRet, 0, 0, 0 );
				}
				*ppUnoExc = 0;
			}
			break;
		}
		case 1: // acquire uno interface
			(*pUnoI->acquire)( pUnoI );
			*ppUnoExc = 0;
			break;
		case 2: // release uno interface
			(*pUnoI->release)( pUnoI );
			*ppUnoExc = 0;
			break;
		default:
			// dependent dispatch
			uno2c_call(
				pThis, nFtableCall,
				((typelib_InterfaceMethodTypeDescription *)pMemberDescr)->pReturnTypeRef,
				((typelib_InterfaceMethodTypeDescription *)pMemberDescr)->nParams,
				((typelib_InterfaceMethodTypeDescription *)pMemberDescr)->pParams,
				pUnoRet, pUnoArgs, ppUnoExc );
			break;
		}
	}
	// xxx todo: throw RuntimeException
//  	default:
//  	{
//  		::com::sun::star::uno::RuntimeException aExc(
//  			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("illegal member type description!") ),
//  			::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
		
//  		Type const & rExcType = ::getCppuType( &aExc );
//  		// null reference binary identical
//  		::uno_type_any_construct( *ppException, &aExc, rExcType.getTypeLibType(), 0 );
//  	}
	}
}

}
