/*************************************************************************
 *
 *  $RCSfile: predecla.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_PREDECLA_HXX
#define ARY_CPP_PREDECLA_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <ary/ids.hxx>
	// PARAMETERS
#include <ary/cpp/ca_type.hxx>


namespace ary
{
namespace cpp
{
	class UsedType;
	class Namespace;
	class Class;

	class ToNode_Namespace;
	class ToNode_Class;


class TypeOwnerNode
{
  public:
	virtual				~TypeOwnerNode() {}

	// OPERATIONS
	void     			Add_Type(
							const UsedType &   	i_rType );
	void				Add_LocalOwner(
							ToNode_Namespace & 	i_rNode_Nsp );
	void				Add_LocalOwner(
							ToNode_Class & 		i_rNode_Class );

	// INQUIRY
	Cid                 Id_Ce() const;
	const udmstri &		LocalName() const;
	const Type *      	Search_Type(
							const UsedType &    i_rType ) const;
	// ACCESS
	TypeOwnerNode *		Search_LocalOwner(
							const Namespace &   i_rNsp );
	TypeOwnerNode *		Search_LocalOwner(
							const Class &       i_rClass );
  protected:
	struct CheshireCat;

  private:
	CheshireCat &		access_Data() const;
	virtual CheshireCat &
						access_Data() = 0;
	virtual void	   	do_Add_LocalOwner(
							ToNode_Namespace & 	i_rNode_Nsp ) = 0;
	virtual TypeOwnerNode *
						access_Search_LocalOwner(
							const Namespace &   i_rNsp ) = 0;
};


class ToNode_Namespace : public TypeOwnerNode
{
  public:
						ToNode_Namespace(
							const Namespace &	i_nRelatedNamespace,
							TypeOwnerNode *		i_pParent );
						~ToNode_Namespace();
  private:
	// Interface TypeOwnerNode:
	virtual CheshireCat &
						access_Data();
	virtual void	   	do_Add_LocalOwner(
							ToNode_Namespace & 	i_rNode_Nsp );
	virtual TypeOwnerNode *
						access_Search_LocalOwner(
							const Namespace &   i_rNsp );

	// Locals
	typedef std::map< udmstri, ToNode_Namespace * >	Index_Name2NspNode;

	// DATA
	Dyn<CheshireCat>	pNode;
	Index_Name2NspNode	aNamespace_Children;
};

class ToNode_Class : public TypeOwnerNode
{
  public:
						ToNode_Class(
							const Class &		i_nRelatedClass,
							TypeOwnerNode *		i_pParent );
						~ToNode_Class();
  private:
	// Interface TypeOwnerNode:
	virtual CheshireCat &
						access_Data();
	virtual void	   	do_Add_LocalOwner(
							ToNode_Namespace & 	i_rNode_Nsp );
	virtual TypeOwnerNode *
						access_Search_LocalOwner(
							const Namespace &   i_rNsp );
	// DATA
	Dyn<CheshireCat>	pNode;
};


// IMPLEMENTATION

inline TypeOwnerNode::CheshireCat &
TypeOwnerNode::access_Data() const
	{ return const_cast< TypeOwnerNode* >(this)->access_Data(); }

inline void
TypeOwnerNode::Add_LocalOwner( ToNode_Namespace & i_rNode_Nsp )
	{ do_Add_LocalOwner( i_rNode_Nsp ); }

inline TypeOwnerNode *
TypeOwnerNode::Search_LocalOwner( const Namespace & i_rNsp )
	{ return access_Search_LocalOwner( i_rNsp ); }




}   // namespace cpp
}   // namespace ary



#endif

