/*************************************************************************
 *
 *  $RCSfile: XmlSearchServerImpl.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.IOException;
import java.io.File;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;

import org.w3c.dom.*;

import com.sun.xmlsearch.util.Configuration;

public final class XmlSearchServerImpl implements XmlSearchServer {
    private static final int DefaultShuttleDelayMsec = 250;
    private QueryProcessorImpl _queryProcessor;
    private int _shuttleDelay = DefaultShuttleDelayMsec;
    private Searcher _searcher = null;
    private Search         _search;
    private Search         _shuttle;
    private int            _queryCount = 0;

    private final class Searcher extends Thread {
	public void run() {
	LOOP: while (true) {
	    try {
		Thread.sleep(_shuttleDelay);
		if (shuttle()) {
		    long start = System.currentTimeMillis();
		    _shuttle.startSearch();
		    _shuttle.results();
		    System.out.println((System.currentTimeMillis()-start)+" msec search");
		}
	    }
	    catch (InterruptedException e) {
		System.out.println("Searcher InterruptedException");
		break LOOP;
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	}
	}
    } // end of Searcher
  
    public XmlSearchServerImpl(Element el) throws RemoteException {
	super();
	try {
	    UnicastRemoteObject.exportObject(this);
	    System.out.println("XmlSearchServerImpl: " + el.getTagName());
	    processSearchServerConfig(el);
	}
	catch (Exception e) {
	    throw new RemoteException("nested exception is:", e);
	}
    }

    public String getName() throws Exception {
	return _queryProcessor.getName();
    }
  
    public String getClassification() throws Exception {
	return _queryProcessor.getClassification();
    }
  
    public String getDocumentType() {
	return _queryProcessor.getDocumentType();
    }
  
    private void processSearchServerConfig(Element xssConfig) throws Exception {
	final NodeList list2 = xssConfig.getElementsByTagName("XmlSearchEngine");
	if (list2.getLength() == 1) {
	    final Element qpConfig = (Element)list2.item(0);
	    _queryProcessor = new QueryProcessorImpl();
	    if (_queryProcessor.init(qpConfig)) {
		_search = _queryProcessor.makeSearch();
		_searcher = new Searcher();
		_searcher.start();
	    }
	    else
		throw new Exception("QueryProcessor could not be initialized");
	}
	else
	    throw new Exception("configuration of one XmlSearchEngine expected");
      
	String shuttleDelay = xssConfig.getAttribute("shuttleDelayMsec");
	if (shuttleDelay != null) {
	    System.out.println(shuttleDelay);
	    _shuttleDelay = Integer.parseInt(shuttleDelay);
	}
	System.out.println("shuttle delay: " + _shuttleDelay + " msec");
    }

    private synchronized boolean shuttle() {
	if (_queryCount > 0) {
	    _shuttle = _search;
	    _search = _queryProcessor.makeSearch();
	    _queryCount = 0;		// taken care of
	    return true;
	}
	else
	    return false;
    }

    /** The main function to be called by clients */
    public QueryResults processQuery(QueryStatement queryStatement)
	throws RemoteException {
	try {
	    Query query;
	    System.out.println("got query: " + queryStatement);
	    synchronized (_search) {
		query = _queryProcessor.processQuery(_search, queryStatement);
		_queryCount++;
	    }
	    synchronized (query) {
		query.wait();
	    }
	    return _queryProcessor.makeQueryResults(query, queryStatement);
	}
	catch (Exception e) {
	    throw new RemoteException(queryStatement.toString(), e);
	}
    }
  
    public void close() {
	(new Thread() {
		public void run(){
		    try {
			_searcher.interrupt();
			_queryProcessor.close();
		    }
		    catch (Exception e) {
			System.err.println(e);
		    }
		}}).start();
    }
}
