/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

public class EndianConverter {
    public static double readDouble(byte[] byArray) {
        long l = ((long)byArray[7] << 56) + ((long)(byArray[6] & 0xFF) << 48) + ((long)(byArray[5] & 0xFF) << 40) + ((long)(byArray[4] & 0xFF) << 32) + ((long)(byArray[3] & 0xFF) << 24) + ((long)(byArray[2] & 0xFF) << 16) + ((long)(byArray[1] & 0xFF) << 8) + (long)(byArray[0] & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static int readInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            n |= (byArray[n2] & 0xFF) << n2 * 8;
            ++n2;
        }
        return n;
    }

    public static short readShort(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        int n2 = byArray[0] & 0xFF;
        return (short)(n << 8 | n2);
    }

    public static byte[] writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        byte[] byArray = new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)};
        return byArray;
    }

    public static byte[] writeInt(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        return byArray;
    }

    public static byte[] writeShort(short s) {
        byte[] byArray = new byte[]{(byte)s, (byte)(s >>> 8)};
        return byArray;
    }
}

