/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class PathElements {
    private static final String DELIMITER = "/";
    private String name;
    private StringTokenizer tokenizer;
    private List tokens;

    public PathElements(String string) {
        this.name = string;
        this.tokenizer = new StringTokenizer(string, DELIMITER);
        this.tokens = new ArrayList(10);
    }

    public String getOriginalName() {
        return this.name;
    }

    public Enumeration getEnumeration() {
        return new EnumerationImpl(this);
    }

    boolean contains(int n) {
        if (this.tokens.size() <= n) {
            this.scanUpTo(n);
        }
        return this.tokens.size() > n;
    }

    String get(int n) throws NoSuchElementException {
        if (this.tokens.size() <= n) {
            this.scanUpTo(n);
        }
        if (this.tokens.size() <= n) {
            throw new NoSuchElementException();
        }
        return (String)this.tokens.get(n);
    }

    private synchronized void scanUpTo(int n) {
        if (this.tokenizer == null) {
            return;
        }
        if (this.tokens.size() > n) {
            return;
        }
        int n2 = this.tokens.size() - 1;
        while (n2 < n && this.tokenizer.hasMoreTokens()) {
            this.tokens.add(this.tokenizer.nextToken());
            ++n2;
        }
        if (!this.tokenizer.hasMoreTokens()) {
            this.tokenizer = null;
        }
    }

    static final class EnumerationImpl
    implements Enumeration {
        private PathElements elements;
        private int pos;

        EnumerationImpl(PathElements pathElements) {
            this.elements = pathElements;
            this.pos = 0;
        }

        public boolean hasMoreElements() {
            return this.elements.contains(this.pos);
        }

        public Object nextElement() throws NoSuchElementException {
            return this.elements.get(this.pos++);
        }
    }
}

