/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.HelpSetFactory;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.CheckLinks;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CheckHelpSets
extends Task {
    private List filesets = new ArrayList();

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void execute() throws BuildException {
        Iterator iterator = this.filesets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            File file = directoryScanner.getBasedir();
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                try {
                    this.checkHelpSet(file2);
                }
                catch (BuildException buildException) {
                    throw buildException;
                }
                catch (Exception exception) {
                    throw new BuildException("Error checking helpset", (Throwable)exception, new Location(file2.getAbsolutePath()));
                }
                ++n;
            }
        }
    }

    private void checkHelpSet(File file) throws Exception {
        Serializable serializable;
        Object object;
        this.log("Checking helpset: " + file);
        HelpSet helpSet = new HelpSet(null, file.toURL());
        Map map = helpSet.getCombinedMap();
        this.log("Parsed helpset, checking map IDs in TOC/Index navigators...");
        NavigatorView[] navigatorViewArray = helpSet.getNavigatorViews();
        int n = 0;
        while (n < navigatorViewArray.length) {
            object = navigatorViewArray[n].getName();
            serializable = new File(file.getParentFile(), (String)navigatorViewArray[n].getParameters().get("data"));
            if (!((File)serializable).exists()) {
                throw new BuildException("Navigator " + (String)object + " not found", new Location(((File)serializable).getAbsolutePath()));
            }
            if (navigatorViewArray[n] instanceof IndexView) {
                this.log("Checking index navigator " + (String)object, 3);
                IndexView.parse((URL)((File)serializable).toURL(), (HelpSet)helpSet, (Locale)Locale.getDefault(), (TreeItemFactory)new VerifyTIFactory(helpSet, map, (File)serializable, false));
            } else if (navigatorViewArray[n] instanceof TOCView) {
                this.log("Checking TOC navigator " + (String)object, 3);
                TOCView.parse((URL)((File)serializable).toURL(), (HelpSet)helpSet, (Locale)Locale.getDefault(), (TreeItemFactory)new VerifyTIFactory(helpSet, map, (File)serializable, true));
            } else {
                this.log("Skipping non-TOC/Index view: " + (String)object, 3);
            }
            ++n;
        }
        this.log("Checking for duplicate map IDs...");
        HelpSet.parse((URL)file.toURL(), null, (HelpSetFactory)new VerifyHSFactory());
        this.log("Checking links from help map and between HTML files...");
        object = map.getAllIDs();
        serializable = new HashSet(1000);
        HashSet hashSet = new HashSet(1000);
        HashSet hashSet2 = new HashSet(1000);
        while (object.hasMoreElements()) {
            Map.ID iD = (Map.ID)object.nextElement();
            URL uRL = map.getURLFromID(iD);
            if (uRL == null) {
                throw new BuildException("Bogus map ID: " + iD.id, new Location(file.getAbsolutePath()));
            }
            this.log("Checking ID " + iD.id, 3);
            CheckLinks.scan(this, iD.id, uRL, (Set)((Object)serializable), hashSet, hashSet2, false, 2);
        }
    }

    private final class VerifyHSFactory
    extends HelpSet.DefaultHelpSetFactory {
        private Set ids = new HashSet(1000);

        private VerifyHSFactory() {
        }

        public void processMapRef(HelpSet helpSet, Hashtable hashtable) {
            try {
                URL uRL = new URL(helpSet.getHelpSetURL(), (String)hashtable.get("location"));
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(false);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(new InputSource(uRL.toExternalForm()), (HandlerBase)new Handler(uRL.getFile()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private final class Handler
        extends HandlerBase {
            private final String map;

            public Handler(String string) {
                this.map = string;
            }

            public void startElement(String string, AttributeList attributeList) {
                String string2;
                if (string.equals("mapID") && (string2 = attributeList.getValue("target")) != null) {
                    if (VerifyHSFactory.this.ids.add(string2)) {
                        CheckHelpSets.this.log("Found map ID: " + string2, 4);
                    } else {
                        CheckHelpSets.this.log(this.map + ": duplicated ID: " + string2, 1);
                    }
                }
            }

            public InputSource resolveEntity(String string, String string2) throws SAXException {
                if (string.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN")) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                return super.resolveEntity(string, string2);
            }
        }
    }

    private final class VerifyTIFactory
    implements TreeItemFactory {
        private final HelpSet hs;
        private final Map map;
        private final File navfile;
        private final boolean toc;

        public VerifyTIFactory(HelpSet helpSet, Map map, File file, boolean bl) {
            this.hs = helpSet;
            this.map = map;
            this.navfile = file;
            this.toc = bl;
        }

        public TreeItem createItem(String string, Hashtable hashtable, HelpSet helpSet, Locale locale) {
            String string2 = (String)hashtable.get("target");
            if (string2 != null) {
                if (!this.map.isValidID(string2, this.hs)) {
                    CheckHelpSets.this.log(this.navfile + ": invalid map ID: " + string2, 1);
                } else {
                    CheckHelpSets.this.log("OK map ID: " + string2, 3);
                }
            }
            return this.createItem();
        }

        public Enumeration listMessages() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void processPI(HelpSet helpSet, String string, String string2) {
        }

        public void reportMessage(String string, boolean bl) {
            CheckHelpSets.this.log(string, bl ? 3 : 1);
        }

        public void processDOCTYPE(String string, String string2, String string3) {
        }

        public void parsingStarted(URL uRL) {
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode defaultMutableTreeNode) {
            return defaultMutableTreeNode;
        }

        public TreeItem createItem() {
            if (this.toc) {
                return new TOCItem();
            }
            return new IndexItem();
        }
    }
}

