//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgfont?language=objc)
#[repr(C)]
pub struct CGFont {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGFont {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGFont"> for CGFont {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgfontindex?language=objc)
pub type CGFontIndex = c_ushort;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgglyph?language=objc)
pub type CGGlyph = CGFontIndex;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgfontpostscriptformat?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGFontPostScriptFormat(pub i32);
impl CGFontPostScriptFormat {
    #[doc(alias = "kCGFontPostScriptFormatType1")]
    pub const Type1: Self = Self(1);
    #[doc(alias = "kCGFontPostScriptFormatType3")]
    pub const Type3: Self = Self(3);
    #[doc(alias = "kCGFontPostScriptFormatType42")]
    pub const Type42: Self = Self(42);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGFontPostScriptFormat {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGFontPostScriptFormat {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontindexmax?language=objc)
pub static kCGFontIndexMax: CGFontIndex = 65534;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontindexinvalid?language=objc)
pub static kCGFontIndexInvalid: CGFontIndex = 65535;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgglyphmax?language=objc)
pub static kCGGlyphMax: CGFontIndex = kCGFontIndexMax;

unsafe impl ConcreteType for CGFont {
    #[doc(alias = "CGFontGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGFontGetTypeID() -> CFTypeID;
        }
        unsafe { CGFontGetTypeID() }
    }
}

impl CGFont {
    #[doc(alias = "CGFontCreateWithPlatformFont")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn with_platform_font(
        platform_font_reference: *mut c_void,
    ) -> Option<CFRetained<CGFont>> {
        extern "C-unwind" {
            fn CGFontCreateWithPlatformFont(
                platform_font_reference: *mut c_void,
            ) -> Option<NonNull<CGFont>>;
        }
        let ret = unsafe { CGFontCreateWithPlatformFont(platform_font_reference) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCreateWithDataProvider")]
    #[cfg(feature = "CGDataProvider")]
    #[inline]
    pub unsafe fn with_data_provider(provider: &CGDataProvider) -> Option<CFRetained<CGFont>> {
        extern "C-unwind" {
            fn CGFontCreateWithDataProvider(provider: &CGDataProvider) -> Option<NonNull<CGFont>>;
        }
        let ret = unsafe { CGFontCreateWithDataProvider(provider) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCreateWithFontName")]
    #[inline]
    pub unsafe fn with_font_name(name: Option<&CFString>) -> Option<CFRetained<CGFont>> {
        extern "C-unwind" {
            fn CGFontCreateWithFontName(name: Option<&CFString>) -> Option<NonNull<CGFont>>;
        }
        let ret = unsafe { CGFontCreateWithFontName(name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCreateCopyWithVariations")]
    #[inline]
    pub unsafe fn new_copy_with_variations(
        font: Option<&CGFont>,
        variations: Option<&CFDictionary>,
    ) -> Option<CFRetained<CGFont>> {
        extern "C-unwind" {
            fn CGFontCreateCopyWithVariations(
                font: Option<&CGFont>,
                variations: Option<&CFDictionary>,
            ) -> Option<NonNull<CGFont>>;
        }
        let ret = unsafe { CGFontCreateCopyWithVariations(font, variations) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontGetNumberOfGlyphs")]
    #[inline]
    pub unsafe fn number_of_glyphs(font: Option<&CGFont>) -> usize {
        extern "C-unwind" {
            fn CGFontGetNumberOfGlyphs(font: Option<&CGFont>) -> usize;
        }
        unsafe { CGFontGetNumberOfGlyphs(font) }
    }

    #[doc(alias = "CGFontGetUnitsPerEm")]
    #[inline]
    pub unsafe fn units_per_em(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetUnitsPerEm(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetUnitsPerEm(font) }
    }

    #[doc(alias = "CGFontCopyPostScriptName")]
    #[inline]
    pub unsafe fn post_script_name(font: Option<&CGFont>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CGFontCopyPostScriptName(font: Option<&CGFont>) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CGFontCopyPostScriptName(font) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCopyFullName")]
    #[inline]
    pub unsafe fn full_name(font: Option<&CGFont>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CGFontCopyFullName(font: Option<&CGFont>) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CGFontCopyFullName(font) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontGetAscent")]
    #[inline]
    pub unsafe fn ascent(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetAscent(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetAscent(font) }
    }

    #[doc(alias = "CGFontGetDescent")]
    #[inline]
    pub unsafe fn descent(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetDescent(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetDescent(font) }
    }

    #[doc(alias = "CGFontGetLeading")]
    #[inline]
    pub unsafe fn leading(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetLeading(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetLeading(font) }
    }

    #[doc(alias = "CGFontGetCapHeight")]
    #[inline]
    pub unsafe fn cap_height(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetCapHeight(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetCapHeight(font) }
    }

    #[doc(alias = "CGFontGetXHeight")]
    #[inline]
    pub unsafe fn x_height(font: Option<&CGFont>) -> c_int {
        extern "C-unwind" {
            fn CGFontGetXHeight(font: Option<&CGFont>) -> c_int;
        }
        unsafe { CGFontGetXHeight(font) }
    }

    #[doc(alias = "CGFontGetFontBBox")]
    #[inline]
    pub unsafe fn font_b_box(font: Option<&CGFont>) -> CGRect {
        extern "C-unwind" {
            fn CGFontGetFontBBox(font: Option<&CGFont>) -> CGRect;
        }
        unsafe { CGFontGetFontBBox(font) }
    }

    #[doc(alias = "CGFontGetItalicAngle")]
    #[inline]
    pub unsafe fn italic_angle(font: Option<&CGFont>) -> CGFloat {
        extern "C-unwind" {
            fn CGFontGetItalicAngle(font: Option<&CGFont>) -> CGFloat;
        }
        unsafe { CGFontGetItalicAngle(font) }
    }

    #[doc(alias = "CGFontGetStemV")]
    #[inline]
    pub unsafe fn stem_v(font: Option<&CGFont>) -> CGFloat {
        extern "C-unwind" {
            fn CGFontGetStemV(font: Option<&CGFont>) -> CGFloat;
        }
        unsafe { CGFontGetStemV(font) }
    }

    #[doc(alias = "CGFontCopyVariationAxes")]
    #[inline]
    pub unsafe fn variation_axes(font: Option<&CGFont>) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CGFontCopyVariationAxes(font: Option<&CGFont>) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CGFontCopyVariationAxes(font) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCopyVariations")]
    #[inline]
    pub unsafe fn variations(font: Option<&CGFont>) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CGFontCopyVariations(font: Option<&CGFont>) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CGFontCopyVariations(font) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontGetGlyphAdvances")]
    #[inline]
    pub unsafe fn glyph_advances(
        font: Option<&CGFont>,
        glyphs: NonNull<CGGlyph>,
        count: usize,
        advances: NonNull<c_int>,
    ) -> bool {
        extern "C-unwind" {
            fn CGFontGetGlyphAdvances(
                font: Option<&CGFont>,
                glyphs: NonNull<CGGlyph>,
                count: usize,
                advances: NonNull<c_int>,
            ) -> bool;
        }
        unsafe { CGFontGetGlyphAdvances(font, glyphs, count, advances) }
    }

    #[doc(alias = "CGFontGetGlyphBBoxes")]
    #[inline]
    pub unsafe fn glyph_b_boxes(
        font: Option<&CGFont>,
        glyphs: NonNull<CGGlyph>,
        count: usize,
        bboxes: NonNull<CGRect>,
    ) -> bool {
        extern "C-unwind" {
            fn CGFontGetGlyphBBoxes(
                font: Option<&CGFont>,
                glyphs: NonNull<CGGlyph>,
                count: usize,
                bboxes: NonNull<CGRect>,
            ) -> bool;
        }
        unsafe { CGFontGetGlyphBBoxes(font, glyphs, count, bboxes) }
    }

    #[doc(alias = "CGFontGetGlyphWithGlyphName")]
    #[inline]
    pub unsafe fn glyph_with_glyph_name(font: Option<&CGFont>, name: Option<&CFString>) -> CGGlyph {
        extern "C-unwind" {
            fn CGFontGetGlyphWithGlyphName(
                font: Option<&CGFont>,
                name: Option<&CFString>,
            ) -> CGGlyph;
        }
        unsafe { CGFontGetGlyphWithGlyphName(font, name) }
    }

    #[doc(alias = "CGFontCopyGlyphNameForGlyph")]
    #[inline]
    pub unsafe fn glyph_name_for_glyph(
        font: Option<&CGFont>,
        glyph: CGGlyph,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CGFontCopyGlyphNameForGlyph(
                font: Option<&CGFont>,
                glyph: CGGlyph,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CGFontCopyGlyphNameForGlyph(font, glyph) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCanCreatePostScriptSubset")]
    #[inline]
    pub unsafe fn can_create_post_script_subset(
        font: Option<&CGFont>,
        format: CGFontPostScriptFormat,
    ) -> bool {
        extern "C-unwind" {
            fn CGFontCanCreatePostScriptSubset(
                font: Option<&CGFont>,
                format: CGFontPostScriptFormat,
            ) -> bool;
        }
        unsafe { CGFontCanCreatePostScriptSubset(font, format) }
    }

    #[doc(alias = "CGFontCopyTableTags")]
    #[inline]
    pub unsafe fn table_tags(font: Option<&CGFont>) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CGFontCopyTableTags(font: Option<&CGFont>) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CGFontCopyTableTags(font) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGFontCopyTableForTag")]
    #[inline]
    pub unsafe fn table_for_tag(font: Option<&CGFont>, tag: u32) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CGFontCopyTableForTag(font: Option<&CGFont>, tag: u32) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CGFontCopyTableForTag(font, tag) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// * Keys for the font variation axis dictionary. **
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontvariationaxisname?language=objc)
    pub static kCGFontVariationAxisName: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontvariationaxisminvalue?language=objc)
    pub static kCGFontVariationAxisMinValue: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontvariationaxismaxvalue?language=objc)
    pub static kCGFontVariationAxisMaxValue: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgfontvariationaxisdefaultvalue?language=objc)
    pub static kCGFontVariationAxisDefaultValue: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgglyphdeprecatedenum?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGGlyphDeprecatedEnum(pub i32);
impl CGGlyphDeprecatedEnum {
    #[doc(alias = "CGGlyphMin")]
    pub const Min: Self = Self(0);
    #[doc(alias = "CGGlyphMax")]
    pub const Max: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGGlyphDeprecatedEnum {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGGlyphDeprecatedEnum {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[deprecated = "renamed to `CGFont::with_platform_font`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCreateWithPlatformFont(
    platform_font_reference: *mut c_void,
) -> Option<CFRetained<CGFont>> {
    extern "C-unwind" {
        fn CGFontCreateWithPlatformFont(
            platform_font_reference: *mut c_void,
        ) -> Option<NonNull<CGFont>>;
    }
    let ret = unsafe { CGFontCreateWithPlatformFont(platform_font_reference) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGDataProvider")]
#[deprecated = "renamed to `CGFont::with_data_provider`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCreateWithDataProvider(
    provider: &CGDataProvider,
) -> Option<CFRetained<CGFont>> {
    extern "C-unwind" {
        fn CGFontCreateWithDataProvider(provider: &CGDataProvider) -> Option<NonNull<CGFont>>;
    }
    let ret = unsafe { CGFontCreateWithDataProvider(provider) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGFont::with_font_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCreateWithFontName(
    name: Option<&CFString>,
) -> Option<CFRetained<CGFont>> {
    extern "C-unwind" {
        fn CGFontCreateWithFontName(name: Option<&CFString>) -> Option<NonNull<CGFont>>;
    }
    let ret = unsafe { CGFontCreateWithFontName(name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGFont::new_copy_with_variations`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCreateCopyWithVariations(
    font: Option<&CGFont>,
    variations: Option<&CFDictionary>,
) -> Option<CFRetained<CGFont>> {
    extern "C-unwind" {
        fn CGFontCreateCopyWithVariations(
            font: Option<&CGFont>,
            variations: Option<&CFDictionary>,
        ) -> Option<NonNull<CGFont>>;
    }
    let ret = unsafe { CGFontCreateCopyWithVariations(font, variations) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::number_of_glyphs`"]
    pub fn CGFontGetNumberOfGlyphs(font: Option<&CGFont>) -> usize;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::units_per_em`"]
    pub fn CGFontGetUnitsPerEm(font: Option<&CGFont>) -> c_int;
}

#[deprecated = "renamed to `CGFont::post_script_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyPostScriptName(
    font: Option<&CGFont>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGFontCopyPostScriptName(font: Option<&CGFont>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGFontCopyPostScriptName(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGFont::full_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyFullName(
    font: Option<&CGFont>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGFontCopyFullName(font: Option<&CGFont>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGFontCopyFullName(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::ascent`"]
    pub fn CGFontGetAscent(font: Option<&CGFont>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::descent`"]
    pub fn CGFontGetDescent(font: Option<&CGFont>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::leading`"]
    pub fn CGFontGetLeading(font: Option<&CGFont>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::cap_height`"]
    pub fn CGFontGetCapHeight(font: Option<&CGFont>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::x_height`"]
    pub fn CGFontGetXHeight(font: Option<&CGFont>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::font_b_box`"]
    pub fn CGFontGetFontBBox(font: Option<&CGFont>) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::italic_angle`"]
    pub fn CGFontGetItalicAngle(font: Option<&CGFont>) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::stem_v`"]
    pub fn CGFontGetStemV(font: Option<&CGFont>) -> CGFloat;
}

#[deprecated = "renamed to `CGFont::variation_axes`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyVariationAxes(
    font: Option<&CGFont>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGFontCopyVariationAxes(font: Option<&CGFont>) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGFontCopyVariationAxes(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGFont::variations`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyVariations(
    font: Option<&CGFont>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGFontCopyVariations(font: Option<&CGFont>) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CGFontCopyVariations(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::glyph_advances`"]
    pub fn CGFontGetGlyphAdvances(
        font: Option<&CGFont>,
        glyphs: NonNull<CGGlyph>,
        count: usize,
        advances: NonNull<c_int>,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::glyph_b_boxes`"]
    pub fn CGFontGetGlyphBBoxes(
        font: Option<&CGFont>,
        glyphs: NonNull<CGGlyph>,
        count: usize,
        bboxes: NonNull<CGRect>,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::glyph_with_glyph_name`"]
    pub fn CGFontGetGlyphWithGlyphName(font: Option<&CGFont>, name: Option<&CFString>) -> CGGlyph;
}

#[deprecated = "renamed to `CGFont::glyph_name_for_glyph`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyGlyphNameForGlyph(
    font: Option<&CGFont>,
    glyph: CGGlyph,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGFontCopyGlyphNameForGlyph(
            font: Option<&CGFont>,
            glyph: CGGlyph,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGFontCopyGlyphNameForGlyph(font, glyph) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGFont::can_create_post_script_subset`"]
    pub fn CGFontCanCreatePostScriptSubset(
        font: Option<&CGFont>,
        format: CGFontPostScriptFormat,
    ) -> bool;
}

#[deprecated = "renamed to `CGFont::table_tags`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyTableTags(
    font: Option<&CGFont>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGFontCopyTableTags(font: Option<&CGFont>) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGFontCopyTableTags(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGFont::table_for_tag`"]
#[inline]
pub unsafe extern "C-unwind" fn CGFontCopyTableForTag(
    font: Option<&CGFont>,
    tag: u32,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CGFontCopyTableForTag(font: Option<&CGFont>, tag: u32) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CGFontCopyTableForTag(font, tag) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
