#ifndef NETWORK_H
# define NETWORK_H

#include "bool.h"
#include "ipc.h"
#include <signal.h>

/* state of connection */
enum {
	CONS_DISCONNECTED,
	CONS_DISCONNECTING,
#if 0 /* admin fatal is not longer implemented */
	CONS_FAILED, /* only for "admin fatal"! */
#endif
	CONS_CONNECTING,
	CONS_CONNECTED
};

/* actions determined by signals */
enum {
	ACT_NOTHING,
	ACT_RECONNECT,
	ACT_CONNECTED,
	ACT_FATAL,
	ACT_CHILDDEAD,
	ACT_HANGUP, /* we actually use time_to_hangup but ACT_HANGUP is so
			select returns */
	ACT_CANDIAL /* we only allow commandon to be run once every  
		       MIN_TIME_BETWEEN DIALS */
};

/* item_rem() */
enum {
	ITEM_NORMAL,
	ITEM_DISCONNECT,
	ITEM_NOTFOUND
};

struct state_s {
	bool candial;		/* MIN_TIME_BETWEEN_DIALS */
	int con;		/* status of connection. e.g. CONS_CONNECTING */
	int pon;		/* number of CONNECTed clients */
};
struct fail_s {
	/* Times commandon exits in a row without us receiving SIGUSR1 */
	int noconnect;
	/* Times commandon exits in a row in under MIN_TIME_BETWEEN_DIALS */
	int toosoon;
};

#if 0
struct stats_s {
	int sokcount;
	time_t connect_time;
};
#endif

/* Values for a pid in struct pid_s.
 *
 * HAVE_RUN means the process has run and exited, but that we haven't really
 * dealt with the fact that it's exited.
 *
 * NOT_RUN also means a process is not running, but we no longer care if it
 * has ever run before. Once we have dealt with the fact a process has
 * exited (e.g. in adjust()), it may be good to set it to NOT_RUN.
 *
 * Otherwise the pid should simply equal the real pid value. (i.e. > 0 ).
 */
#define NOT_RUN -1
#define HAVE_RUN 0

/* Q for "Question" */
#define QNOT_RUN(pid) (pid==NOT_RUN)
#define QHAVE_RUN(pid) (pid==HAVE_RUN)
#define QIS_RUNNING(pid) (pid > 0)
/* #define QNOT_RUNNING !QIS_RUNNING */

/* The only ones which really care about the difference between "NOT_RUN" and
 * "HAVE_RUN" are can_disconnect, pre_commandon and onconnect.
 *
 * Note that if you want to check whether a pid is not currently running, use
 * !QIS_RUNNING(). Do *not* use !QNOT_RUN() */
struct pid_s {
	pid_t commandon;	/* -1 means no process */
	pid_t commandoff;
	pid_t can_disconnect;	/* set.disconnect_wait */
	pid_t first_onconnect;
	pid_t last_ondisc;
	pid_t pre_commandon;
	pid_t post_commandon;
};

int server(void);
bool sendalert(char *msg, int sok);
bool sendtousers_raw(char *user, char *msg, struct clients *first,
		bool connectedmsg);
#define sendtousers(x, y, z) sendtousers_raw(x, y, z, FALSE)
#define sendconnectedtousers(x, y) sendtousers_raw(x, "#Connected\n", y, TRUE)

#endif
