/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SCUMM_HE_MOONBASE_MAP_DATA_H
#define SCUMM_HE_MOONBASE_MAP_DATA_H

// This header contains file data used by the map generator, mostly
// the Template.thm and Template.wiz data taken from the Moonbase Console
// source repository.  Gzipped manually and then converted using
// https://notisrac.github.io/FileToCArray/ (https://github.com/notisrac/FileToCArray)

// Template.thm.gz (Map Icon).
// (https://github.com/michaelbarlow7/moonbase-console/blob/master/MoonbaseConsole/Template.thm)
#define TEMPLATE_THM_SIZE 4296 // The actual non-compressed size of Template.thm.
const byte Template_thm[] = {
  0x1f, 0x8b, 0x08, 0x08, 0x5f, 0x3e, 0x4b, 0x65, 0x00, 0x03, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
  0x74, 0x65, 0x2e, 0x74, 0x68, 0x6d, 0x00, 0xad, 0x97, 0x0f, 0x7c, 0x13, 0xd5, 0x1d, 0xc0, 0x7f,
  0x97, 0x5c, 0xe1, 0xaa, 0x87, 0x1c, 0x5b, 0x26, 0x99, 0x2b, 0xa3, 0x2d, 0x4d, 0xd7, 0xac, 0x89,
  0x23, 0xdb, 0x3a, 0x44, 0x40, 0xe8, 0x41, 0x5b, 0xe8, 0x54, 0x58, 0x90, 0x16, 0x3b, 0xd0, 0x6e,
  0xa9, 0xb6, 0x25, 0xb2, 0xb9, 0x76, 0x0e, 0x59, 0x27, 0x64, 0x72, 0x20, 0xd0, 0x14, 0x50, 0xa2,
  0x73, 0xac, 0x52, 0x98, 0x1e, 0xca, 0xd2, 0xb3, 0xab, 0x10, 0xb6, 0x39, 0x43, 0xbb, 0xd5, 0xa5,
  0xfc, 0x0d, 0x0a, 0x18, 0x14, 0x24, 0xa5, 0x73, 0x7a, 0x9b, 0x28, 0x61, 0x75, 0xa5, 0xb8, 0xcd,
  0x3d, 0xdf, 0xbb, 0x97, 0x4b, 0xd2, 0xd2, 0x7e, 0x3e, 0xeb, 0x3e, 0xbb, 0x5f, 0xaf, 0xef, 0xe5,
  0xcf, 0xfb, 0xde, 0xef, 0xef, 0x7b, 0xbf, 0x14, 0x96, 0x2f, 0xa8, 0x00, 0x10, 0x0e, 0xe1, 0x61,
  0x3e, 0x00, 0x98, 0x0c, 0xf8, 0x5f, 0x5e, 0xfc, 0x76, 0x96, 0x88, 0x8b, 0x01, 0x8c, 0x1c, 0x90,
  0xcb, 0x8f, 0x05, 0xfc, 0x7e, 0xbf, 0x36, 0xf3, 0x97, 0x93, 0x69, 0x39, 0xb9, 0x10, 0x96, 0x72,
  0x84, 0x90, 0x36, 0x43, 0xda, 0x0d, 0x30, 0x13, 0x60, 0x19, 0xc0, 0x23, 0x00, 0xcf, 0x00, 0x1c,
  0x04, 0x88, 0x02, 0x20, 0xfb, 0x54, 0x74, 0x7b, 0x35, 0x5a, 0xd5, 0x82, 0xf6, 0x9f, 0x41, 0xbd,
  0x7d, 0x48, 0xac, 0xf7, 0x8a, 0x0d, 0xb2, 0x28, 0xc9, 0xa2, 0x57, 0xc9, 0x19, 0x0b, 0x33, 0x4d,
  0xb0, 0x24, 0x0b, 0x56, 0xde, 0x0c, 0x1b, 0x66, 0x40, 0xcb, 0x02, 0x68, 0xab, 0x14, 0x3a, 0x56,
  0x65, 0x9e, 0xd8, 0x32, 0xb5, 0x47, 0x9e, 0x13, 0x7b, 0x65, 0x11, 0x3a, 0x5d, 0x89, 0x8e, 0x00,
  0x06, 0xbb, 0xdc, 0x52, 0x2f, 0x64, 0x89, 0x00, 0xd5, 0x00, 0x4d, 0x00, 0xfb, 0x00, 0xde, 0xc2,
  0x68, 0xfc, 0x97, 0x6f, 0x43, 0xe5, 0x4b, 0xd1, 0xba, 0xf5, 0xa8, 0xad, 0x1d, 0x9d, 0x8b, 0xe2,
  0x6f, 0xa2, 0x08, 0x20, 0x05, 0x90, 0x04, 0x08, 0x2b, 0x32, 0x1b, 0xe0, 0x3e, 0x80, 0x46, 0x80,
  0x97, 0x00, 0xde, 0x24, 0x0b, 0xec, 0x28, 0xbf, 0x02, 0x95, 0x3f, 0x86, 0xd6, 0xed, 0x47, 0x6d,
  0xbd, 0xe8, 0x9c, 0x0d, 0x2e, 0xdd, 0x0d, 0xaf, 0x6e, 0x80, 0x1d, 0xfb, 0xe0, 0xc1, 0x5e, 0x28,
  0x29, 0x86, 0x15, 0xcb, 0x60, 0x6d, 0x1d, 0xf8, 0x36, 0xc1, 0xde, 0x16, 0x38, 0x78, 0x00, 0x4e,
  0x77, 0xe5, 0xbf, 0xfd, 0x5a, 0xf9, 0xbb, 0xe7, 0xd7, 0x7d, 0xf8, 0x7e, 0xdb, 0x95, 0xab, 0xe7,
  0x10, 0xe4, 0x9d, 0x00, 0x67, 0x37, 0xd4, 0x3d, 0x0e, 0x4f, 0xb9, 0x61, 0xef, 0x2c, 0x66, 0x42,
  0x9e, 0x29, 0x77, 0x66, 0xde, 0xcc, 0x45, 0x33, 0x9c, 0x55, 0x0b, 0x6b, 0x1e, 0x76, 0xad, 0x69,
  0x5a, 0xf3, 0xe4, 0xee, 0x1d, 0xad, 0x81, 0x03, 0x5d, 0x87, 0x4f, 0x9e, 0x3d, 0x7f, 0xa9, 0xaf,
  0x6f, 0x76, 0x2f, 0xdc, 0xfb, 0x1e, 0xac, 0xbd, 0x08, 0x2d, 0x97, 0xa1, 0xa3, 0x1f, 0x22, 0xe1,
  0x70, 0x2c, 0xa6, 0x06, 0x02, 0xde, 0x50, 0x38, 0x5c, 0x2f, 0x2b, 0xc1, 0xa8, 0x2a, 0xfa, 0x94,
  0x50, 0x54, 0x55, 0x22, 0x6a, 0x7d, 0xb3, 0xe2, 0xf6, 0xc9, 0x4e, 0xaf, 0xec, 0x93, 0x15, 0x39,
  0x14, 0x11, 0x5d, 0xf5, 0xd8, 0x3f, 0xea, 0x00, 0xf2, 0x05, 0x42, 0xc4, 0x63, 0x92, 0xec, 0x6a,
  0x0e, 0xd6, 0xcb, 0x21, 0x67, 0x83, 0xcf, 0xea, 0xf6, 0x49, 0x72, 0xb0, 0xa2, 0x5e, 0x72, 0x7a,
  0x03, 0xc1, 0xe8, 0x80, 0x12, 0x56, 0xdd, 0x5e, 0x19, 0xbb, 0xd4, 0x17, 0x8c, 0x4a, 0x81, 0x68,
  0x54, 0x8d, 0x45, 0x63, 0x28, 0xa2, 0x0e, 0x78, 0xe5, 0xa0, 0x1a, 0x1b, 0x08, 0x47, 0xa2, 0xa2,
  0xdb, 0xe7, 0xf2, 0x06, 0x1d, 0x15, 0xf8, 0x8d, 0xa8, 0x12, 0x46, 0xe1, 0xe8, 0x80, 0x1c, 0x08,
  0x87, 0xa3, 0xc8, 0xdd, 0xd0, 0xec, 0x95, 0x23, 0x4e, 0x97, 0xd4, 0x1c, 0x44, 0x8e, 0xd2, 0x86,
  0x50, 0x58, 0x95, 0x9a, 0x07, 0x22, 0x51, 0x24, 0x2b, 0xe1, 0x50, 0x18, 0x49, 0xde, 0x60, 0x85,
  0xab, 0x19, 0xe3, 0xbc, 0x5e, 0x5f, 0x24, 0xa2, 0x2a, 0x4a, 0x24, 0x18, 0x8c, 0x29, 0x8a, 0x2a,
  0x35, 0xc8, 0xd1, 0xc8, 0x40, 0xbd, 0x4b, 0xae, 0x28, 0xf5, 0x4a, 0xee, 0xa0, 0xec, 0x0b, 0x05,
  0x65, 0x35, 0xd0, 0x1c, 0x6d, 0x70, 0xc9, 0xcd, 0x0d, 0x21, 0xc9, 0x25, 0xd7, 0x3b, 0x7d, 0x5e,
  0x97, 0x12, 0x0d, 0xc5, 0x22, 0x41, 0x55, 0x0d, 0xc7, 0x22, 0x81, 0x08, 0x8a, 0x0d, 0xe0, 0x64,
  0x02, 0x60, 0x01, 0xd2, 0x00, 0xc6, 0x00, 0x8c, 0x05, 0xc0, 0xa9, 0x95, 0x0e, 0x70, 0x1d, 0xc0,
  0xf5, 0x00, 0x3c, 0xc0, 0x38, 0x80, 0x1b, 0x00, 0xc6, 0x9f, 0xe8, 0x86, 0x3d, 0x3b, 0x61, 0xcd,
  0x43, 0x30, 0x77, 0x2e, 0xf4, 0xf4, 0xf4, 0xb4, 0xb7, 0xb7, 0x4b, 0x92, 0x84, 0x53, 0xed, 0xe5,
  0x73, 0x97, 0xd6, 0xc8, 0x47, 0xe7, 0xac, 0x6f, 0x9f, 0xb4, 0x7c, 0x03, 0xea, 0x7e, 0xfe, 0xea,
  0xfe, 0x47, 0xfb, 0x76, 0x2f, 0xbf, 0xb8, 0xe5, 0x16, 0x94, 0x03, 0xe8, 0x36, 0x40, 0x4b, 0x01,
  0xd5, 0x01, 0xf2, 0x02, 0xda, 0x03, 0xa8, 0x13, 0xd0, 0x59, 0xd8, 0x5d, 0x58, 0xb8, 0x7a, 0xf2,
  0xe4, 0x0f, 0x4e, 0xad, 0xe8, 0x6e, 0xc9, 0xdf, 0xe8, 0x4a, 0xbf, 0x1c, 0xea, 0x3b, 0xf3, 0xec,
  0x99, 0x17, 0x5c, 0x3b, 0x71, 0x36, 0x77, 0x75, 0x75, 0xed, 0x5b, 0x9c, 0xff, 0x8e, 0x7b, 0xda,
  0x99, 0xb6, 0x06, 0x74, 0x6a, 0x7b, 0x47, 0x47, 0xc7, 0xae, 0x5d, 0xcf, 0x79, 0x3c, 0x1e, 0x9c,
  0x4b, 0x38, 0x3d, 0x90, 0x36, 0x20, 0x6d, 0x86, 0xaf, 0xc5, 0x8b, 0x16, 0xde, 0x85, 0xdf, 0x10,
  0x20, 0x7e, 0x39, 0xef, 0x28, 0x5c, 0x04, 0xc0, 0xf0, 0xda, 0x0b, 0xc6, 0x60, 0x64, 0xd3, 0xc6,
  0x8c, 0xe5, 0xd2, 0xaf, 0xbb, 0x9e, 0x1f, 0x77, 0xc3, 0x78, 0x61, 0xc2, 0x67, 0x3e, 0x6b, 0xfa,
  0xdc, 0x8d, 0x13, 0xcd, 0x9f, 0xbf, 0xe9, 0x0b, 0x19, 0x93, 0xbe, 0x38, 0x39, 0x33, 0x2b, 0x7b,
  0x4a, 0x8e, 0x25, 0xf7, 0x4b, 0x79, 0xd6, 0x2f, 0xe7, 0xdb, 0xec, 0x37, 0x7f, 0x65, 0xaa, 0xe3,
  0xab, 0x5f, 0xfb, 0x7a, 0xc1, 0x37, 0xa6, 0xdd, 0x32, 0xfd, 0xd6, 0x19, 0x33, 0x67, 0xdd, 0x36,
  0x7b, 0x4e, 0xa1, 0x38, 0x77, 0x5e, 0x51, 0x71, 0xc9, 0xfc, 0x05, 0xa5, 0xdf, 0xbc, 0xfd, 0x8e,
  0x3b, 0x17, 0x2e, 0xfa, 0x96, 0x73, 0xf1, 0x5d, 0x4b, 0xca, 0xca, 0x97, 0xde, 0x5d, 0xf1, 0xed,
  0x65, 0xcb, 0xef, 0xb9, 0xb7, 0xf2, 0x3b, 0xdf, 0x75, 0x55, 0xdd, 0x77, 0x7f, 0x75, 0x4d, 0xed,
  0x0a, 0xf7, 0x03, 0x2b, 0xbf, 0xf7, 0xfd, 0x07, 0x7f, 0x50, 0x57, 0xff, 0xc3, 0x87, 0x7e, 0xb4,
  0xea, 0xe1, 0xd5, 0x3f, 0x6e, 0xf8, 0xc9, 0x23, 0x6b, 0xd6, 0x7a, 0x7e, 0xfa, 0xe8, 0x3a, 0x69,
  0xfd, 0x86, 0xc7, 0x36, 0x6e, 0xda, 0xdc, 0xe8, 0x6d, 0xda, 0xb2, 0x75, 0xdb, 0xe3, 0x4f, 0x6c,
  0xf7, 0x3d, 0xf9, 0xd4, 0xcf, 0x9e, 0xfe, 0xf9, 0x8e, 0x5f, 0x34, 0x3f, 0xb3, 0xb3, 0x65, 0xd7,
  0xee, 0x5f, 0x3e, 0xfb, 0x9c, 0xbc, 0xe7, 0xf9, 0x17, 0xf6, 0xfe, 0xca, 0xdf, 0xaa, 0xbc, 0xd8,
  0xf6, 0xeb, 0xf6, 0x97, 0xf6, 0xed, 0x0f, 0x1c, 0xf8, 0xcd, 0x6f, 0x7f, 0xf7, 0xf2, 0xef, 0x5f,
  0x09, 0x1e, 0xec, 0xe8, 0xfc, 0xc3, 0x1f, 0xbb, 0x5e, 0xfd, 0x53, 0xa8, 0xfb, 0xd0, 0xe1, 0x23,
  0x47, 0x8f, 0x1d, 0x0f, 0x9f, 0x78, 0xed, 0xf5, 0x93, 0xa7, 0x4e, 0xbf, 0x11, 0x39, 0xf3, 0xe6,
  0x5b, 0x67, 0xcf, 0xbd, 0x7d, 0x3e, 0xda, 0x73, 0xa1, 0xf7, 0xcf, 0xef, 0xfc, 0xe5, 0xdd, 0xf7,
  0xd4, 0xbf, 0xfe, 0xed, 0xfd, 0x8b, 0x1f, 0x7c, 0x78, 0x29, 0x76, 0xf9, 0xef, 0x7d, 0x1f, 0xfd,
  0xa3, 0xff, 0xca, 0xc0, 0xd5, 0x8f, 0xff, 0xf9, 0xaf, 0x7f, 0x7f, 0xf2, 0x1f, 0x84, 0xf7, 0x8d,
  0x79, 0x38, 0x76, 0x1b, 0x8f, 0x0b, 0xa3, 0x17, 0x45, 0x68, 0xe5, 0x1b, 0xf9, 0xcd, 0xdc, 0x26,
  0xae, 0x96, 0xab, 0xe1, 0xe6, 0xb3, 0xd5, 0x44, 0xb8, 0x12, 0xb6, 0x04, 0xbf, 0x1a, 0x3d, 0xad,
  0x15, 0x4b, 0x23, 0x4f, 0x48, 0x44, 0x4a, 0xd8, 0x62, 0x4d, 0x72, 0xa1, 0x08, 0xc8, 0x38, 0x6a,
  0xcd, 0x12, 0x34, 0x4d, 0x23, 0xcc, 0x29, 0x86, 0x22, 0xd6, 0x02, 0x39, 0x78, 0x8f, 0x24, 0xf2,
  0xbf, 0xe8, 0xb6, 0x49, 0xa3, 0x61, 0x6d, 0xc0, 0x12, 0x17, 0x30, 0x19, 0x71, 0x49, 0xe4, 0x80,
  0x65, 0x54, 0xfa, 0x11, 0x9a, 0x1f, 0xfb, 0x8d, 0xd8, 0x49, 0x6c, 0xa3, 0xac, 0x1c, 0x52, 0x59,
  0x1a, 0x8f, 0xc5, 0xaf, 0x46, 0x5e, 0x7d, 0x0c, 0xaf, 0x2e, 0x62, 0xb3, 0x81, 0x8a, 0x41, 0x13,
  0x06, 0xdf, 0x39, 0x40, 0x74, 0xcb, 0xc5, 0x6b, 0x59, 0x4d, 0x08, 0x89, 0xf2, 0x88, 0x86, 0x23,
  0xf3, 0xfc, 0xbc, 0x46, 0x62, 0xab, 0xf8, 0xc3, 0x66, 0x65, 0xba, 0x52, 0xe0, 0x75, 0x48, 0x82,
  0xc8, 0x31, 0x5a, 0x71, 0xe8, 0x7a, 0x11, 0x06, 0x79, 0x8e, 0xce, 0x63, 0x47, 0xe0, 0xf9, 0x85,
  0x1a, 0x8d, 0xe6, 0xb6, 0x07, 0xca, 0xde, 0xa8, 0xf0, 0x3a, 0x8e, 0x99, 0xfb, 0x4c, 0x47, 0xcd,
  0x5e, 0x87, 0xa3, 0x34, 0x3c, 0x2b, 0x53, 0x43, 0x1a, 0xe3, 0x2c, 0x1a, 0x85, 0xa4, 0x0c, 0x47,
  0xd3, 0xad, 0x94, 0x4d, 0x81, 0x32, 0x9f, 0xd3, 0x6d, 0x7f, 0x5a, 0xf8, 0x24, 0x63, 0x86, 0xf5,
  0xe3, 0xa2, 0xad, 0x7c, 0x08, 0x33, 0x33, 0x99, 0x4c, 0xe6, 0x02, 0xb3, 0x8b, 0xe9, 0xd4, 0xb8,
  0x8c, 0x26, 0x60, 0xa2, 0xa3, 0x61, 0x18, 0xfd, 0x88, 0x9d, 0x55, 0xbc, 0xa3, 0xd8, 0x59, 0x2a,
  0x9b, 0xc6, 0x8b, 0x81, 0xb2, 0x40, 0xd9, 0x92, 0xe2, 0xab, 0x85, 0xab, 0x2d, 0x75, 0xf6, 0xad,
  0x0e, 0xa5, 0x80, 0xd0, 0x3a, 0x19, 0x11, 0x87, 0xc0, 0x63, 0xf0, 0x18, 0x28, 0x91, 0x9c, 0xa7,
  0x74, 0x36, 0x94, 0x77, 0x4c, 0x98, 0xa7, 0xe9, 0xa6, 0x66, 0x6c, 0x73, 0xc8, 0xa6, 0x90, 0x29,
  0x64, 0x56, 0x33, 0x94, 0x02, 0x41, 0x9c, 0x5a, 0x1c, 0x2b, 0x0c, 0xcf, 0x72, 0xdb, 0x09, 0x2d,
  0x53, 0xd3, 0xad, 0x93, 0x21, 0x3c, 0x4a, 0xd4, 0x79, 0x84, 0x48, 0x39, 0x35, 0xfc, 0x94, 0x44,
  0x24, 0xe7, 0xb2, 0xc2, 0x84, 0x89, 0x69, 0x21, 0x33, 0xe5, 0x11, 0xa2, 0x8a, 0xe7, 0x92, 0x20,
  0x09, 0x2e, 0xde, 0xc5, 0x89, 0x5c, 0x16, 0xeb, 0x61, 0x2a, 0x19, 0x12, 0x59, 0x3c, 0xd3, 0x79,
  0x36, 0x3a, 0x50, 0xfd, 0x36, 0xf3, 0x34, 0x8e, 0xaa, 0xd9, 0x6d, 0x77, 0xdb, 0xb9, 0x2c, 0xab,
  0xc5, 0x6a, 0x71, 0xf1, 0x6e, 0x3b, 0x25, 0xca, 0xa6, 0xf5, 0x82, 0xc4, 0x8b, 0x1a, 0x29, 0x8b,
  0xcd, 0x64, 0x3c, 0x8c, 0x8b, 0xa7, 0x1c, 0x03, 0xb5, 0xd9, 0x96, 0x2a, 0x84, 0x47, 0xb4, 0x12,
  0xc4, 0xf0, 0xf4, 0x40, 0x99, 0xd7, 0x41, 0x68, 0xdc, 0x24, 0xa2, 0x4d, 0xa9, 0xd5, 0x6d, 0xb7,
  0x5a, 0x64, 0x53, 0x15, 0xef, 0xc2, 0x34, 0x6a, 0x29, 0x11, 0x17, 0x9f, 0xf4, 0x1d, 0xc0, 0x05,
  0x23, 0x15, 0x5d, 0x3f, 0xbf, 0x66, 0xa9, 0xdb, 0x2e, 0x09, 0xb2, 0x49, 0x29, 0x50, 0x33, 0x08,
  0x4f, 0x35, 0x13, 0x1e, 0xb6, 0x33, 0x83, 0xda, 0x1b, 0x4a, 0xd8, 0x2b, 0x72, 0x3a, 0x2d, 0xe9,
  0x3d, 0xc2, 0xd2, 0x99, 0x0c, 0x10, 0xff, 0xcb, 0xa6, 0xfd, 0x38, 0x8a, 0x91, 0x7b, 0xac, 0x96,
  0x7e, 0x76, 0x62, 0xda, 0xb4, 0x71, 0x47, 0xb4, 0xd5, 0x74, 0xbd, 0x24, 0x60, 0x9a, 0x36, 0x23,
  0xf6, 0x02, 0x54, 0x6a, 0x71, 0xc8, 0xc5, 0x47, 0x97, 0x11, 0x28, 0x43, 0xd7, 0x8e, 0x8e, 0x94,
  0x57, 0x6a, 0x25, 0x99, 0xc1, 0x65, 0xf5, 0xb3, 0xe6, 0x74, 0x73, 0xfa, 0xc4, 0xb4, 0x27, 0xf8,
  0x15, 0xdc, 0xfd, 0xd8, 0x4e, 0xca, 0xa1, 0x76, 0xe2, 0x88, 0x32, 0x84, 0x06, 0x40, 0x6b, 0xcd,
  0x98, 0x42, 0xd4, 0x6d, 0x07, 0xd0, 0x72, 0x97, 0xa5, 0x31, 0xe0, 0x26, 0x9d, 0xe4, 0x08, 0xef,
  0x56, 0x7c, 0xf7, 0xc3, 0x16, 0x68, 0x62, 0xa9, 0xbf, 0x08, 0x93, 0xb0, 0x01, 0x47, 0x94, 0xc4,
  0xc2, 0x63, 0x48, 0xd3, 0x78, 0xa4, 0x9e, 0x53, 0xbd, 0x87, 0x47, 0x5b, 0xab, 0x96, 0x71, 0x3a,
  0xcf, 0x6a, 0x21, 0xf6, 0xde, 0x94, 0x6e, 0x4e, 0xeb, 0x87, 0x53, 0xd0, 0x8e, 0x99, 0x84, 0xa8,
  0x65, 0x0a, 0x4f, 0xbd, 0x27, 0xf2, 0x94, 0xa8, 0xd7, 0x46, 0x32, 0x22, 0x94, 0x7b, 0x5c, 0xa8,
  0xe6, 0xb2, 0x21, 0x64, 0x26, 0x3c, 0x4c, 0xcc, 0xba, 0xc2, 0x4d, 0x1b, 0x77, 0x63, 0xfa, 0x15,
  0xf6, 0x14, 0xee, 0xb1, 0xb6, 0x11, 0x1d, 0x71, 0x07, 0x49, 0xb2, 0x97, 0xe8, 0x98, 0x14, 0xdd,
  0x46, 0x06, 0x92, 0xd6, 0xd2, 0x19, 0xa9, 0x09, 0x9c, 0xc3, 0x1c, 0xd1, 0x30, 0x3c, 0x9d, 0x64,
  0x9f, 0x30, 0xe1, 0x23, 0xee, 0x75, 0x96, 0xe8, 0xb6, 0x12, 0xcb, 0x03, 0xe0, 0xc6, 0xc4, 0x3c,
  0x2d, 0xa6, 0x24, 0xff, 0x00, 0x52, 0x57, 0x27, 0xa3, 0x91, 0xe4, 0x1d, 0x17, 0xa6, 0x68, 0x16,
  0x73, 0x59, 0xa4, 0x56, 0x95, 0x02, 0x49, 0x38, 0x64, 0x7a, 0x91, 0x6d, 0xd2, 0x48, 0xa5, 0xb0,
  0x00, 0xac, 0x1a, 0x2f, 0x2f, 0x25, 0xe7, 0x92, 0xeb, 0x87, 0xd2, 0x28, 0x8f, 0x58, 0x9c, 0xcd,
  0xd6, 0xdf, 0xe9, 0x73, 0x6e, 0x77, 0xe6, 0x65, 0xa9, 0x19, 0x92, 0x40, 0xbc, 0xb6, 0x91, 0x75,
  0x63, 0x5a, 0x1e, 0x6e, 0x67, 0xc6, 0x40, 0x9a, 0xb6, 0x73, 0x5e, 0x9b, 0xc7, 0x43, 0xac, 0x8d,
  0xd7, 0x07, 0xa9, 0x90, 0x2a, 0x3e, 0x3c, 0xdd, 0xe7, 0xc4, 0xf5, 0x80, 0x7d, 0x2f, 0x09, 0x56,
  0x8b, 0x07, 0x57, 0xfd, 0x2e, 0x9c, 0x21, 0x1e, 0x43, 0x76, 0x7c, 0x67, 0x1e, 0xea, 0xfd, 0x54,
  0xad, 0x74, 0xbb, 0xf5, 0xfd, 0x80, 0xac, 0xe1, 0xb0, 0x66, 0xa4, 0xde, 0x48, 0x8d, 0x90, 0xda,
  0xf0, 0x30, 0xc9, 0x3a, 0xa0, 0x32, 0xd8, 0xbe, 0xc1, 0xf5, 0xa6, 0xc7, 0x87, 0xf2, 0xaa, 0x39,
  0x03, 0x90, 0xda, 0x22, 0x75, 0x95, 0xc9, 0xe8, 0x34, 0x80, 0xe1, 0xd6, 0x0e, 0xfb, 0x4e, 0x7c,
  0x7f, 0xa1, 0x3c, 0x05, 0xef, 0xef, 0x0c, 0x88, 0x6c, 0xc8, 0x4c, 0x33, 0x8d, 0xec, 0x21, 0x43,
  0x59, 0xa9, 0x84, 0xc1, 0x5a, 0xa5, 0xf2, 0x0c, 0xa0, 0xc4, 0x4f, 0x41, 0xe2, 0x1d, 0xa2, 0x1d,
  0xdd, 0xe3, 0x46, 0xe6, 0x5d, 0xab, 0x25, 0x8d, 0x83, 0x2e, 0xf1, 0x33, 0x95, 0x2f, 0xc2, 0xe1,
  0xd3, 0x6b, 0x0b, 0xf3, 0xae, 0xb1, 0x75, 0xd0, 0xfa, 0x6b, 0xf4, 0xd5, 0xf5, 0xc3, 0x3f, 0x92,
  0x78, 0x3f, 0xe9, 0x6d, 0xf8, 0x12, 0xed, 0xd7, 0x13, 0xd9, 0xcb, 0x45, 0xae, 0x30, 0xb1, 0xef,
  0x0e, 0x17, 0x85, 0xa1, 0x3c, 0x6d, 0x48, 0xf0, 0x1a, 0xb5, 0x4e, 0xa9, 0x96, 0xf4, 0x35, 0xf4,
  0x64, 0x81, 0xc1, 0x31, 0x4d, 0xb5, 0x51, 0xaf, 0x88, 0x61, 0x2c, 0x4f, 0xf0, 0x36, 0x63, 0xdd,
  0x6a, 0x71, 0xcf, 0x45, 0xba, 0x07, 0x16, 0x0c, 0x29, 0xc4, 0x21, 0x66, 0xda, 0x92, 0xb1, 0x18,
  0xba, 0x2b, 0x0f, 0xe6, 0xd5, 0x6a, 0xdd, 0x88, 0x05, 0xf3, 0x8c, 0xd7, 0x9c, 0xce, 0x83, 0xcf,
  0x06, 0xb0, 0xa5, 0xc4, 0xd5, 0x36, 0xbc, 0x6c, 0x8a, 0xf7, 0x70, 0x74, 0x7f, 0x64, 0xb4, 0x4a,
  0xd0, 0x4f, 0xbf, 0xd4, 0xe7, 0xfe, 0x77, 0x33, 0x03, 0xd0, 0x5e, 0x89, 0x74, 0x23, 0xc6, 0x44,
  0xcf, 0x33, 0x3c, 0x8f, 0x19, 0x91, 0x02, 0x29, 0xf9, 0x4c, 0x78, 0xb9, 0x1a, 0x8d, 0xfc, 0x66,
  0x8e, 0x57, 0xe9, 0x28, 0xb5, 0x1a, 0xcc, 0x2b, 0x61, 0x8b, 0x12, 0x3c, 0xc3, 0xff, 0x81, 0x47,
  0xba, 0xb9, 0x91, 0x23, 0x30, 0x5a, 0xa9, 0x4d, 0xf4, 0x9a, 0x60, 0xcb, 0x89, 0x77, 0x61, 0x60,
  0x33, 0xc4, 0x7d, 0x49, 0x9e, 0xab, 0xfb, 0x80, 0x19, 0xd1, 0x1b, 0x4c, 0xe2, 0x7b, 0x46, 0xd0,
  0x7b, 0xe1, 0x5c, 0x96, 0xf0, 0x68, 0x8f, 0x08, 0x36, 0x63, 0x82, 0x0c, 0x09, 0x1f, 0xd0, 0x7e,
  0xcc, 0x30, 0x24, 0x32, 0xc9, 0xa7, 0x91, 0xcf, 0x8c, 0xf0, 0x29, 0xb1, 0xab, 0x44, 0x05, 0xc8,
  0x10, 0x00, 0x00
};

// Template.wiz.gz (Map Thumbnail; modified in-code to display stats).
// (https://github.com/michaelbarlow7/moonbase-console/blob/master/MoonbaseConsole/Template.wiz)
#define TEMPLATE_WIZ_SIZE 39738 // The actual non-compressed size of Template.wiz.
const byte Template_wiz[] = {
  0x1f, 0x8b, 0x08, 0x08, 0xf4, 0x21, 0x4c, 0x65, 0x00, 0x03, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
  0x74, 0x65, 0x2e, 0x77, 0x69, 0x7a, 0x00, 0xed, 0x5d, 0x0d, 0x9c, 0x1b, 0x45, 0x15, 0x7f, 0x48,
  0x80, 0x05, 0x0e, 0x08, 0x7a, 0x6a, 0xda, 0x5e, 0x81, 0x53, 0xee, 0x2e, 0x69, 0x0b, 0xb4, 0x16,
  0x84, 0x42, 0xf9, 0xe8, 0x81, 0x05, 0x22, 0x1c, 0xed, 0x1e, 0xf4, 0x20, 0x82, 0x20, 0x9b, 0x0a,
  0x12, 0x51, 0xb8, 0x88, 0x80, 0x91, 0xb6, 0x72, 0x4b, 0x01, 0x09, 0x28, 0x12, 0x50, 0xe1, 0xa0,
  0x54, 0x08, 0x1f, 0x96, 0x58, 0x4b, 0x2f, 0xa8, 0x48, 0x28, 0x5a, 0x4c, 0x05, 0x34, 0x45, 0xc0,
  0x14, 0x28, 0xa4, 0x56, 0xa4, 0x8b, 0x7c, 0xf4, 0xb0, 0x4a, 0x83, 0xf8, 0x31, 0xee, 0x64, 0x32,
  0xd9, 0xd9, 0xdd, 0xd9, 0x7c, 0xb4, 0xb9, 0x66, 0xfd, 0xed, 0xe6, 0xdf, 0x6b, 0x76, 0xdf, 0xbe,
  0x9d, 0xbc, 0xfd, 0xef, 0xdb, 0x99, 0x79, 0x33, 0xbb, 0x6f, 0x67, 0x0d, 0x9c, 0x1c, 0x02, 0xb8,
  0xe3, 0x48, 0xf5, 0xeb, 0x24, 0x00, 0x68, 0xff, 0x90, 0xfa, 0xdf, 0x0d, 0xe5, 0x3f, 0xf1, 0xc4,
  0xde, 0x7e, 0x80, 0x9d, 0x05, 0xc0, 0x9f, 0x65, 0x2a, 0x60, 0xd9, 0xb2, 0x65, 0xa5, 0xa5, 0x65,
  0x03, 0x78, 0x71, 0x00, 0x7f, 0x90, 0x8a, 0x01, 0x84, 0x50, 0x69, 0x09, 0x95, 0xfe, 0x00, 0x66,
  0x02, 0x9c, 0x0d, 0x70, 0x15, 0xc0, 0x9d, 0x00, 0x8f, 0x03, 0x14, 0x00, 0xd0, 0x41, 0x53, 0xd1,
  0x29, 0x17, 0xa0, 0xcb, 0x97, 0xa0, 0x91, 0x75, 0x68, 0xe3, 0x16, 0xd4, 0x1b, 0x8d, 0xf7, 0xc6,
  0x92, 0xbd, 0x72, 0xb2, 0x37, 0x9e, 0x3a, 0x70, 0x37, 0x98, 0xd9, 0x0e, 0x67, 0x74, 0xc2, 0xc5,
  0x07, 0xc3, 0xe2, 0xa3, 0x60, 0xc9, 0xc9, 0xb0, 0xfc, 0x3c, 0xef, 0xaa, 0xcb, 0x0f, 0x58, 0x7b,
  0xd3, 0xd4, 0x0d, 0xc9, 0xe3, 0x46, 0x1f, 0x9b, 0x83, 0x5e, 0x38, 0x0f, 0x3d, 0x0d, 0x6a, 0xc1,
  0x52, 0x44, 0xde, 0x08, 0x9d, 0xbd, 0x00, 0x17, 0x00, 0xdc, 0x08, 0xb0, 0x12, 0xe0, 0x25, 0xb5,
  0x68, 0xf5, 0xdf, 0xe4, 0x29, 0x68, 0xe0, 0x4c, 0x34, 0x74, 0x0d, 0x5a, 0xbe, 0x02, 0xad, 0x2f,
  0xa8, 0x9a, 0x28, 0x0f, 0x28, 0x05, 0x48, 0x06, 0xa4, 0x1a, 0x72, 0x2c, 0xc0, 0xfc, 0xd2, 0x21,
  0x3d, 0x0c, 0xf0, 0x22, 0xde, 0xe1, 0x20, 0x34, 0x39, 0x84, 0x06, 0xae, 0x45, 0x43, 0x23, 0x68,
  0xf9, 0x46, 0xb4, 0x7e, 0x0a, 0x6c, 0x3e, 0x0b, 0x9e, 0x5c, 0x0c, 0xb7, 0xaf, 0x84, 0x4b, 0x36,
  0xc2, 0x89, 0xb3, 0xe1, 0xa2, 0xb3, 0x61, 0xe1, 0x20, 0x24, 0xae, 0x87, 0x07, 0x97, 0xc0, 0xe3,
  0x8f, 0xc0, 0x0b, 0xab, 0x27, 0xbf, 0xf2, 0xec, 0xc0, 0xeb, 0xaf, 0x0e, 0xbd, 0xf3, 0xe6, 0xf2,
  0xad, 0xef, 0xaf, 0x47, 0xe0, 0x5f, 0x0b, 0xe2, 0x1a, 0x18, 0xbc, 0x19, 0x6e, 0x8b, 0xc0, 0x83,
  0x47, 0xef, 0xb4, 0xaf, 0xbf, 0xbd, 0x7b, 0xa6, 0x7f, 0xe6, 0x9c, 0xa3, 0xc4, 0xf0, 0x69, 0x17,
  0x5e, 0x21, 0x2d, 0xb8, 0x71, 0xc1, 0xad, 0x4b, 0x6f, 0x7f, 0x28, 0xfd, 0xc8, 0xea, 0xa7, 0x9e,
  0x7b, 0xf9, 0xd5, 0xcd, 0x5b, 0xb6, 0x1c, 0xbb, 0x11, 0xce, 0xdd, 0x04, 0x0b, 0xdf, 0x82, 0x25,
  0xef, 0xc2, 0xaa, 0xf7, 0x20, 0x9f, 0xcb, 0x8d, 0x8e, 0x2a, 0xe9, 0x74, 0x3c, 0x9b, 0xcb, 0x45,
  0x93, 0xa9, 0x4c, 0x41, 0xe9, 0x4d, 0xa4, 0xb2, 0x05, 0x25, 0x95, 0x57, 0xa2, 0xc3, 0xa9, 0x48,
  0x22, 0x29, 0xc6, 0x93, 0x89, 0x64, 0x2a, 0x99, 0xcd, 0xf7, 0x4a, 0x51, 0x95, 0x1f, 0xa5, 0x88,
  0x12, 0xe9, 0x2c, 0x66, 0x4c, 0x4e, 0x4a, 0xc3, 0x99, 0x68, 0x32, 0x2b, 0xc6, 0x12, 0x81, 0x48,
  0x42, 0x4e, 0x66, 0x42, 0x51, 0x59, 0x8c, 0xa7, 0x33, 0x85, 0x62, 0x2a, 0xa7, 0x44, 0xe2, 0x49,
  0x95, 0xd2, 0x44, 0xa6, 0x20, 0xa7, 0x0b, 0x05, 0x65, 0xb4, 0x30, 0x8a, 0xf2, 0x4a, 0x31, 0x9e,
  0xcc, 0x28, 0xa3, 0xc5, 0x5c, 0xbe, 0xd0, 0x1b, 0x49, 0x48, 0xf1, 0xcc, 0xb4, 0x90, 0x2a, 0x28,
  0xa4, 0x72, 0x28, 0x57, 0x28, 0x26, 0xd3, 0xb9, 0x5c, 0x01, 0x45, 0x62, 0xc3, 0xf1, 0x64, 0x5e,
  0x94, 0xe4, 0xe1, 0x0c, 0x9a, 0x16, 0x8c, 0x65, 0x73, 0x8a, 0x3c, 0x5c, 0xcc, 0x17, 0x50, 0x32,
  0x95, 0xcb, 0xe6, 0x90, 0x1c, 0xcf, 0x84, 0xa4, 0x61, 0xb5, 0xb8, 0x78, 0x3c, 0x91, 0xcf, 0x2b,
  0xa9, 0x54, 0x3e, 0x93, 0x19, 0x4d, 0xa5, 0x14, 0x39, 0x96, 0x2c, 0xe4, 0x8b, 0x51, 0x29, 0x19,
  0x0a, 0xc6, 0xe5, 0x48, 0x26, 0x99, 0xc8, 0x66, 0x92, 0x4a, 0x7a, 0xb8, 0x10, 0x93, 0x92, 0xc3,
  0xb1, 0xac, 0x2c, 0x25, 0xa3, 0x62, 0x22, 0x2e, 0xa5, 0x0a, 0xd9, 0xd1, 0x7c, 0x46, 0x51, 0x72,
  0xa3, 0xf9, 0x74, 0x1e, 0x8d, 0x16, 0x55, 0x67, 0x02, 0xf0, 0x00, 0xec, 0x02, 0xb0, 0x2b, 0xc0,
  0x6e, 0x00, 0xaa, 0x6b, 0xed, 0x0e, 0xb0, 0x07, 0xc0, 0x9e, 0x00, 0x6d, 0x00, 0x7b, 0x01, 0xec,
  0x0d, 0xb0, 0xcf, 0xda, 0x35, 0x70, 0xdf, 0x5d, 0xb0, 0xe0, 0x32, 0x38, 0xfe, 0x78, 0xd8, 0xb0,
  0x61, 0xc3, 0x8a, 0x15, 0x2b, 0x64, 0x59, 0x56, 0x5d, 0xed, 0xd1, 0xf5, 0x9b, 0x17, 0x24, 0x9f,
  0x39, 0xee, 0x9a, 0x15, 0x13, 0xcf, 0x59, 0x8c, 0xd6, 0xdc, 0xff, 0xfe, 0xc8, 0xd5, 0x5b, 0x96,
  0x9e, 0xf3, 0xd6, 0x4d, 0x47, 0xa0, 0x03, 0x01, 0x1d, 0x03, 0xe8, 0x4c, 0x40, 0x83, 0x80, 0xe2,
  0x80, 0xee, 0x03, 0xf4, 0x04, 0xa0, 0x97, 0x61, 0xe9, 0xac, 0x59, 0x57, 0xee, 0xbf, 0xff, 0xdb,
  0xcf, 0x5f, 0xb4, 0x66, 0xc9, 0xe4, 0xeb, 0xa4, 0xdd, 0xdf, 0xcd, 0x6e, 0x59, 0x77, 0xcf, 0xba,
  0x07, 0xa4, 0xbb, 0x54, 0x6f, 0x5e, 0xbd, 0x7a, 0xf5, 0xca, 0xfe, 0xc9, 0xaf, 0x45, 0x0e, 0x5f,
  0xb7, 0x3c, 0x86, 0x9e, 0xbf, 0x65, 0xd5, 0xaa, 0x55, 0x77, 0xdf, 0x7d, 0xef, 0xa2, 0x45, 0x8b,
  0x54, 0x5f, 0x52, 0xdd, 0x03, 0x95, 0xbe, 0x50, 0x69, 0x49, 0xfd, 0xf4, 0xcf, 0x39, 0xed, 0x74,
  0x55, 0xe0, 0x85, 0xf2, 0x47, 0x3c, 0x75, 0xd6, 0x1c, 0x80, 0x9d, 0xda, 0x4a, 0x2b, 0x3b, 0x7d,
  0x68, 0x67, 0xcf, 0x2e, 0xbb, 0xee, 0x26, 0xec, 0xbe, 0xc7, 0x9e, 0x6d, 0x7b, 0xed, 0xbd, 0x8f,
  0x77, 0xdf, 0x0f, 0x7f, 0xa4, 0xfd, 0xa3, 0x1f, 0xfb, 0xb8, 0x6f, 0xdc, 0xf8, 0x09, 0x1d, 0x13,
  0xf7, 0xdb, 0xff, 0x80, 0xce, 0x4f, 0x7c, 0xf2, 0xc0, 0xae, 0xee, 0x1e, 0x7f, 0x60, 0xd2, 0xe4,
  0x29, 0x07, 0x1d, 0x7c, 0xc8, 0xd4, 0x69, 0x9f, 0x9a, 0x7e, 0xe8, 0x61, 0x9f, 0x3e, 0xfc, 0x88,
  0x19, 0x47, 0x1e, 0x35, 0xf3, 0xe8, 0x63, 0x8e, 0x3d, 0x6e, 0x56, 0xef, 0xf1, 0x27, 0x7c, 0x66,
  0xf6, 0x89, 0x27, 0x9d, 0x1c, 0xfc, 0xec, 0x29, 0xa7, 0xf6, 0x9d, 0x36, 0x67, 0xae, 0xd8, 0x7f,
  0xfa, 0x19, 0xf3, 0x06, 0xce, 0x3c, 0x2b, 0xf4, 0xb9, 0xb3, 0xcf, 0xf9, 0xfc, 0xb9, 0xe7, 0x7d,
  0xe1, 0x7c, 0x29, 0x3c, 0xff, 0x8b, 0x17, 0x5c, 0xf8, 0xa5, 0x8b, 0x22, 0x5f, 0xbe, 0xf8, 0x2b,
  0x5f, 0xbd, 0xe4, 0xd2, 0xc1, 0xe8, 0xd7, 0x2e, 0xfb, 0xfa, 0xe5, 0x57, 0x5c, 0xf9, 0x8d, 0xd8,
  0x37, 0xaf, 0x5a, 0xb0, 0x70, 0xd1, 0xb7, 0xae, 0x1e, 0x92, 0xaf, 0x59, 0x7c, 0xed, 0x75, 0xd7,
  0x7f, 0xfb, 0x86, 0xf8, 0x8d, 0x37, 0x7d, 0xe7, 0xbb, 0x37, 0x7f, 0xef, 0x96, 0xc4, 0xad, 0xb7,
  0x7d, 0xff, 0x07, 0x3f, 0xbc, 0xfd, 0x8e, 0xe1, 0x3b, 0xef, 0x5a, 0x72, 0xf7, 0xd2, 0x1f, 0xdd,
  0x73, 0x6f, 0xf2, 0xbe, 0xfb, 0x1f, 0x78, 0xf0, 0xc7, 0xcb, 0x1e, 0x4a, 0xfd, 0x64, 0xf9, 0x4f,
  0x57, 0x3c, 0xbc, 0x72, 0x24, 0xfd, 0xc8, 0xcf, 0x7e, 0xfe, 0x8b, 0x47, 0x7f, 0xf9, 0x58, 0xe6,
  0xf1, 0x55, 0x4f, 0xfc, 0xea, 0xd7, 0xab, 0x9f, 0xfc, 0x4d, 0x76, 0xcd, 0x6f, 0x9f, 0x7a, 0xfa,
  0x99, 0xdf, 0xfd, 0x3e, 0xb7, 0xf6, 0xd9, 0x3f, 0x3c, 0xf7, 0xfc, 0x0b, 0x7f, 0xcc, 0xaf, 0x7b,
  0xf1, 0xa5, 0x97, 0xd7, 0xbf, 0xf2, 0x6a, 0x61, 0xc3, 0x9f, 0x36, 0xfe, 0xf9, 0xb5, 0xbf, 0xbc,
  0xbe, 0x49, 0x79, 0xe3, 0xaf, 0x6f, 0xbe, 0xf5, 0xf6, 0x3b, 0x9b, 0x47, 0xdf, 0xfd, 0xdb, 0x96,
  0xbf, 0xff, 0xe3, 0xbd, 0xad, 0xc5, 0xf7, 0xff, 0xf9, 0xc1, 0xbf, 0xfe, 0xfd, 0x9f, 0xff, 0x22,
  0xb5, 0xde, 0x38, 0x01, 0xe0, 0xb6, 0x0f, 0xe6, 0xb6, 0xb9, 0x70, 0x36, 0x06, 0xbd, 0x97, 0x7a,
  0xe7, 0x7a, 0xcb, 0x6b, 0x5e, 0xfd, 0x5a, 0xab, 0x6d, 0x6b, 0x1d, 0x06, 0xbd, 0x18, 0x25, 0x06,
  0xbc, 0x83, 0x5e, 0xfd, 0x5a, 0xab, 0x6d, 0x6b, 0x35, 0x2b, 0x98, 0x81, 0x4b, 0x2b, 0xac, 0xd0,
  0xb5, 0x56, 0xdb, 0x66, 0x07, 0x56, 0x06, 0x75, 0xac, 0x0c, 0xba, 0xac, 0xb8, 0xac, 0x70, 0x59,
  0x71, 0xeb, 0x15, 0x33, 0x2b, 0x73, 0xcb, 0x3c, 0xcc, 0xf5, 0xea, 0xd7, 0x5a, 0x6d, 0x9b, 0x0b,
  0x7b, 0xa1, 0xe2, 0x1d, 0x95, 0x6b, 0x48, 0x5b, 0x6b, 0xb5, 0x6d, 0xad, 0x65, 0xc5, 0xad, 0x57,
  0xf8, 0xac, 0x0c, 0x7a, 0xe7, 0x7a, 0x75, 0x6d, 0x90, 0xd7, 0x6d, 0x83, 0x5c, 0x56, 0xb6, 0x9d,
  0x95, 0xe9, 0x5e, 0xe7, 0x20, 0x5a, 0x42, 0xbf, 0xba, 0xd4, 0x5f, 0x5e, 0xa6, 0x6b, 0xfd, 0x06,
  0xcd, 0x0e, 0xf7, 0xc3, 0xf9, 0x4c, 0x70, 0xe1, 0xa2, 0x4e, 0x4c, 0x11, 0x5c, 0x98, 0x11, 0x10,
  0x26, 0x8d, 0x01, 0x02, 0xdb, 0x8c, 0xb1, 0xb0, 0xa6, 0x31, 0x04, 0x4b, 0xf6, 0xd7, 0x3c, 0x42,
  0x8f, 0x9f, 0x81, 0x26, 0xd5, 0xe4, 0x01, 0x0f, 0xd5, 0xeb, 0xa9, 0x40, 0x95, 0xaa, 0x65, 0xb3,
  0x12, 0x2a, 0xd3, 0x4b, 0xcb, 0xb2, 0x52, 0x39, 0x64, 0x9d, 0x2d, 0xb3, 0x96, 0x35, 0xac, 0x66,
  0xc0, 0x24, 0x0b, 0x70, 0xf5, 0xf8, 0x3c, 0x18, 0xcf, 0x6a, 0x75, 0x4e, 0xfc, 0x9e, 0xb0, 0x20,
  0x33, 0x08, 0x0b, 0x98, 0x19, 0xbd, 0x34, 0x2c, 0xe0, 0xe3, 0x31, 0xea, 0xf1, 0x65, 0x01, 0xa1,
  0xa7, 0xe6, 0xbe, 0x54, 0x6e, 0xb6, 0xc6, 0x5a, 0xb3, 0x76, 0xa9, 0xfc, 0x12, 0x2d, 0xb8, 0xaf,
  0xca, 0x4b, 0x40, 0x2d, 0x39, 0x2f, 0x86, 0x24, 0x0d, 0xc5, 0xd0, 0x1b, 0xbe, 0x6e, 0xcf, 0x1b,
  0xbe, 0x62, 0x48, 0x2f, 0x93, 0x3c, 0x46, 0x3d, 0xa5, 0x5d, 0xe2, 0xec, 0xdb, 0x65, 0xda, 0xd7,
  0xac, 0x47, 0x75, 0x8d, 0x47, 0x61, 0xb6, 0xc6, 0xba, 0x54, 0x9e, 0x45, 0xe6, 0x12, 0xb7, 0x95,
  0x15, 0x59, 0x08, 0x49, 0x68, 0x21, 0x5a, 0x18, 0x8b, 0x84, 0xa4, 0x58, 0x04, 0x2f, 0x8d, 0xf4,
  0x49, 0x42, 0x31, 0x44, 0x65, 0x58, 0x9a, 0x89, 0x16, 0x43, 0xaa, 0x6c, 0x9e, 0x5e, 0x86, 0xf5,
  0x58, 0xbb, 0xa8, 0xcc, 0xb8, 0xef, 0x48, 0xdf, 0x50, 0xe9, 0x37, 0x62, 0x11, 0x52, 0x3e, 0x59,
  0xc2, 0x65, 0x86, 0x05, 0xbd, 0xd7, 0xfb, 0xcb, 0xd6, 0x98, 0x35, 0x25, 0x61, 0xa4, 0xaf, 0xb6,
  0x45, 0xe6, 0x12, 0xad, 0xae, 0xa8, 0xfa, 0x58, 0x89, 0x45, 0x84, 0x4e, 0xc5, 0x17, 0x09, 0x60,
  0x6b, 0xb4, 0xa3, 0x88, 0x04, 0x84, 0x4e, 0xa1, 0x13, 0x4b, 0x43, 0xd2, 0x90, 0xb0, 0x75, 0x1e,
  0x96, 0x29, 0x3e, 0xec, 0xad, 0x8a, 0x2f, 0x16, 0x99, 0x71, 0xee, 0xf9, 0xb0, 0xc9, 0x87, 0xf7,
  0x93, 0xbd, 0x54, 0xb6, 0x75, 0x1e, 0xdd, 0x57, 0xd3, 0x23, 0x32, 0x2c, 0xc1, 0x6b, 0x64, 0x1b,
  0x5e, 0x0a, 0x49, 0xb2, 0xe0, 0xe7, 0xb0, 0xc2, 0xd3, 0xa4, 0xbf, 0xce, 0xb3, 0x08, 0x5b, 0x40,
  0x65, 0xc6, 0x12, 0x29, 0x0b, 0x41, 0xdd, 0xda, 0xa4, 0x1a, 0x35, 0x3f, 0x65, 0x25, 0x24, 0x29,
  0xbe, 0xbc, 0x48, 0x2c, 0xd9, 0xd4, 0x4e, 0x64, 0x98, 0xfb, 0xb4, 0x98, 0x16, 0x8b, 0xa1, 0x4c,
  0x94, 0xda, 0x80, 0x7f, 0xb7, 0xdb, 0xd3, 0x5d, 0xda, 0xab, 0x38, 0x8f, 0xf8, 0x4a, 0x5e, 0x94,
  0x84, 0x2e, 0x4f, 0x57, 0x49, 0x46, 0x59, 0x61, 0xf5, 0x88, 0x2c, 0x24, 0x49, 0x82, 0x54, 0xde,
  0x46, 0x96, 0xac, 0x58, 0xe1, 0x69, 0x92, 0x5f, 0xe7, 0x5b, 0x94, 0xf5, 0x89, 0xbd, 0x69, 0x31,
  0x2f, 0xce, 0x50, 0x2d, 0xb1, 0xf2, 0x15, 0x8d, 0x97, 0x60, 0x09, 0xd5, 0x59, 0xf1, 0x57, 0x58,
  0x11, 0x3a, 0xe9, 0x95, 0x44, 0x59, 0x61, 0xcf, 0x37, 0xcb, 0x0a, 0xae, 0xe7, 0x58, 0x06, 0x58,
  0x3d, 0xcc, 0x14, 0xbe, 0x82, 0xcc, 0xbe, 0xd2, 0x0c, 0x56, 0x2c, 0x2c, 0xf2, 0x4a, 0x35, 0xea,
  0xdb, 0xa0, 0x05, 0x2b, 0x56, 0xbc, 0xd0, 0xfa, 0x2d, 0x2f, 0x62, 0x5f, 0xc1, 0xbf, 0x3f, 0x43,
  0x9a, 0x36, 0x9b, 0xfa, 0x00, 0xad, 0xe9, 0xf3, 0x22, 0xf6, 0x87, 0x68, 0x1f, 0x91, 0xe1, 0x56,
  0x10, 0xcb, 0xa2, 0xe5, 0x7a, 0x05, 0x9f, 0x23, 0x7c, 0x06, 0xc9, 0xd9, 0x92, 0x4a, 0xf5, 0x22,
  0x2b, 0x23, 0x7a, 0xb8, 0x04, 0xcd, 0xb7, 0x88, 0xc4, 0x78, 0x66, 0x03, 0x95, 0xdf, 0x32, 0x6a,
  0x6a, 0xbf, 0xce, 0xb3, 0xa8, 0xa7, 0xd2, 0x36, 0x07, 0x2d, 0x8e, 0xb3, 0x31, 0x56, 0x68, 0x8b,
  0x17, 0x16, 0xba, 0x21, 0x5c, 0x61, 0xbc, 0xab, 0x2c, 0x23, 0xcc, 0x63, 0x0d, 0x56, 0x86, 0x4b,
  0x63, 0x65, 0xb5, 0xdb, 0xeb, 0xae, 0x92, 0x36, 0xdd, 0x42, 0x97, 0x78, 0x67, 0xb6, 0xc7, 0x42,
  0xb3, 0xba, 0x45, 0x6c, 0x8d, 0xc1, 0xe7, 0x23, 0xa8, 0x5b, 0xd7, 0x58, 0xa9, 0x56, 0xb7, 0x60,
  0x96, 0xb5, 0x5e, 0x1b, 0x3e, 0x7f, 0x01, 0x5d, 0xaf, 0xa8, 0xb4, 0xb5, 0xd4, 0x37, 0xa3, 0xfd,
  0xb4, 0x40, 0xc9, 0x63, 0xb4, 0xfe, 0x9a, 0x9f, 0xe9, 0xb3, 0xf1, 0x7a, 0x57, 0x01, 0xa6, 0xdf,
  0x45, 0x97, 0xf8, 0x35, 0x80, 0x95, 0xa6, 0xd9, 0x22, 0xa3, 0xcc, 0x1a, 0x46, 0xb6, 0x58, 0x56,
  0x9a, 0xd3, 0xdb, 0xb6, 0x4f, 0xcf, 0x7d, 0x7b, 0xd0, 0xea, 0x38, 0xcc, 0x9e, 0x68, 0x75, 0xcc,
  0x6e, 0x4f, 0xb8, 0x1f, 0xde, 0xa7, 0xd5, 0x63, 0xa9, 0xf6, 0xc4, 0xb6, 0x8e, 0x97, 0x8b, 0x0d,
  0xfe, 0x8e, 0xe8, 0xb5, 0xcb, 0xde, 0x63, 0x89, 0xe9, 0xde, 0xf1, 0xbe, 0xfa, 0x3d, 0x72, 0xbc,
  0x4f, 0xcf, 0x7f, 0x2b, 0xf7, 0x1e, 0x5b, 0x56, 0xea, 0xb7, 0x0b, 0x7f, 0x8c, 0xc7, 0xd5, 0xba,
  0xbd, 0xc7, 0x96, 0x95, 0x71, 0xbe, 0x43, 0xeb, 0xf4, 0xe0, 0x43, 0x55, 0x5d, 0xe3, 0x71, 0xb5,
  0x6e, 0xef, 0xb1, 0x84, 0xd8, 0xc0, 0xf5, 0x6a, 0xd6, 0x6d, 0xe5, 0xde, 0x2e, 0x76, 0x0c, 0x5c,
  0xe6, 0x79, 0x98, 0xbe, 0x43, 0xaf, 0x52, 0xfb, 0xc0, 0x38, 0xb3, 0x10, 0xf0, 0xe8, 0x59, 0xd9,
  0x91, 0xed, 0x9c, 0x5d, 0x60, 0x9e, 0x59, 0xc0, 0xe3, 0x13, 0x4e, 0x67, 0xc5, 0x3c, 0xb3, 0x40,
  0x46, 0xc4, 0x9c, 0xcd, 0x0a, 0x3b, 0xcf, 0x61, 0x66, 0x45, 0x54, 0x5b, 0xff, 0x09, 0xbe, 0xc3,
  0xda, 0x1b, 0xeb, 0x6f, 0xdb, 0x07, 0xdb, 0xda, 0x4e, 0x84, 0xcb, 0x63, 0xcd, 0x64, 0x06, 0x01,
  0x43, 0xf1, 0x75, 0x03, 0x65, 0x05, 0xd7, 0xb5, 0x13, 0x3b, 0x26, 0xf8, 0xc6, 0xff, 0x5f, 0x62,
  0xdb, 0xdb, 0x89, 0x1e, 0x8f, 0x52, 0x19, 0x6b, 0xc6, 0x23, 0xcd, 0xae, 0xaf, 0x10, 0x56, 0xf0,
  0xbc, 0x01, 0xf1, 0x12, 0x32, 0x27, 0x46, 0xe6, 0xdb, 0xe8, 0x76, 0x67, 0xd6, 0x2b, 0xf3, 0x05,
  0x3c, 0xa3, 0x94, 0xae, 0xcc, 0x4a, 0x90, 0xb9, 0x59, 0x6d, 0xbb, 0x33, 0x59, 0xe1, 0xcd, 0xe3,
  0xb3, 0xdb, 0x9d, 0xc9, 0x8a, 0xb1, 0x17, 0x17, 0x70, 0x7b, 0x71, 0x6d, 0xd4, 0x57, 0xa8, 0x87,
  0xd0, 0x39, 0x29, 0xa7, 0xb3, 0x12, 0xae, 0xcc, 0x95, 0x62, 0x2f, 0x09, 0x57, 0xe6, 0x35, 0x9d,
  0xcd, 0x8a, 0x5c, 0xb9, 0x63, 0x80, 0xce, 0xa1, 0x93, 0x39, 0x70, 0xb2, 0xd5, 0xa9, 0x2d, 0x33,
  0xef, 0x6e, 0x03, 0x8d, 0x15, 0xa7, 0xf6, 0xe2, 0xc2, 0xba, 0xbb, 0x08, 0xc8, 0x7d, 0x20, 0xae,
  0xaf, 0xe8, 0x5b, 0x66, 0xa3, 0xaf, 0x38, 0xb5, 0x5e, 0x61, 0x5b, 0xe6, 0x1e, 0xb7, 0xb6, 0xe5,
  0xc2, 0x6d, 0x99, 0x35, 0xb0, 0x77, 0x03, 0xbb, 0xbd, 0x38, 0x82, 0xea, 0x7d, 0x7e, 0x67, 0xb2,
  0xe2, 0xe7, 0xde, 0x75, 0xdc, 0xe3, 0xf0, 0x7a, 0x05, 0xb3, 0x42, 0xee, 0x12, 0xd6, 0xa0, 0x8d,
  0x25, 0x38, 0xb5, 0x65, 0xe6, 0x8d, 0xb0, 0x68, 0x6d, 0xb3, 0x53, 0x7b, 0x71, 0x98, 0x15, 0xed,
  0x3e, 0x73, 0x72, 0x5f, 0xb8, 0xc6, 0x8a, 0xeb, 0x2b, 0xfc, 0xd1, 0x38, 0x67, 0xd6, 0x2b, 0x01,
  0x4f, 0xf5, 0xd1, 0x38, 0x67, 0xb2, 0xe2, 0xb6, 0xcc, 0x56, 0x30, 0x8e, 0xc6, 0xb1, 0xdb, 0x9c,
  0xca, 0x8a, 0xeb, 0x2b, 0x66, 0xb8, 0xbd, 0x38, 0x2b, 0x56, 0x78, 0xbd, 0x38, 0x67, 0xb7, 0xcc,
  0x7e, 0x4f, 0x37, 0x04, 0x3b, 0x69, 0xbb, 0x6c, 0x64, 0xc5, 0xa9, 0xbd, 0x38, 0xcd, 0x57, 0xe8,
  0xfc, 0x7b, 0x31, 0xa4, 0x54, 0xae, 0x20, 0xa7, 0xfa, 0x4a, 0x4f, 0xe5, 0x39, 0x43, 0x3a, 0xff,
  0x8e, 0x47, 0x70, 0xdd, 0x7a, 0x45, 0x3f, 0x72, 0x8b, 0x21, 0xf6, 0xce, 0x67, 0xc6, 0xb3, 0x9d,
  0xc8, 0x4a, 0xad, 0xbb, 0x9d, 0x9c, 0xca, 0x0a, 0x1d, 0x8b, 0xd3, 0x9e, 0x01, 0xf3, 0x3b, 0xbe,
  0xbf, 0x42, 0xa0, 0x9f, 0x57, 0x65, 0xe1, 0x5c, 0x56, 0xe8, 0x73, 0xa9, 0xc6, 0xbb, 0x34, 0x5c,
  0x56, 0x48, 0xeb, 0xac, 0xbf, 0xa3, 0xc7, 0xb9, 0x2d, 0x33, 0x01, 0xbe, 0x0f, 0x4c, 0x3f, 0x0a,
  0x47, 0xe0, 0xd4, 0x5e, 0x1c, 0x81, 0xf6, 0xc4, 0xbb, 0x9e, 0x15, 0x67, 0xfb, 0x8a, 0x15, 0x2b,
  0x4e, 0xae, 0x57, 0xb4, 0xfa, 0x56, 0x3f, 0x9b, 0xea, 0x74, 0x56, 0xd8, 0xb6, 0x79, 0x92, 0xe0,
  0xb2, 0xa2, 0x81, 0x3e, 0x4d, 0xaf, 0x97, 0x3a, 0xf5, 0x99, 0x8f, 0xea, 0x70, 0x9f, 0x0f, 0xaa,
  0x0e, 0xf7, 0x09, 0x3b, 0x1e, 0xdc, 0xa7, 0x31, 0xf9, 0xac, 0xb4, 0xee, 0xd9, 0x5b, 0x3b, 0x3f,
  0xb9, 0xcb, 0x7b, 0xd2, 0x7a, 0x62, 0xc7, 0x7e, 0xea, 0x9f, 0xf9, 0x53, 0xdf, 0x73, 0xda, 0x3b,
  0x66, 0xef, 0xb1, 0x04, 0xef, 0xa9, 0xfc, 0xc3, 0xda, 0x3b, 0x54, 0xcb, 0x3a, 0x3a, 0x78, 0xbd,
  0xdf, 0xda, 0xcf, 0xf4, 0xef, 0xa8, 0xbd, 0xeb, 0x3b, 0xe7, 0xcd, 0x43, 0x35, 0xcb, 0xaa, 0x03,
  0xdb, 0x8d, 0xaf, 0x8b, 0xfd, 0xca, 0xfe, 0xde, 0x68, 0x26, 0x84, 0xed, 0xf9, 0x6d, 0x1e, 0xc6,
  0xf9, 0x9a, 0x89, 0xf1, 0x1d, 0x13, 0x3a, 0xc6, 0x77, 0x34, 0xbc, 0x57, 0xc9, 0xc7, 0x59, 0x56,
  0xf0, 0x35, 0xd2, 0x68, 0x29, 0x24, 0x73, 0x4a, 0x73, 0x8e, 0xa3, 0xd5, 0x59, 0x71, 0xa6, 0x08,
  0x87, 0xb4, 0x8d, 0xe3, 0xb0, 0x32, 0xce, 0x77, 0x48, 0x5b, 0xeb, 0x6c, 0xaa, 0xe4, 0x63, 0x62,
  0xee, 0x0f, 0xd4, 0x4b, 0x8c, 0x99, 0x41, 0x8d, 0xb9, 0x41, 0x79, 0xb9, 0x4a, 0x79, 0xd9, 0x4a,
  0x79, 0xd9, 0xb0, 0x48, 0x0e, 0x25, 0x3e, 0x2b, 0x53, 0x98, 0x3c, 0x4b, 0xe6, 0x2c, 0x58, 0x6c,
  0xd6, 0xab, 0xda, 0x99, 0x4a, 0x79, 0xf9, 0xb5, 0xf4, 0x92, 0x20, 0x27, 0xbb, 0x93, 0x79, 0x76,
  0xb9, 0xbb, 0x8e, 0x5c, 0xa5, 0x32, 0x27, 0xfb, 0x19, 0x2f, 0x2f, 0xa9, 0x6c, 0x91, 0x39, 0x0d,
  0x47, 0x59, 0x81, 0x3a, 0x58, 0x31, 0x67, 0x4c, 0xd3, 0x67, 0x48, 0xab, 0x95, 0xa9, 0xd4, 0xca,
  0x1a, 0xbd, 0x96, 0x99, 0x13, 0x7d, 0xc6, 0x4f, 0x92, 0x9f, 0x0e, 0xe7, 0xa0, 0xab, 0x9e, 0xab,
  0x34, 0x24, 0x45, 0xfb, 0xea, 0xc9, 0x4b, 0xaa, 0xe9, 0xb1, 0x59, 0xf6, 0xc8, 0x72, 0x6d, 0x56,
  0xb4, 0x08, 0x5e, 0xcb, 0x99, 0x47, 0xbf, 0x95, 0xf6, 0x5a, 0x99, 0x4a, 0xcd, 0x5a, 0x56, 0x56,
  0xf7, 0x98, 0x32, 0xf6, 0xd1, 0xf9, 0x42, 0x6d, 0x6e, 0x99, 0x9f, 0x83, 0xd4, 0xa8, 0x47, 0x33,
  0x75, 0x56, 0xcb, 0x69, 0x5a, 0xb2, 0x63, 0xb6, 0x39, 0xff, 0x24, 0xcd, 0xa8, 0x58, 0x8b, 0x15,
  0x6d, 0xb4, 0x87, 0xe6, 0x57, 0xd4, 0xf2, 0x2c, 0xf2, 0x32, 0x95, 0x46, 0xfb, 0xb4, 0x8c, 0xa6,
  0x84, 0x15, 0xaa, 0x55, 0xcd, 0x6a, 0x63, 0x3e, 0x53, 0x3f, 0x33, 0x5f, 0x48, 0xee, 0xfd, 0xc2,
  0x99, 0x40, 0x25, 0x0f, 0x3f, 0xb7, 0xa8, 0x5e, 0x4f, 0xcb, 0x49, 0xc9, 0xcb, 0x69, 0x4a, 0xf6,
  0x95, 0xbd, 0x58, 0xcf, 0x98, 0x7f, 0x12, 0x9f, 0x1f, 0x62, 0xc7, 0xf6, 0xb0, 0x62, 0xce, 0x54,
  0x2a, 0x0b, 0x92, 0x47, 0xcb, 0x68, 0x8a, 0xaf, 0x0d, 0x7a, 0x24, 0xd5, 0xad, 0xb6, 0x62, 0x85,
  0xe4, 0x25, 0xa5, 0x5e, 0x47, 0xca, 0x22, 0xe7, 0xd3, 0x6f, 0xc8, 0x37, 0xaa, 0xe9, 0x9d, 0x5f,
  0x25, 0xa7, 0x29, 0xde, 0x17, 0xe7, 0x2a, 0x2d, 0x7b, 0x7b, 0x39, 0xff, 0x24, 0xfe, 0xc3, 0xff,
  0xe7, 0x45, 0xea, 0xb3, 0xdb, 0xcb, 0x8a, 0x3e, 0x53, 0x29, 0xf6, 0x45, 0xf3, 0x53, 0x4e, 0xb5,
  0xad, 0xc6, 0xb3, 0xe9, 0x41, 0xce, 0x15, 0x44, 0x33, 0xc1, 0x92, 0xb9, 0x65, 0x8d, 0x15, 0x5c,
  0xdb, 0xd3, 0xcc, 0xac, 0x46, 0x3d, 0x89, 0x9b, 0xd3, 0x94, 0xef, 0x17, 0xa4, 0xce, 0xc3, 0xe7,
  0x11, 0x6f, 0xd1, 0xea, 0xb7, 0x7a, 0x59, 0xa1, 0xd9, 0x6c, 0xcd, 0x59, 0x6d, 0xf5, 0x4f, 0x33,
  0xf5, 0xe8, 0xc6, 0x57, 0x79, 0x47, 0xc7, 0xb3, 0x5a, 0xcf, 0x4a, 0xa0, 0x52, 0xdb, 0xea, 0xe7,
  0x96, 0xb5, 0x8c, 0x9f, 0xda, 0xb3, 0x76, 0x92, 0x49, 0x6f, 0xea, 0x31, 0x92, 0x29, 0xa7, 0x69,
  0x34, 0x68, 0xcc, 0x4b, 0x4a, 0xfd, 0x22, 0xc0, 0x3c, 0x47, 0xa2, 0xd5, 0x6d, 0xd6, 0xac, 0x04,
  0x74, 0xb5, 0x2d, 0x2e, 0x0f, 0xdf, 0xbf, 0x48, 0xbf, 0xf9, 0x99, 0x4a, 0xc3, 0x82, 0xdf, 0xc3,
  0x8e, 0xaf, 0xf2, 0x8e, 0x8e, 0x6f, 0xf5, 0x7c, 0xe6, 0x0a, 0x0a, 0x58, 0xb4, 0xcc, 0xbc, 0x2c,
  0xa0, 0xd6, 0x6d, 0x9c, 0xfa, 0xcd, 0xe4, 0x34, 0xe5, 0xb5, 0x98, 0x34, 0x33, 0xa5, 0x39, 0x1b,
  0x69, 0x2d, 0x56, 0xf8, 0x39, 0xc4, 0xad, 0x6d, 0x64, 0x5b, 0x72, 0xab, 0x7e, 0x07, 0xdd, 0xb3,
  0x5b, 0x67, 0x35, 0x73, 0xfd, 0x54, 0xce, 0x08, 0xaf, 0x9f, 0x63, 0xcc, 0x02, 0x6a, 0xd6, 0xa3,
  0xbd, 0x33, 0x9a, 0x39, 0x5e, 0x9f, 0x73, 0xde, 0xcf, 0x48, 0x8c, 0x25, 0xd5, 0xcf, 0x0a, 0x2f,
  0xdf, 0x7c, 0x35, 0x1b, 0xcd, 0xd9, 0x4a, 0xad, 0x8e, 0x4e, 0x9f, 0x89, 0xd5, 0x4e, 0xd9, 0x39,
  0xed, 0xd8, 0xe3, 0x6f, 0x52, 0x54, 0xd8, 0x9c, 0x52, 0x9a, 0x10, 0xdf, 0x35, 0xc7, 0x92, 0xe6,
  0x8c, 0x21, 0xb4, 0xf6, 0xcc, 0x1a, 0xfd, 0x6e, 0xfb, 0xd1, 0x9c, 0x71, 0x39, 0xda, 0x8e, 0xb2,
  0x31, 0x66, 0xf5, 0x9a, 0xa8, 0xf1, 0x77, 0x5f, 0x90, 0xd2, 0xfc, 0xe5, 0x25, 0x7e, 0xec, 0x4a,
  0xeb, 0x28, 0x3b, 0x80, 0xb2, 0x62, 0xae, 0xeb, 0xfd, 0x75, 0x46, 0x66, 0x8d, 0xbd, 0xfb, 0xc2,
  0x3a, 0xba, 0xb3, 0x1f, 0x2b, 0xe6, 0xf7, 0x4d, 0xd0, 0x1e, 0x4e, 0xad, 0xb8, 0xb3, 0xd1, 0x77,
  0x5f, 0x58, 0x47, 0x77, 0xf6, 0x63, 0x65, 0x92, 0x80, 0x59, 0x61, 0x23, 0xb3, 0x28, 0x27, 0x9e,
  0xd4, 0xc7, 0x9d, 0x34, 0x9e, 0xe4, 0x45, 0x6b, 0xe6, 0xb7, 0x54, 0x50, 0x3d, 0x1a, 0x7b, 0x98,
  0xdf, 0x56, 0x61, 0x47, 0x56, 0x70, 0xaf, 0x92, 0x8d, 0xcc, 0x24, 0x4e, 0xdc, 0xb9, 0xa9, 0x12,
  0x77, 0xf2, 0xe2, 0x49, 0x36, 0x5a, 0x23, 0xec, 0xb1, 0xb1, 0x1f, 0x65, 0x83, 0xf7, 0xfe, 0x03,
  0xd2, 0xbf, 0xb7, 0x23, 0x2b, 0x6c, 0x24, 0x27, 0x97, 0xea, 0x94, 0x6a, 0x71, 0x27, 0x2f, 0x9e,
  0x64, 0xa3, 0x35, 0xa2, 0xc7, 0xc6, 0x7e, 0x46, 0x56, 0xcc, 0x59, 0x2e, 0xec, 0xc9, 0x4a, 0xa0,
  0x66, 0x64, 0x36, 0x54, 0x61, 0xc5, 0xfc, 0x8e, 0x0c, 0x7d, 0xb4, 0x66, 0x3d, 0x96, 0xc1, 0xb2,
  0x42, 0x23, 0x7a, 0x7b, 0xb3, 0x52, 0x2b, 0x32, 0xd3, 0xe2, 0x4e, 0xde, 0x3b, 0x32, 0x74, 0x31,
  0xa6, 0x29, 0xf6, 0xa3, 0xb5, 0x2c, 0x3b, 0xb2, 0xa7, 0xcf, 0x13, 0x63, 0x4f, 0x56, 0x1a, 0x89,
  0xcc, 0xba, 0x38, 0xef, 0xc8, 0xa8, 0xf7, 0xbd, 0x19, 0x56, 0x71, 0xa1, 0x5d, 0x59, 0xa9, 0x16,
  0x99, 0xe9, 0x47, 0xfb, 0xf5, 0xf1, 0xa4, 0xdf, 0xa8, 0x55, 0xe3, 0x2d, 0x15, 0xfc, 0xb8, 0xd0,
  0x6e, 0xac, 0xd8, 0xa9, 0xc7, 0xdf, 0x6a, 0x3e, 0x28, 0x2b, 0xcd, 0x89, 0xc9, 0x9a, 0x01, 0xfb,
  0xdc, 0xa1, 0xd6, 0xf8, 0xac, 0xf0, 0x58, 0xc2, 0xbd, 0x17, 0xcb, 0x85, 0x0b, 0x17, 0x2e, 0x5c,
  0xb8, 0x70, 0xe1, 0xc2, 0x85, 0x0b, 0x17, 0x2e, 0x5c, 0xb8, 0x70, 0xb1, 0x63, 0xf1, 0x3f, 0x53,
  0xd1, 0xe8, 0xeb, 0x3a, 0x9b, 0x00, 0x00
};

#endif // SCUMM_HE_MOONBASE_MAP_DATA_H
