/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.Keep;
import com.android.tools.r8.internal.j2;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import java.io.PrintStream;

@Keep
public interface DiagnosticsHandler {
    /*
     * WARNING - void declaration
     */
    public static void printDiagnosticToStream(Diagnostic diagnostic, String prefix, PrintStream stream) {
        Diagnostic diagnostic2;
        void var1_1;
        void var2_2;
        if (diagnostic.getOrigin() != Origin.unknown()) {
            var2_2.print((String)var1_1 + " in " + diagnostic2.getOrigin());
            if (diagnostic2.getPosition() != Position.UNKNOWN) {
                var2_2.print(j2.a(" at ").append(diagnostic2.getPosition().getDescription()).toString());
            }
            var2_2.println(":");
        } else {
            var2_2.print((String)var1_1 + ": ");
        }
        var2_2.println(diagnostic2.getDiagnosticMessage());
    }

    default public void error(Diagnostic error) {
        DiagnosticsHandler.printDiagnosticToStream(error, "Error", System.err);
    }

    default public void warning(Diagnostic warning) {
        DiagnosticsHandler.printDiagnosticToStream(warning, "Warning", System.err);
    }

    default public void info(Diagnostic info) {
        DiagnosticsHandler.printDiagnosticToStream(info, "Info", System.out);
    }

    default public DiagnosticsLevel modifyDiagnosticsLevel(DiagnosticsLevel level, Diagnostic diagnostic) {
        return level;
    }
}

