/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.io.Files;
import java.util.zip.ZipFile;

public class SdkBundleMandatoryFilesPresenceValidator
extends SubValidator {
    @Override
    public void validateModuleZipFile(ZipFile moduleFile) {
        SdkBundleMandatoryFilesPresenceValidator.checkModuleHasAndroidManifest(moduleFile);
    }

    @Override
    public void validateBundleZipFile(ZipFile bundleFile) {
        if (bundleFile.getEntry("modules.resm") == null) {
            throw InvalidBundleException.builder().withUserMessage("The archive doesn't seem to be an SDK Bundle, it is missing required file '%s'.", "modules.resm").build();
        }
    }

    private static void checkModuleHasAndroidManifest(ZipFile zipFile) {
        ZipPath moduleManifestPath = BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath();
        String moduleName = Files.getNameWithoutExtension(zipFile.getName());
        if (zipFile.getEntry(moduleManifestPath.toString()) == null) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' is missing mandatory file '%s'.", moduleName, BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()).build();
        }
    }
}

