/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallReceiver
extends MultiLineReceiver {
    private static final String SUCCESS_OUTPUT = "Success";
    private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(([^:]*)(:.*)?)\\]");
    private String mErrorMessage = null;
    private String mSuccessMessage = null;
    private String mErrorCode = null;
    private boolean mSuccessfullyCompleted = false;

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            if (line.isEmpty()) continue;
            if (line.startsWith(SUCCESS_OUTPUT)) {
                this.mSuccessfullyCompleted = true;
                this.mErrorMessage = null;
                this.mSuccessMessage = line;
                break;
            }
            Matcher m11 = FAILURE_PATTERN.matcher(line);
            if (m11.matches()) {
                this.mErrorMessage = m11.group(1);
                this.mErrorCode = m11.group(2);
                this.mSuccessMessage = null;
                this.mSuccessfullyCompleted = false;
                break;
            }
            if (this.mErrorMessage == null) {
                this.mErrorMessage = "Unknown failure: " + line;
                this.mErrorCode = "UNKNOWN";
                continue;
            }
            this.mErrorMessage = this.mErrorMessage + "\n" + line;
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getSuccessMessage() {
        return this.mSuccessMessage;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public boolean isSuccessfullyCompleted() {
        return this.mSuccessfullyCompleted;
    }

    @Override
    public void done() {
        super.done();
        if (this.mErrorMessage == null) {
            this.mSuccessfullyCompleted = true;
        }
    }
}

