/*  ---------------------------------------------------------------
    xhkeys. Jul 2002
    Copyright (C) 2002,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#include "xhkeys_conf.h"

#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#define _GNU_SOURCE
#include <getopt.h>

#ifdef PLUGIN_SUPPORT
#include <dlfcn.h>
#include "xhkeys_plugin.h"
#endif

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

#include "xhkeys.h"


#define GlobalResDir "/usr/lib/X11/app-defaults"

#define DefResFileName  "XHkeys"
#define ResClassName  "XHkeys"
#define ResModuleName "xhkeys"

CmdDescr *Commands = NULL;
int CommandCount;

extern Display *dpy;
extern int screenNo;    

int keyTimeout;
int btnTimeout;
int maxCodes;
int maxCodesOriginal;

#ifdef OSD_SUPPORT
int osdEnabled;
int osdTextTop;
unsigned long osdColour;
unsigned long osdBkgrColour;
unsigned long osdFrameColour;
unsigned long osdStippleMask;
int osdFrameWidth;
XRectangle osdRect;	// x, y, width, height
XFontStruct *osdFont = NULL;
int osdAlignment;	// left, right, center
unsigned long osdTimeout;	// In millisec
const char *OSDAlignTypeCodes = "LRC";
#endif


#ifdef PLUGIN_SUPPORT
extern const char *PluginDirs[];	// common.c 
extern const char *DefaultPluginNames[];	// common.c
PluginData *Plugins = NULL;
int PluginCount;
int maxPlugins;
int maxPluginsOriginal;
unsigned long pluginTimeout;
#endif

#ifdef CDROM_SUPPORT
#include <linux/cdrom.h>
char *CDDevName = NULL;
Bool holdCD;
#endif

#ifdef MIXER_SUPPORT
#include <linux/soundcard.h>
char *MixerDevName = NULL;
int mixerChannel;
Bool holdMixer;
#endif

unsigned long keyLattency, keyPause;
unsigned long clickLattency, clickPause;


#ifdef PLUGIN_SUPPORT
const char *CommandTypeCodes = "IAPKM";
const char *PluginTypeModif = "NL";	// By name(N)/line number(L)
const char *PluginBehaviour = "OC";	// Once(O)/Continuous(C)
#else
const char *CommandTypeCodes = "IAKM";
#endif

const char *AppTypeTitles = "*#";

const char *TargetSelCodes = "CTIO";
const char *KeyTypeModif = "YSU";  // Keysym(symbolic), Scan code, keysym(numeric)

const char *LogModeCodes = "NEA";
int logMode;		// 0 (N) - none, 1 (E) - error, 2 (A) - all
int logConsole;		// True force logging to console (C)


static Status GetResourceString(XrmDatabase database, const char *parmname,
                              char **string_return)
{

  XrmValue xrmv;
/*  int sz; */
  char *str; 

  if (!XrmGetResource(database, parmname, ResClassName,  &str, &xrmv))
		return False;
/*
  sz = xrmv.size;
  str = malloc(sz+1);
    
  if (str == NULL) return False;

  memcpy(str, xrmv.addr, sz);
  *(str + sz) = '\0';

  *string_return = str;
*/
  return ((*string_return=strdup(xrmv.addr)) != NULL);
}

#ifdef OSD_SUPPORT
static void GetResourceGeometry(XrmDatabase database, const char *parmname, XRectangle *result)
{
    int  x, y, w, h, gmask;
    char *geometry;
    int  scrwidth = DisplayWidth(dpy, screenNo);

    gmask = 0;
    
    result->width = w = 300;
    result->height = h = 20;
    result->x = (scrwidth - w) / 2;
    result->y = 4;		
    

    if (GetResourceString(database, parmname, &geometry) && geometry != NULL)
    { 
	if (*geometry != '\0')
	  gmask = XParseGeometry(geometry, &x, &y,  &w, &h);   
	  
	XFree(geometry);
    }		  

    if (gmask & WidthValue) result->width = w;
    if (gmask & HeightValue) result->height = h;

    if ((gmask & XValue) != 0) {
	if (gmask & XNegative)
	    x += scrwidth - result->width;
    
	result->x = x;
    }    

    if ((gmask & YValue) != 0) {
	if (gmask & YNegative)
	    y += DisplayHeight(dpy, screenNo) - result->height;
    
	result->y = y;
    }    
}

Bool GetResourceColour(XrmDatabase database, const char *parmname, unsigned long *result) //, Bool *isTransparent)
{
    char *colourName;
    Bool success = False;
    
    if (GetResourceString(database, parmname, &colourName) && colourName != NULL) {
	int len = strlen(colourName);

	// Get rid of trailing spaces	
	while (--len >= 0 && strchr("\t ", colourName[len]) != NULL);

	colourName[++len] = '\0';

/*
	if (strcmp(colourName, "transparent") == 0) {
	    if (isTransparent != NULL) *isTransparent = True;	    
	}
	else
*/	
	if (len > 0) {
	    XColor exactColour, screenColour;
	    Colormap cm = DefaultColormap(dpy, screenNo);

//	    if (isTransparent != NULL) *isTransparent = False;	    

	    if (XAllocNamedColor(dpy, cm, colourName, &screenColour, &exactColour)) {
		*result = screenColour.pixel;
	        success = True;
	    }    
	}
	
	XFree(colourName);
    }
    
    return success;
}

static XFontStruct *GetResourceFont(XrmDatabase database, const char *parmname)
{
    static const char *defFontNames[] = {"9x15bold", "variable", "fixed", NULL};
    const char **defFontNamePtr;
    XFontStruct *result = NULL;
    char *fontName;

    if (GetResourceString(database, parmname, &fontName) && fontName != NULL) {
	result = XLoadQueryFont(dpy, fontName);
	XFree(fontName);
    }
    

    defFontNamePtr = defFontNames;
    while (result == NULL && *defFontNamePtr != NULL)
	result = XLoadQueryFont(dpy, *defFontNamePtr++);
	
    return result;	
}

#endif


static Status GetResourceInt(XrmDatabase database, const char *parmname,
                         int min, int max, int *value_return)
{
  char *strPtr;
  int value;
  XrmValue xrmv;

  if (!XrmGetResource(database, parmname, ResClassName,  &strPtr, &xrmv))
		return False;

  value = (int) strtol(xrmv.addr, &strPtr, 0);
  if ((*strPtr == '\0' || *strPtr==' ') && value>=min && value<=max) {
	*value_return = value;
	return True;
  }
  
  return False;
}						 

static Status GetResourceUlong(XrmDatabase database, const char *parmname,
            unsigned long min, unsigned long max, unsigned long *value_return)
{
  char *strPtr;
  unsigned long value;
  XrmValue xrmv;

  if (!XrmGetResource(database, parmname, ResClassName,  &strPtr, &xrmv))
		return False;

  value = strtoul(xrmv.addr, &strPtr, 0);
  if ((*strPtr == '\0' || *strPtr==' ') && value>=min && value<=max) {
	*value_return = value;
	return True;
  }
  
  return False;
}						 

static Status GetResourceBool(XrmDatabase database, const char *parmname,
                            Bool *value_return)
{
  char *strPtr, c;
  XrmValue xrmv;

  if (!XrmGetResource(database, parmname, ResClassName,  &strPtr, &xrmv))
		return False;

  c = *(xrmv.addr);

  if (strchr("yY1", c)) {
	*value_return = True;
	return True;
  } 
  if (strchr("nN0", c)) {
	*value_return = False;
	return True;
  } 

  return False;
}						 


static XrmDatabase GetResourceDatabase(const char *fileName, Bool getGlobal, char **fullResFileNamePtr)
{
  XrmDatabase  xrmdb = NULL;
  const char *homedir;
  char *FullResFileName = NULL;
  
  maxCodesOriginal = -1;
#ifdef PLUGIN_SUPPORT  
  maxPluginsOriginal = -1;
#endif

  if (getGlobal)  {
	xrmdb = XrmGetFileDatabase(GlobalResDir "/" DefResFileName);
 	if (xrmdb != NULL) {
	  GetResourceInt(xrmdb, ResModuleName ".maxcodes", 1, 255, (int *) &maxCodesOriginal); 
#ifdef PLUGIN_SUPPORT  
	  GetResourceInt(xrmdb, ResModuleName ".maxplugins", 1, 255, (int *) &maxPluginsOriginal); 
#endif
	} 
    }	

  if (fileName == NULL) fileName = "~/." DefResFileName;

  if (memcmp(fileName, "~/", 2) == 0) {
	if ((homedir = getenv("HOME")) != NULL &&
	    (FullResFileName = malloc(strlen(homedir) + strlen(fileName))) != NULL)
	{	
	  sprintf (FullResFileName, "%s/%s", homedir, fileName+2);
	  fileName = FullResFileName;
	}	            
	else
	  fileName = NULL;
  }	  

  XrmCombineFileDatabase(fileName, &xrmdb, True);
  if (xrmdb != NULL) {
	int maxCodes1 = -1;
#ifdef PLUGIN_SUPPORT  
	int maxPlugins1 = -1;
#endif	
	GetResourceInt(xrmdb, ResModuleName ".maxcodes", 1, 255, (int *) &maxCodes1); 
	if (maxCodes1 > maxCodesOriginal) maxCodesOriginal = maxCodes1;
#ifdef PLUGIN_SUPPORT  
	GetResourceInt(xrmdb, ResModuleName ".maxplugins",  1, 255, (int *) &maxPlugins1); 
	if (maxPlugins1 > maxPluginsOriginal) maxPluginsOriginal = maxPlugins1;
#endif	
  }
  
  if (maxCodesOriginal < 0) maxCodesOriginal = 50;	
#ifdef PLUGIN_SUPPORT  
  if (maxPluginsOriginal < 0) maxPluginsOriginal = 20;	
#endif
  *fullResFileNamePtr = FullResFileName;  
  return xrmdb;
}



#ifdef PLUGIN_SUPPORT  
Bool AddPlugin(unsigned int lineNo, const char *pluginName, const char *pluginShortName, const char *pluginInitStr)
{

    PLUGIN_HANDLE   handle;
    XHKEYS_PLUGIN_INIT  *initFunc;
    char *fullPluginName;
    const char *prefName;
    Bool success = False;
    void *plBuffer;
    char msg[161], msg1[81];
    int i;

    if (pluginName == NULL || *pluginName == '\0') return False;

//    printf ("InitPlugin %s\n", pluginName);	

    {	int len, maxLen = 0;
	
	for (i=0; (prefName = PluginDirs[i]) != NULL; i++) {
	    if ((len = strlen(prefName)) > maxLen) maxLen = len;	
	}    

        fullPluginName = malloc(strlen(pluginName) + maxLen + 7);
    }

    handle = NULL;

    for (i=0; (prefName = PluginDirs[i]) != NULL; i++) {
        strcpy(fullPluginName, prefName);
        strcat(fullPluginName, "/");
        strcat(fullPluginName, pluginName);
        strcat(fullPluginName, ".so");
        handle = (PLUGIN_HANDLE) dlopen (fullPluginName, RTLD_LAZY);
        if (handle == NULL) continue;
	/*
        if (handle == NULL) {
	    printf ("Error '%s'\n", dlerror());	
	    continue;
	}    
	*/	

	sprintf (msg, "Loading plugin '%s'\n", fullPluginName);	
	log_message(False, msg);


	if (validatePlugin(fullPluginName, handle, msg, sizeof(msg))==False) {
	    log_message(True, msg);
	    continue;
	}        

	initFunc = (XHKEYS_PLUGIN_INIT *) dlsym(handle, "init");

        if ((initFunc != NULL) &&  (*initFunc)(&plBuffer, pluginInitStr, msg1, sizeof(msg1)) == False) {
	    sprintf(msg, "Plugin '%s' initialisation error:\n\t%s", fullPluginName, msg1);
	    log_message(True, msg);
	    continue;
	}      
		    
	success = True;
	break;    
    }


    
    if (success) {
        Plugins[PluginCount].lineno = lineNo;
        Plugins[PluginCount].name = strdup(pluginName);
        Plugins[PluginCount].fullPath = strdup(fullPluginName);
        Plugins[PluginCount].shortName =
	     (pluginShortName == NULL) ? NULL : strdup(pluginShortName);
	Plugins[PluginCount].initString = strdup(pluginInitStr);
	Plugins[PluginCount].handle = handle;
	Plugins[PluginCount].buffer = plBuffer;
        PluginCount++;
    }	
    else 
        sprintf(msg, "Failed to initialize plugin '%s'", pluginName);
        
    free(fullPluginName);
    return success;
}

static Bool UpdatePluginInternal(XrmDatabase  xrmdb, int pos, char **errMsg);

int AddDefaultPlugins(XrmDatabase database)
{
    int count = 0;
    
#if defined(CDROM_SUPPORT) || defined(MIXER_SUPPORT)
    
    int i, j;
    const char *pluginName;
    char initStr[121] = "";
    int maxLineNo = 0;
    int lineNo;
    
    for (i=0; (pluginName = DefaultPluginNames[i*2]) != NULL; i++) {

	for (j=0; j < PluginCount; j++) {
	    if (strcmp(pluginName, Plugins[j].name) == 0) break;
	    if ((lineNo = Plugins[j].lineno) > maxLineNo) maxLineNo = lineNo;
	}	

	if (j >= PluginCount) {
#if defined(CDROM_SUPPORT)
	    if (strcmp(pluginName, "xhkeys_cdaudio") == 0) 
		sprintf(initStr, "devname=\"%s\";devgrab=%c",
		        CDDevName, holdCD ? 'y' : 'n');
# ifdef MIXER_SUPPORT
	    else
# endif	    	    
#endif

#if defined(MIXER_SUPPORT)
//	    if (strcmp(pluginName, "xhkeys_mixer") == 0) 
		sprintf(initStr, "devname=\"%s\"channel=%d;devgrab=%c",
		        MixerDevName, mixerChannel, holdMixer ? 'y' : 'n');
#endif	
	    if (++maxLineNo < maxPlugins) {	
		if (AddPlugin(maxLineNo, pluginName, DefaultPluginNames[i*2+1],
		                     initStr)) {
		    UpdatePluginInternal(database, PluginCount-1, NULL);	
		    count++;
		}    
	    }	
	    
	}    
    }
#endif    

    return count;
}

void DeinitPlugin(PluginData *plData)
{
    char *text;
    void *handle;
    void *buffer;
    
    if ((text=(char *)plData->name) != NULL) {
	free(text); plData->name = NULL;
    }	

    if ((text=(char *)plData->shortName) != NULL) {
	free(text); plData->name = NULL;
    }	

    if ((text=(char *)plData->fullPath) != NULL) {
	free(text); plData->fullPath = NULL;
    }	

    if ((text=(char *)plData->initString) != NULL) {
	free(text); plData->initString = NULL;
    }

    buffer = plData->buffer;
    
    if ((handle = plData->handle) != NULL) {
	XHKEYS_PLUGIN_TERM *term_func = (XHKEYS_PLUGIN_TERM *) dlsym(handle, "term");
	if (term_func != NULL) (*term_func)(buffer);
	dlclose(handle);
	plData->handle = NULL;
    }
    
    if (buffer != NULL) {
	free(buffer); plData->buffer = NULL;
    }	
    
}
#endif


// getFlags 1 - get cmd lines 2 - get plugins 3 - both, 7 - both + defaultplugins

Bool ProcessResources(const char *fileName, Bool getGlobal, int getFlags, char **errMsg)
{
  XrmDatabase  xrmdb = NULL; 
  int  i, j, cmdType;
  char *FullResFileName = NULL;
  char *parm, *parm1;
  char *codeStr, *modifStr, *typeStr, *comPtr, *cmdNext;
  char parmname[81];
  short type_modifier;	      // Key: 0 - keysym (Y), 1 - scan code (S)
  short target_selection;	  // Select target window by:
                              //    0 - WM_CLASS (C), 1 - Title (T), 2 - ID (I), 3 - Stacking Order(0)
  char targetSelCode;
  Bool success = False;
  Bool haveResource;

#ifdef CDROM_SUPPORT
  CDDevName = strdup("/dev/cdrom");
  holdCD = False;
#endif  

#ifdef MIXER_SUPPORT
  MixerDevName = strdup("/dev/mixer");
  holdMixer = False;
  mixerChannel = -1;
#endif  


  keyTimeout = 10;	/* 10 (was 5) secs */
  btnTimeout = 15;	/* 15 (was 8) secs */
  keyLattency = 0;
  keyPause = 50000;	/* 50 millisec */
  clickLattency = 0;
  clickPause = 50000;	/* 50 millisec */


  XrmInitialize();
  xrmdb = GetResourceDatabase(fileName, getGlobal, &FullResFileName);

  if (xrmdb == NULL) {
	*errMsg = "Configuration file not found";
	goto OutOfHere;
  }

  maxCodes = maxCodesOriginal;
#ifdef PLUGIN_SUPPORT  
  maxPlugins = maxPluginsOriginal;
#endif  

  GetResourceInt(xrmdb, ResModuleName ".keytimeout", 1, 600, &keyTimeout);
  GetResourceInt(xrmdb, ResModuleName ".clicktimeout", 1, 600, &btnTimeout);

#ifdef CDROM_SUPPORT
  GetResourceString(xrmdb, ResModuleName ".cddevice", &CDDevName); 
  GetResourceBool(xrmdb, ResModuleName ".cdhold", &holdCD);
#endif  


#ifdef MIXER_SUPPORT
  GetResourceString(xrmdb, ResModuleName ".mixerdevice", &MixerDevName); 
  GetResourceInt(xrmdb, ResModuleName ".mixerchannel", -1, SOUND_MIXER_NRDEVICES-1, &mixerChannel);
  GetResourceBool(xrmdb, ResModuleName ".mixerhold", &holdMixer);
#endif  

  GetResourceUlong(xrmdb, ResModuleName ".keylattency", 0lu, 100000000lu,  &keyLattency);
  GetResourceUlong(xrmdb, ResModuleName ".keypause", 0lu, 100000000lu,  &keyPause);
  GetResourceUlong(xrmdb, ResModuleName ".clicklattency", 0lu, 100000000lu,  &clickLattency);
  GetResourceUlong(xrmdb, ResModuleName ".clickpause", 0lu, 100000000lu,  &clickPause);
  

  if (logMode < 0) {
     if (GetResourceString(xrmdb, ResModuleName ".logmode", &parm)) {
	parm1 = strchr(LogModeCodes, toupper(*parm));
	if (parm1 != NULL) logMode = (parm1-LogModeCodes);
	free (parm);
     }	
     if (logMode < 0) logMode = 1;
  }	

	
  if (logConsole < 0) {
      GetResourceBool(xrmdb, ResModuleName ".logconsole", &logConsole);
      if (logConsole < 0) logConsole = 0;
  }          
  
  

#ifdef OSD_SUPPORT
  osdTimeout = 1000;
  osdAlignment = 2;		// Centre
  osdColour = WhitePixel(dpy, screenNo);
  osdBkgrColour = BlackPixel(dpy, screenNo);
  osdTextTop = 0;
//  osdStippleMask = 0x11224488;
//  osdStippleMask = 0x3162C498;
  osdStippleMask = 0x3366CC99;
  osdFrameWidth = 0;

  osdFont =  GetResourceFont(xrmdb, ResModuleName ".osdFont");
  
  if (osdEnabled == -1) {
    Bool osd1 = True;
    GetResourceBool(xrmdb, ResModuleName ".osd", &osd1);
    osdEnabled = osd1 ? 1 : 0;
  }             

  {
    unsigned long timeout1;      
    if ( GetResourceUlong(xrmdb, ResModuleName ".osdTimeout", 0lu, 5000lu, &timeout1) &&
         (timeout1 == 0 || timeout1 >= 300))
	    osdTimeout = timeout1;
  }

       	            
  GetResourceGeometry(xrmdb, ResModuleName ".osdGeometry", &osdRect);
  if (GetResourceString(xrmdb, ResModuleName ".osdHAlignment", &parm)) {
    parm1 = strchr(OSDAlignTypeCodes, toupper(*parm));
    if (parm1 != NULL)  osdAlignment = (parm1-OSDAlignTypeCodes);
    free (parm);
  }	

  if (GetResourceInt(xrmdb, ResModuleName ".osdTextTop", 0, osdRect.height, &osdTextTop) == False);
    osdTextTop = (osdRect.height - osdFont->ascent - osdFont->descent) / 2;    


  if (GetResourceColour(xrmdb, ResModuleName ".osdColour", &osdColour) == False)
      GetResourceColour(xrmdb, ResModuleName ".osdColor", &osdColour);


  if (GetResourceColour(xrmdb, ResModuleName ".osdBkgrColour", &osdBkgrColour) == False)
	GetResourceColour(xrmdb, ResModuleName ".osdBkgrColor", &osdBkgrColour);

  GetResourceInt(xrmdb, ResModuleName ".osdFrameWidth", 0, 4, &osdFrameWidth);
  GetResourceUlong(xrmdb, ResModuleName ".osdBkgrMask", 0lu, 0xfffffffflu, &osdStippleMask);

  osdFrameColour = osdColour;
  if (osdFrameWidth > 0) {    
     if (GetResourceColour(xrmdb, ResModuleName ".osdFrameColour", &osdFrameColour) == False)
	  GetResourceColour(xrmdb, ResModuleName ".osdFrameColor", &osdFrameColour);
  }    	  

#endif  

  if ((getFlags & 1) == 0) {
#ifdef PLUGIN_SUPPORT
	goto GetPlugins;
#else	
	success = True;
	goto OutOfHere;
#endif
  }	

  CommandCount = 0;

  
  Commands = malloc(maxCodes * sizeof(CmdDescr));
  if (Commands == NULL) {
	*errMsg = "MaxCodes is too big";
	goto OutOfHere;
  }

 
  for (i=1; i<=maxCodes; i++)  {
    sprintf(parmname,  ResModuleName ".codeline%d", i);

    haveResource = GetResourceString(xrmdb, parmname, &parm);
    if (haveResource && *parm != '\0') {
	  cmdNext = parm;	  
	  codeStr = strsep(&cmdNext, ";");
	  modifStr = strsep(&cmdNext, ";");
	  typeStr = strsep(&cmdNext, ";");
	  comPtr = strsep(&cmdNext, "");
	  if (codeStr != NULL && modifStr != NULL && typeStr != NULL && comPtr != NULL) {
		cmdType = *typeStr++;
	
		if (isdigit(cmdType)) {
		  cmdType -= '0';  // cmdType = atoi(typeStr);
		  if (cmdType >= CommandTypeCount) cmdType = -1;
		}  
		else {
		  cmdNext = strchr(CommandTypeCodes, cmdType);
		  if (cmdNext == NULL) cmdType = -1;
		  else cmdType = (cmdNext-CommandTypeCodes);
		}

		if (cmdType >= 0) {		  
		  type_modifier = 0;	// By keysym					   
		  target_selection = 0;	// By WM_CLASS


#ifdef PLUGIN_SUPPORT
		  if (cmdType == CT_PLUGIN) {
			if (strchr(typeStr, PluginTypeModif[1]))
		    	    type_modifier = 1;        // By plugin order number

			if (strchr(typeStr, PluginBehaviour[1]))
		    	    target_selection = 1;     // Continuous

		  } else
#endif		    	    
		  if (cmdType == CT_EXTAPP || cmdType == CT_INTERNAL) {
		     for (j=0; (targetSelCode = AppTypeTitles[j]) != '\0'; j++) {
			if (strchr(typeStr, targetSelCode)) {
			    type_modifier = j+1;
			}	
		     }				
		  } else
		  if (cmdType == CT_KEYEVENT || cmdType == CT_BTNEVENT) {
		     
		     for (j=1; (targetSelCode = TargetSelCodes[j]) != '\0'; j++) {
			if (strchr(typeStr, targetSelCode)) {
				target_selection = j; break;
			}	
		     }				

		     // By scancode, keysym, keycode
		     if (cmdType == CT_KEYEVENT) {
		        for (j=1; (targetSelCode = KeyTypeModif[j]) != '\0'; j++) {
			    if (strchr(typeStr, targetSelCode)) {
				type_modifier = j; break;
			    }	
			}    
		     }				
		  }    


		  Commands[CommandCount].lineno = i;
		  Commands[CommandCount].keycode = (unsigned int) strtoul(codeStr, NULL, 0);
		  Commands[CommandCount].modifier = (unsigned int) strtoul(modifStr, NULL, 0);
  		  Commands[CommandCount].type = cmdType;
		  Commands[CommandCount].type_modifier = type_modifier;
		  Commands[CommandCount].target_selection = target_selection;
		  Commands[CommandCount].command = strdup(comPtr);
		  
		  CommandCount++;
		}  
	  }	
	}
	if (haveResource) free(parm);
  }

#ifdef PLUGIN_SUPPORT  
GetPlugins:
    if ((getFlags & 2) == 0) {
	success = True;
	goto OutOfHere;
    }	


  PluginCount = 0;
  pluginTimeout = 500l;
  
  GetResourceUlong(xrmdb, ResModuleName ".pluginTimeout", 300lu, 5000lu, &pluginTimeout);
  
  Plugins = malloc(maxPlugins * sizeof(PluginData));
  if (Plugins == NULL) {
	*errMsg = "MaxPlugins is too big";
	goto OutOfHere;
  }

  for (i=1; i<=maxPlugins; i++)  {
    sprintf(parmname,  ResModuleName ".plugin%d", i);
    haveResource = GetResourceString(xrmdb, parmname, &parm);
    if (haveResource && parm != NULL) {
	if (*parm != '\0') {
	    cmdNext = parm;	  
	    codeStr = strsep(&cmdNext, ";");	// plugin name
	    typeStr = strsep(&cmdNext, ";");	// plugin short name
	    comPtr = strsep(&cmdNext, "");	// plugin parameters
	    AddPlugin(i, codeStr, typeStr, comPtr);
	}
	free(parm);
    }	
  }

  if ((getFlags & 4) != 0 && AddDefaultPlugins(xrmdb) > 0)
	  XrmPutFileDatabase(xrmdb, FullResFileName);
#endif  
          
  success = True;
  

OutOfHere:
  if (FullResFileName != NULL) free(FullResFileName);
  if (xrmdb != NULL) XrmDestroyDatabase(xrmdb);

  return success;
}


#ifdef PLUGIN_SUPPORT

static Bool UpdatePluginInternal(XrmDatabase  xrmdb, int pos, char **errMsg)
{
    char line[301];
    char resName[121];
    PluginData *plData;
    Bool success = False;
    const char *name;

    plData = Plugins + pos;
    sprintf(resName, ResModuleName ".plugin%d", plData->lineno);

    name = plData->name;
    
    if (name == NULL) 
	*line = '\0';
    else {
	const char *shortName = plData->shortName;
	const char *initString = plData->initString;
	if (shortName == NULL) shortName = "";   
	if (initString == NULL) initString = "";   
	
	snprintf(line, sizeof(line), "%s;%s;%s", name, shortName, initString);  
    }
    
    XrmPutStringResource(&xrmdb, resName, line);

    success = True;

// OutOfHere:

    return success;

}

Bool UpdatePlugin(const char *fileName, int pos, char **errMsg)
{
    XrmDatabase  xrmdb = NULL; 
    Bool success = False;
    char *FullResFileName = NULL;
    

    XrmPutFileDatabase(xrmdb, FullResFileName);
    
    xrmdb = GetResourceDatabase(fileName, False, &FullResFileName);

    success = UpdatePluginInternal(xrmdb, pos, errMsg);
    
    /*
    if (xrmdb == NULL) {
	if (errMsg != NULL)
	    *errMsg = "Configuration file not found";
	goto OutOfHere;
    }
    */
/* 
    sprintf(line, "%d", maxPlugins);
    XrmPutStringResource(&xrmdb, ResModuleName ".maxplugins", line);
*/

    if (success) XrmPutFileDatabase(xrmdb, FullResFileName);

    if (maxPlugins > maxPluginsOriginal) maxPluginsOriginal = maxPlugins;
    if (FullResFileName != NULL) free(FullResFileName);
    if (xrmdb != NULL) XrmDestroyDatabase(xrmdb);
    
    return success;
}
#endif

Bool UpdateResource(const char *fileName, int pos, char **errMsg)
{
  char line[301];
  char resName[121];
  char typeChr[5];
  XrmDatabase  xrmdb = NULL; 
  int  j, k,  cmdType; 
  char *FullResFileName = NULL;
  Bool success = False;
  CmdDescr *cmd;

  xrmdb = GetResourceDatabase(fileName, False, &FullResFileName);

/*
  if (xrmdb == NULL) {
	*errMsg = "Configuration file not found";
	goto OutOfHere;
  }
*/

/* !!!!!!!!!!!!!!!!
    sprintf(line, "%d", maxCodes);
    XrmPutStringResource(&xrmdb, ResModuleName ".maxcodes", line);
*/

  cmd = Commands + pos; 
  sprintf(resName, ResModuleName ".codeline%d", cmd->lineno);

  cmdType = cmd->type;
  if(cmdType == CT_DELETED)
	*line = '\0';
  else {	
	j = 0;
	typeChr[j++] = CommandTypeCodes[cmdType];
#ifdef PLUGIN_SUPPORT
	if (cmdType == CT_PLUGIN) {
	    typeChr[j++] = PluginTypeModif[cmd->type_modifier];  
	    if ((k = cmd->target_selection) > 0)
		typeChr[j++] = PluginBehaviour[k];  
	} else    
#endif	
	if (cmdType == CT_EXTAPP || cmdType == CT_INTERNAL) {
	    if ((k = cmd->type_modifier) > 0)
		typeChr[j++] = AppTypeTitles[k-1];  
	} else
	if (cmdType == CT_KEYEVENT || cmdType == CT_BTNEVENT) {
	    typeChr[j++] = TargetSelCodes[cmd->target_selection];
	    if (cmdType == CT_KEYEVENT)
		typeChr[j++] = KeyTypeModif[cmd->type_modifier];
	}	
	typeChr[j] = '\0';

	snprintf(line, sizeof(line), "%d;%d;%s;%s", cmd->keycode, cmd->modifier, typeChr, cmd->command);		
  }	
  XrmPutStringResource(&xrmdb, resName, line);


  XrmPutFileDatabase(xrmdb, FullResFileName);
  if (maxCodes > maxCodesOriginal) maxCodesOriginal = maxCodes;
  success = True;

/* OutOfHere: */
  if (FullResFileName != NULL) free(FullResFileName);
  if (xrmdb != NULL) XrmDestroyDatabase(xrmdb);
  return success;
}


void FreeResources(void)
{
  int i;
  char *text;

#ifdef CDROM_SUPPORT
  if (CDDevName != NULL) {
	free(CDDevName);
	CDDevName = NULL;
  }	
#endif
#ifdef MIXER_SUPPORT
  if (MixerDevName != NULL) {
	free(MixerDevName);
	MixerDevName = NULL;
  }	
#endif

  if (Commands != NULL) {
  
      for (i=0; i<CommandCount; i++)  {
	if ((text=(char *)Commands[i].command) != NULL) free(text);
      }	
      free(Commands); Commands = NULL;
  }          

#ifdef PLUGIN_SUPPORT
  if (Plugins != NULL) {
  
      for (i=0; i<PluginCount; i++)  
        DeinitPlugin(Plugins+i);
      
      free(Plugins); Plugins = NULL;
  }          
#endif  

#ifdef OSD_SUPPORT
    if (osdFont != NULL) {
	XFreeFont(dpy, osdFont);
	osdFont = NULL;
    }
#endif
}

