// Code generated by protoc-gen-go. DO NOT EDIT.
// source: tunnelservice.proto

/*
Package protocol is a generated protocol buffer package.

It is generated from these files:
	tunnelservice.proto

It has these top-level messages:
	Error
	Tunnel
	CreateTunnelRequest
	CreateTunnelResponse
	DeleteTunnelRequest
	DeleteTunnelResponse
	ListTunnelRequest
	TunnelInfo
	ListTunnelResponse
	DescribeTunnelRequest
	ChannelInfo
	DescribeTunnelResponse
	GetRpoRequest
	GetRpoResponse
	ClientConfig
	ConnectRequest
	ConnectResponse
	Channel
	HeartbeatRequest
	HeartbeatResponse
	ShutdownRequest
	ShutdownResponse
	LockChannelRequest
	LockChannelResponse
	UnlockChannelRequest
	UnlockChannelResponse
	GetCheckpointRequest
	GetCheckpointResponse
	CheckpointRequest
	CheckpointResponse
	ReadRecordsRequest
	Record
	ReadRecordsResponse
	Token
	TokenContent
	TokenContentV2
*/
package protocol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type TunnelType int32

const (
	TunnelType_BaseData      TunnelType = 1
	TunnelType_Stream        TunnelType = 2
	TunnelType_BaseAndStream TunnelType = 3
)

var TunnelType_name = map[int32]string{
	1: "BaseData",
	2: "Stream",
	3: "BaseAndStream",
}
var TunnelType_value = map[string]int32{
	"BaseData":      1,
	"Stream":        2,
	"BaseAndStream": 3,
}

func (x TunnelType) Enum() *TunnelType {
	p := new(TunnelType)
	*p = x
	return p
}
func (x TunnelType) String() string {
	return proto.EnumName(TunnelType_name, int32(x))
}
func (x *TunnelType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TunnelType_value, data, "TunnelType")
	if err != nil {
		return err
	}
	*x = TunnelType(value)
	return nil
}
func (TunnelType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ChannelStatus int32

const (
	ChannelStatus_OPEN       ChannelStatus = 1
	ChannelStatus_CLOSING    ChannelStatus = 2
	ChannelStatus_CLOSE      ChannelStatus = 3
	ChannelStatus_TERMINATED ChannelStatus = 4
)

var ChannelStatus_name = map[int32]string{
	1: "OPEN",
	2: "CLOSING",
	3: "CLOSE",
	4: "TERMINATED",
}
var ChannelStatus_value = map[string]int32{
	"OPEN":       1,
	"CLOSING":    2,
	"CLOSE":      3,
	"TERMINATED": 4,
}

func (x ChannelStatus) Enum() *ChannelStatus {
	p := new(ChannelStatus)
	*p = x
	return p
}
func (x ChannelStatus) String() string {
	return proto.EnumName(ChannelStatus_name, int32(x))
}
func (x *ChannelStatus) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ChannelStatus_value, data, "ChannelStatus")
	if err != nil {
		return err
	}
	*x = ChannelStatus(value)
	return nil
}
func (ChannelStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type ActionType int32

const (
	ActionType_PUT_ROW    ActionType = 1
	ActionType_UPDATE_ROW ActionType = 2
	ActionType_DELETE_ROW ActionType = 3
)

var ActionType_name = map[int32]string{
	1: "PUT_ROW",
	2: "UPDATE_ROW",
	3: "DELETE_ROW",
}
var ActionType_value = map[string]int32{
	"PUT_ROW":    1,
	"UPDATE_ROW": 2,
	"DELETE_ROW": 3,
}

func (x ActionType) Enum() *ActionType {
	p := new(ActionType)
	*p = x
	return p
}
func (x ActionType) String() string {
	return proto.EnumName(ActionType_name, int32(x))
}
func (x *ActionType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ActionType_value, data, "ActionType")
	if err != nil {
		return err
	}
	*x = ActionType(value)
	return nil
}
func (ActionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type Error struct {
	Code             *string `protobuf:"bytes,1,req,name=code" json:"code,omitempty"`
	Message          *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	TunnelId         *string `protobuf:"bytes,3,opt,name=tunnel_id" json:"tunnel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Error) GetCode() string {
	if m != nil && m.Code != nil {
		return *m.Code
	}
	return ""
}

func (m *Error) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *Error) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

type Tunnel struct {
	TableName        *string     `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	TunnelName       *string     `protobuf:"bytes,3,req,name=tunnel_name" json:"tunnel_name,omitempty"`
	TunnelType       *TunnelType `protobuf:"varint,4,req,name=tunnel_type,enum=protocol.TunnelType" json:"tunnel_type,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Tunnel) Reset()                    { *m = Tunnel{} }
func (m *Tunnel) String() string            { return proto.CompactTextString(m) }
func (*Tunnel) ProtoMessage()               {}
func (*Tunnel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Tunnel) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *Tunnel) GetTunnelName() string {
	if m != nil && m.TunnelName != nil {
		return *m.TunnelName
	}
	return ""
}

func (m *Tunnel) GetTunnelType() TunnelType {
	if m != nil && m.TunnelType != nil {
		return *m.TunnelType
	}
	return TunnelType_BaseData
}

type CreateTunnelRequest struct {
	Tunnel           *Tunnel `protobuf:"bytes,1,req,name=tunnel" json:"tunnel,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CreateTunnelRequest) Reset()                    { *m = CreateTunnelRequest{} }
func (m *CreateTunnelRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTunnelRequest) ProtoMessage()               {}
func (*CreateTunnelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *CreateTunnelRequest) GetTunnel() *Tunnel {
	if m != nil {
		return m.Tunnel
	}
	return nil
}

type CreateTunnelResponse struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CreateTunnelResponse) Reset()                    { *m = CreateTunnelResponse{} }
func (m *CreateTunnelResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateTunnelResponse) ProtoMessage()               {}
func (*CreateTunnelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreateTunnelResponse) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

type DeleteTunnelRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	TunnelName       *string `protobuf:"bytes,2,req,name=tunnel_name" json:"tunnel_name,omitempty"`
	TunnelId         *string `protobuf:"bytes,3,opt,name=tunnel_id" json:"tunnel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DeleteTunnelRequest) Reset()                    { *m = DeleteTunnelRequest{} }
func (m *DeleteTunnelRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTunnelRequest) ProtoMessage()               {}
func (*DeleteTunnelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *DeleteTunnelRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DeleteTunnelRequest) GetTunnelName() string {
	if m != nil && m.TunnelName != nil {
		return *m.TunnelName
	}
	return ""
}

func (m *DeleteTunnelRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

type DeleteTunnelResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteTunnelResponse) Reset()                    { *m = DeleteTunnelResponse{} }
func (m *DeleteTunnelResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteTunnelResponse) ProtoMessage()               {}
func (*DeleteTunnelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type ListTunnelRequest struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ListTunnelRequest) Reset()                    { *m = ListTunnelRequest{} }
func (m *ListTunnelRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTunnelRequest) ProtoMessage()               {}
func (*ListTunnelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListTunnelRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type TunnelInfo struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	TunnelType       *string `protobuf:"bytes,2,req,name=tunnel_type" json:"tunnel_type,omitempty"`
	TableName        *string `protobuf:"bytes,3,req,name=table_name" json:"table_name,omitempty"`
	InstanceName     *string `protobuf:"bytes,4,req,name=instance_name" json:"instance_name,omitempty"`
	StreamId         *string `protobuf:"bytes,5,req,name=stream_id" json:"stream_id,omitempty"`
	Stage            *string `protobuf:"bytes,6,req,name=stage" json:"stage,omitempty"`
	Expired          *bool   `protobuf:"varint,7,opt,name=expired" json:"expired,omitempty"`
	TunnelName       *string `protobuf:"bytes,8,opt,name=tunnel_name" json:"tunnel_name,omitempty"`
	Public           *bool   `protobuf:"varint,9,opt,name=public" json:"public,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TunnelInfo) Reset()                    { *m = TunnelInfo{} }
func (m *TunnelInfo) String() string            { return proto.CompactTextString(m) }
func (*TunnelInfo) ProtoMessage()               {}
func (*TunnelInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *TunnelInfo) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *TunnelInfo) GetTunnelType() string {
	if m != nil && m.TunnelType != nil {
		return *m.TunnelType
	}
	return ""
}

func (m *TunnelInfo) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TunnelInfo) GetInstanceName() string {
	if m != nil && m.InstanceName != nil {
		return *m.InstanceName
	}
	return ""
}

func (m *TunnelInfo) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *TunnelInfo) GetStage() string {
	if m != nil && m.Stage != nil {
		return *m.Stage
	}
	return ""
}

func (m *TunnelInfo) GetExpired() bool {
	if m != nil && m.Expired != nil {
		return *m.Expired
	}
	return false
}

func (m *TunnelInfo) GetTunnelName() string {
	if m != nil && m.TunnelName != nil {
		return *m.TunnelName
	}
	return ""
}

func (m *TunnelInfo) GetPublic() bool {
	if m != nil && m.Public != nil {
		return *m.Public
	}
	return false
}

type ListTunnelResponse struct {
	Tunnels          []*TunnelInfo `protobuf:"bytes,1,rep,name=tunnels" json:"tunnels,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ListTunnelResponse) Reset()                    { *m = ListTunnelResponse{} }
func (m *ListTunnelResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTunnelResponse) ProtoMessage()               {}
func (*ListTunnelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListTunnelResponse) GetTunnels() []*TunnelInfo {
	if m != nil {
		return m.Tunnels
	}
	return nil
}

type DescribeTunnelRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	TunnelName       *string `protobuf:"bytes,2,req,name=tunnel_name" json:"tunnel_name,omitempty"`
	TunnelId         *string `protobuf:"bytes,3,opt,name=tunnel_id" json:"tunnel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DescribeTunnelRequest) Reset()                    { *m = DescribeTunnelRequest{} }
func (m *DescribeTunnelRequest) String() string            { return proto.CompactTextString(m) }
func (*DescribeTunnelRequest) ProtoMessage()               {}
func (*DescribeTunnelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DescribeTunnelRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DescribeTunnelRequest) GetTunnelName() string {
	if m != nil && m.TunnelName != nil {
		return *m.TunnelName
	}
	return ""
}

func (m *DescribeTunnelRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

type ChannelInfo struct {
	ChannelId        *string `protobuf:"bytes,1,req,name=channel_id" json:"channel_id,omitempty"`
	ChannelType      *string `protobuf:"bytes,2,opt,name=channel_type" json:"channel_type,omitempty"`
	ChannelStatus    *string `protobuf:"bytes,3,opt,name=channel_status" json:"channel_status,omitempty"`
	ClientId         *string `protobuf:"bytes,4,opt,name=client_id" json:"client_id,omitempty"`
	ChannelRpo       *int64  `protobuf:"varint,5,opt,name=channel_rpo" json:"channel_rpo,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ChannelInfo) Reset()                    { *m = ChannelInfo{} }
func (m *ChannelInfo) String() string            { return proto.CompactTextString(m) }
func (*ChannelInfo) ProtoMessage()               {}
func (*ChannelInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ChannelInfo) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *ChannelInfo) GetChannelType() string {
	if m != nil && m.ChannelType != nil {
		return *m.ChannelType
	}
	return ""
}

func (m *ChannelInfo) GetChannelStatus() string {
	if m != nil && m.ChannelStatus != nil {
		return *m.ChannelStatus
	}
	return ""
}

func (m *ChannelInfo) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *ChannelInfo) GetChannelRpo() int64 {
	if m != nil && m.ChannelRpo != nil {
		return *m.ChannelRpo
	}
	return 0
}

type DescribeTunnelResponse struct {
	Tunnel           *TunnelInfo    `protobuf:"bytes,1,req,name=tunnel" json:"tunnel,omitempty"`
	Channels         []*ChannelInfo `protobuf:"bytes,2,rep,name=channels" json:"channels,omitempty"`
	TunnelRpo        *int64         `protobuf:"varint,3,opt,name=tunnel_rpo" json:"tunnel_rpo,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *DescribeTunnelResponse) Reset()                    { *m = DescribeTunnelResponse{} }
func (m *DescribeTunnelResponse) String() string            { return proto.CompactTextString(m) }
func (*DescribeTunnelResponse) ProtoMessage()               {}
func (*DescribeTunnelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *DescribeTunnelResponse) GetTunnel() *TunnelInfo {
	if m != nil {
		return m.Tunnel
	}
	return nil
}

func (m *DescribeTunnelResponse) GetChannels() []*ChannelInfo {
	if m != nil {
		return m.Channels
	}
	return nil
}

func (m *DescribeTunnelResponse) GetTunnelRpo() int64 {
	if m != nil && m.TunnelRpo != nil {
		return *m.TunnelRpo
	}
	return 0
}

type GetRpoRequest struct {
	TunnelId         *string `protobuf:"bytes,1,opt,name=tunnel_id" json:"tunnel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetRpoRequest) Reset()                    { *m = GetRpoRequest{} }
func (m *GetRpoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRpoRequest) ProtoMessage()               {}
func (*GetRpoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetRpoRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

type GetRpoResponse struct {
	RpoInfos         []byte `protobuf:"bytes,1,opt,name=rpo_infos" json:"rpo_infos,omitempty"`
	TunnelRpoInfos   []byte `protobuf:"bytes,2,opt,name=tunnel_rpo_infos" json:"tunnel_rpo_infos,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GetRpoResponse) Reset()                    { *m = GetRpoResponse{} }
func (m *GetRpoResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRpoResponse) ProtoMessage()               {}
func (*GetRpoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetRpoResponse) GetRpoInfos() []byte {
	if m != nil {
		return m.RpoInfos
	}
	return nil
}

func (m *GetRpoResponse) GetTunnelRpoInfos() []byte {
	if m != nil {
		return m.TunnelRpoInfos
	}
	return nil
}

type ClientConfig struct {
	Timeout          *int64  `protobuf:"varint,1,opt,name=timeout" json:"timeout,omitempty"`
	ClientTag        *string `protobuf:"bytes,2,opt,name=client_tag" json:"client_tag,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ClientConfig) Reset()                    { *m = ClientConfig{} }
func (m *ClientConfig) String() string            { return proto.CompactTextString(m) }
func (*ClientConfig) ProtoMessage()               {}
func (*ClientConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ClientConfig) GetTimeout() int64 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *ClientConfig) GetClientTag() string {
	if m != nil && m.ClientTag != nil {
		return *m.ClientTag
	}
	return ""
}

type ConnectRequest struct {
	TunnelId         *string       `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientConfig     *ClientConfig `protobuf:"bytes,2,opt,name=client_config" json:"client_config,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ConnectRequest) Reset()                    { *m = ConnectRequest{} }
func (m *ConnectRequest) String() string            { return proto.CompactTextString(m) }
func (*ConnectRequest) ProtoMessage()               {}
func (*ConnectRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ConnectRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *ConnectRequest) GetClientConfig() *ClientConfig {
	if m != nil {
		return m.ClientConfig
	}
	return nil
}

type ConnectResponse struct {
	ClientId         *string `protobuf:"bytes,1,req,name=client_id" json:"client_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ConnectResponse) Reset()                    { *m = ConnectResponse{} }
func (m *ConnectResponse) String() string            { return proto.CompactTextString(m) }
func (*ConnectResponse) ProtoMessage()               {}
func (*ConnectResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ConnectResponse) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

type Channel struct {
	ChannelId        *string        `protobuf:"bytes,1,req,name=channel_id" json:"channel_id,omitempty"`
	Version          *int64         `protobuf:"varint,2,req,name=version" json:"version,omitempty"`
	Status           *ChannelStatus `protobuf:"varint,3,req,name=status,enum=protocol.ChannelStatus" json:"status,omitempty"`
	Detail           []byte         `protobuf:"bytes,4,opt,name=detail" json:"detail,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Channel) Reset()                    { *m = Channel{} }
func (m *Channel) String() string            { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()               {}
func (*Channel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Channel) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *Channel) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *Channel) GetStatus() ChannelStatus {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ChannelStatus_OPEN
}

func (m *Channel) GetDetail() []byte {
	if m != nil {
		return m.Detail
	}
	return nil
}

type HeartbeatRequest struct {
	TunnelId         *string    `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string    `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	Channels         []*Channel `protobuf:"bytes,3,rep,name=channels" json:"channels,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *HeartbeatRequest) Reset()                    { *m = HeartbeatRequest{} }
func (m *HeartbeatRequest) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatRequest) ProtoMessage()               {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *HeartbeatRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *HeartbeatRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *HeartbeatRequest) GetChannels() []*Channel {
	if m != nil {
		return m.Channels
	}
	return nil
}

type HeartbeatResponse struct {
	Channels         []*Channel `protobuf:"bytes,1,rep,name=channels" json:"channels,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *HeartbeatResponse) Reset()                    { *m = HeartbeatResponse{} }
func (m *HeartbeatResponse) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatResponse) ProtoMessage()               {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *HeartbeatResponse) GetChannels() []*Channel {
	if m != nil {
		return m.Channels
	}
	return nil
}

type ShutdownRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ShutdownRequest) Reset()                    { *m = ShutdownRequest{} }
func (m *ShutdownRequest) String() string            { return proto.CompactTextString(m) }
func (*ShutdownRequest) ProtoMessage()               {}
func (*ShutdownRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ShutdownRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *ShutdownRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

type ShutdownResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ShutdownResponse) Reset()                    { *m = ShutdownResponse{} }
func (m *ShutdownResponse) String() string            { return proto.CompactTextString(m) }
func (*ShutdownResponse) ProtoMessage()               {}
func (*ShutdownResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

type LockChannelRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	ChannelId        *string `protobuf:"bytes,3,req,name=channel_id" json:"channel_id,omitempty"`
	LockId           *string `protobuf:"bytes,4,req,name=lock_id" json:"lock_id,omitempty"`
	Timeout          *int64  `protobuf:"varint,5,req,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LockChannelRequest) Reset()                    { *m = LockChannelRequest{} }
func (m *LockChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*LockChannelRequest) ProtoMessage()               {}
func (*LockChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *LockChannelRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *LockChannelRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *LockChannelRequest) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *LockChannelRequest) GetLockId() string {
	if m != nil && m.LockId != nil {
		return *m.LockId
	}
	return ""
}

func (m *LockChannelRequest) GetTimeout() int64 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type LockChannelResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *LockChannelResponse) Reset()                    { *m = LockChannelResponse{} }
func (m *LockChannelResponse) String() string            { return proto.CompactTextString(m) }
func (*LockChannelResponse) ProtoMessage()               {}
func (*LockChannelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

type UnlockChannelRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	ChannelId        *string `protobuf:"bytes,3,req,name=channel_id" json:"channel_id,omitempty"`
	LockId           *string `protobuf:"bytes,4,req,name=lock_id" json:"lock_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *UnlockChannelRequest) Reset()                    { *m = UnlockChannelRequest{} }
func (m *UnlockChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*UnlockChannelRequest) ProtoMessage()               {}
func (*UnlockChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *UnlockChannelRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *UnlockChannelRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *UnlockChannelRequest) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *UnlockChannelRequest) GetLockId() string {
	if m != nil && m.LockId != nil {
		return *m.LockId
	}
	return ""
}

type UnlockChannelResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *UnlockChannelResponse) Reset()                    { *m = UnlockChannelResponse{} }
func (m *UnlockChannelResponse) String() string            { return proto.CompactTextString(m) }
func (*UnlockChannelResponse) ProtoMessage()               {}
func (*UnlockChannelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

type GetCheckpointRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	ChannelId        *string `protobuf:"bytes,3,req,name=channel_id" json:"channel_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetCheckpointRequest) Reset()                    { *m = GetCheckpointRequest{} }
func (m *GetCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCheckpointRequest) ProtoMessage()               {}
func (*GetCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *GetCheckpointRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *GetCheckpointRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *GetCheckpointRequest) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

type GetCheckpointResponse struct {
	Checkpoint       *string `protobuf:"bytes,1,req,name=checkpoint" json:"checkpoint,omitempty"`
	SequenceNumber   *int64  `protobuf:"varint,2,req,name=sequence_number" json:"sequence_number,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetCheckpointResponse) Reset()                    { *m = GetCheckpointResponse{} }
func (m *GetCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*GetCheckpointResponse) ProtoMessage()               {}
func (*GetCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *GetCheckpointResponse) GetCheckpoint() string {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return ""
}

func (m *GetCheckpointResponse) GetSequenceNumber() int64 {
	if m != nil && m.SequenceNumber != nil {
		return *m.SequenceNumber
	}
	return 0
}

type CheckpointRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	ChannelId        *string `protobuf:"bytes,3,req,name=channel_id" json:"channel_id,omitempty"`
	Checkpoint       *string `protobuf:"bytes,4,req,name=checkpoint" json:"checkpoint,omitempty"`
	SequenceNumber   *int64  `protobuf:"varint,5,req,name=sequence_number" json:"sequence_number,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CheckpointRequest) Reset()                    { *m = CheckpointRequest{} }
func (m *CheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckpointRequest) ProtoMessage()               {}
func (*CheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *CheckpointRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *CheckpointRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *CheckpointRequest) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *CheckpointRequest) GetCheckpoint() string {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return ""
}

func (m *CheckpointRequest) GetSequenceNumber() int64 {
	if m != nil && m.SequenceNumber != nil {
		return *m.SequenceNumber
	}
	return 0
}

type CheckpointResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *CheckpointResponse) Reset()                    { *m = CheckpointResponse{} }
func (m *CheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckpointResponse) ProtoMessage()               {}
func (*CheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

type ReadRecordsRequest struct {
	TunnelId         *string `protobuf:"bytes,1,req,name=tunnel_id" json:"tunnel_id,omitempty"`
	ClientId         *string `protobuf:"bytes,2,req,name=client_id" json:"client_id,omitempty"`
	ChannelId        *string `protobuf:"bytes,3,req,name=channel_id" json:"channel_id,omitempty"`
	Token            *string `protobuf:"bytes,4,req,name=token" json:"token,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ReadRecordsRequest) Reset()                    { *m = ReadRecordsRequest{} }
func (m *ReadRecordsRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadRecordsRequest) ProtoMessage()               {}
func (*ReadRecordsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *ReadRecordsRequest) GetTunnelId() string {
	if m != nil && m.TunnelId != nil {
		return *m.TunnelId
	}
	return ""
}

func (m *ReadRecordsRequest) GetClientId() string {
	if m != nil && m.ClientId != nil {
		return *m.ClientId
	}
	return ""
}

func (m *ReadRecordsRequest) GetChannelId() string {
	if m != nil && m.ChannelId != nil {
		return *m.ChannelId
	}
	return ""
}

func (m *ReadRecordsRequest) GetToken() string {
	if m != nil && m.Token != nil {
		return *m.Token
	}
	return ""
}

type Record struct {
	ActionType       *ActionType `protobuf:"varint,1,req,name=action_type,enum=protocol.ActionType" json:"action_type,omitempty"`
	Record           []byte      `protobuf:"bytes,2,req,name=record" json:"record,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Record) Reset()                    { *m = Record{} }
func (m *Record) String() string            { return proto.CompactTextString(m) }
func (*Record) ProtoMessage()               {}
func (*Record) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *Record) GetActionType() ActionType {
	if m != nil && m.ActionType != nil {
		return *m.ActionType
	}
	return ActionType_PUT_ROW
}

func (m *Record) GetRecord() []byte {
	if m != nil {
		return m.Record
	}
	return nil
}

type ReadRecordsResponse struct {
	Records          []*Record `protobuf:"bytes,1,rep,name=records" json:"records,omitempty"`
	NextToken        *string   `protobuf:"bytes,2,req,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *ReadRecordsResponse) Reset()                    { *m = ReadRecordsResponse{} }
func (m *ReadRecordsResponse) String() string            { return proto.CompactTextString(m) }
func (*ReadRecordsResponse) ProtoMessage()               {}
func (*ReadRecordsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *ReadRecordsResponse) GetRecords() []*Record {
	if m != nil {
		return m.Records
	}
	return nil
}

func (m *ReadRecordsResponse) GetNextToken() string {
	if m != nil && m.NextToken != nil {
		return *m.NextToken
	}
	return ""
}

type Token struct {
	Version          *int64 `protobuf:"varint,1,req,name=version" json:"version,omitempty"`
	Content          []byte `protobuf:"bytes,2,req,name=content" json:"content,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Token) Reset()                    { *m = Token{} }
func (m *Token) String() string            { return proto.CompactTextString(m) }
func (*Token) ProtoMessage()               {}
func (*Token) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *Token) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *Token) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

type TokenContent struct {
	PrimaryKey       []byte  `protobuf:"bytes,1,opt,name=primary_key" json:"primary_key,omitempty"`
	Iterator         *string `protobuf:"bytes,2,opt,name=iterator" json:"iterator,omitempty"`
	Timestamp        *int64  `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TokenContent) Reset()                    { *m = TokenContent{} }
func (m *TokenContent) String() string            { return proto.CompactTextString(m) }
func (*TokenContent) ProtoMessage()               {}
func (*TokenContent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *TokenContent) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *TokenContent) GetIterator() string {
	if m != nil && m.Iterator != nil {
		return *m.Iterator
	}
	return ""
}

func (m *TokenContent) GetTimestamp() int64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

type TokenContentV2 struct {
	PrimaryKey       []byte  `protobuf:"bytes,1,opt,name=primary_key" json:"primary_key,omitempty"`
	Iterator         *string `protobuf:"bytes,2,opt,name=iterator" json:"iterator,omitempty"`
	Timestamp        *int64  `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
	TotalCount       *int64  `protobuf:"varint,4,opt,name=total_count" json:"total_count,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TokenContentV2) Reset()                    { *m = TokenContentV2{} }
func (m *TokenContentV2) String() string            { return proto.CompactTextString(m) }
func (*TokenContentV2) ProtoMessage()               {}
func (*TokenContentV2) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *TokenContentV2) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *TokenContentV2) GetIterator() string {
	if m != nil && m.Iterator != nil {
		return *m.Iterator
	}
	return ""
}

func (m *TokenContentV2) GetTimestamp() int64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *TokenContentV2) GetTotalCount() int64 {
	if m != nil && m.TotalCount != nil {
		return *m.TotalCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Error)(nil), "protocol.Error")
	proto.RegisterType((*Tunnel)(nil), "protocol.Tunnel")
	proto.RegisterType((*CreateTunnelRequest)(nil), "protocol.CreateTunnelRequest")
	proto.RegisterType((*CreateTunnelResponse)(nil), "protocol.CreateTunnelResponse")
	proto.RegisterType((*DeleteTunnelRequest)(nil), "protocol.DeleteTunnelRequest")
	proto.RegisterType((*DeleteTunnelResponse)(nil), "protocol.DeleteTunnelResponse")
	proto.RegisterType((*ListTunnelRequest)(nil), "protocol.ListTunnelRequest")
	proto.RegisterType((*TunnelInfo)(nil), "protocol.TunnelInfo")
	proto.RegisterType((*ListTunnelResponse)(nil), "protocol.ListTunnelResponse")
	proto.RegisterType((*DescribeTunnelRequest)(nil), "protocol.DescribeTunnelRequest")
	proto.RegisterType((*ChannelInfo)(nil), "protocol.ChannelInfo")
	proto.RegisterType((*DescribeTunnelResponse)(nil), "protocol.DescribeTunnelResponse")
	proto.RegisterType((*GetRpoRequest)(nil), "protocol.GetRpoRequest")
	proto.RegisterType((*GetRpoResponse)(nil), "protocol.GetRpoResponse")
	proto.RegisterType((*ClientConfig)(nil), "protocol.ClientConfig")
	proto.RegisterType((*ConnectRequest)(nil), "protocol.ConnectRequest")
	proto.RegisterType((*ConnectResponse)(nil), "protocol.ConnectResponse")
	proto.RegisterType((*Channel)(nil), "protocol.Channel")
	proto.RegisterType((*HeartbeatRequest)(nil), "protocol.HeartbeatRequest")
	proto.RegisterType((*HeartbeatResponse)(nil), "protocol.HeartbeatResponse")
	proto.RegisterType((*ShutdownRequest)(nil), "protocol.ShutdownRequest")
	proto.RegisterType((*ShutdownResponse)(nil), "protocol.ShutdownResponse")
	proto.RegisterType((*LockChannelRequest)(nil), "protocol.LockChannelRequest")
	proto.RegisterType((*LockChannelResponse)(nil), "protocol.LockChannelResponse")
	proto.RegisterType((*UnlockChannelRequest)(nil), "protocol.UnlockChannelRequest")
	proto.RegisterType((*UnlockChannelResponse)(nil), "protocol.UnlockChannelResponse")
	proto.RegisterType((*GetCheckpointRequest)(nil), "protocol.GetCheckpointRequest")
	proto.RegisterType((*GetCheckpointResponse)(nil), "protocol.GetCheckpointResponse")
	proto.RegisterType((*CheckpointRequest)(nil), "protocol.CheckpointRequest")
	proto.RegisterType((*CheckpointResponse)(nil), "protocol.CheckpointResponse")
	proto.RegisterType((*ReadRecordsRequest)(nil), "protocol.ReadRecordsRequest")
	proto.RegisterType((*Record)(nil), "protocol.Record")
	proto.RegisterType((*ReadRecordsResponse)(nil), "protocol.ReadRecordsResponse")
	proto.RegisterType((*Token)(nil), "protocol.Token")
	proto.RegisterType((*TokenContent)(nil), "protocol.TokenContent")
	proto.RegisterType((*TokenContentV2)(nil), "protocol.TokenContentV2")
	proto.RegisterEnum("protocol.TunnelType", TunnelType_name, TunnelType_value)
	proto.RegisterEnum("protocol.ChannelStatus", ChannelStatus_name, ChannelStatus_value)
	proto.RegisterEnum("protocol.ActionType", ActionType_name, ActionType_value)
}

func init() { proto.RegisterFile("tunnelservice.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1036 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4b, 0x4f, 0x23, 0x47,
	0x10, 0xd6, 0x78, 0xfc, 0xa2, 0xfc, 0x1a, 0xb7, 0x6d, 0xf0, 0xd1, 0xe9, 0x6c, 0x84, 0x59, 0x29,
	0x1c, 0xc8, 0x61, 0xb3, 0x8a, 0x72, 0x20, 0xb6, 0xc5, 0x22, 0x11, 0x20, 0xc6, 0x24, 0x97, 0xac,
	0xac, 0x66, 0x5c, 0xc0, 0x88, 0x71, 0xf7, 0x64, 0xa6, 0xbd, 0xbb, 0x24, 0x3f, 0x2c, 0x7f, 0x2f,
	0xea, 0xc7, 0xe0, 0xf1, 0x00, 0xab, 0x6c, 0x76, 0x73, 0xb2, 0xba, 0xa6, 0xea, 0xfb, 0xaa, 0xbe,
	0xaa, 0x2e, 0x37, 0x74, 0xe4, 0x8a, 0x73, 0x0c, 0x13, 0x8c, 0xdf, 0x05, 0x3e, 0xee, 0x47, 0xb1,
	0x90, 0x82, 0x54, 0xf5, 0x8f, 0x2f, 0x42, 0xfa, 0x1a, 0x4a, 0x93, 0x38, 0x16, 0x31, 0xa9, 0x43,
	0xd1, 0x17, 0x0b, 0xec, 0x3b, 0x83, 0xc2, 0x70, 0x8b, 0xb4, 0xa0, 0xb2, 0xc4, 0x24, 0x61, 0x37,
	0xd8, 0x2f, 0x0c, 0x9c, 0xe1, 0x16, 0x69, 0xc3, 0x96, 0x01, 0x9a, 0x07, 0x8b, 0xbe, 0xab, 0x4c,
	0xf4, 0x77, 0x28, 0xcf, 0xb4, 0x89, 0x10, 0x00, 0xc9, 0xae, 0x42, 0x9c, 0x73, 0xb6, 0x4c, 0x11,
	0x3a, 0x50, 0xb3, 0x01, 0xda, 0xe8, 0x6a, 0xe3, 0xde, 0x83, 0x51, 0xde, 0x47, 0xd8, 0x2f, 0x0e,
	0x0a, 0xc3, 0xe6, 0x41, 0x77, 0x3f, 0xcd, 0x66, 0xdf, 0xe0, 0xcd, 0xee, 0x23, 0xa4, 0xaf, 0xa0,
	0x33, 0x8a, 0x91, 0x49, 0x34, 0xb6, 0x29, 0xfe, 0xb1, 0xc2, 0x44, 0x92, 0x01, 0x94, 0x0d, 0x82,
	0xa6, 0xa9, 0x1d, 0x78, 0xf9, 0x60, 0xba, 0x07, 0xdd, 0xcd, 0xc0, 0x24, 0x12, 0x3c, 0xc1, 0xcd,
	0x0a, 0x74, 0x8e, 0xf4, 0x17, 0xe8, 0x8c, 0x31, 0xc4, 0x3c, 0xc7, 0xbf, 0x28, 0xa7, 0xa0, 0x8d,
	0x4f, 0x88, 0xb2, 0x0d, 0xdd, 0x4d, 0x48, 0xc3, 0x4e, 0x77, 0xa1, 0x7d, 0x12, 0x24, 0xf2, 0xe3,
	0x44, 0x0a, 0xe0, 0x6f, 0x07, 0xc0, 0x78, 0x1d, 0xf3, 0x6b, 0xf1, 0x44, 0xd6, 0x99, 0x54, 0xb4,
	0x88, 0x26, 0x95, 0x4d, 0x28, 0xa3, 0x76, 0x0f, 0x1a, 0x01, 0x4f, 0x24, 0xe3, 0xbe, 0x35, 0x17,
	0xd3, 0xac, 0x13, 0x19, 0x23, 0x5b, 0x2a, 0xc8, 0x92, 0x36, 0x35, 0xa0, 0x94, 0x48, 0xd5, 0xec,
	0x72, 0xda, 0x7d, 0xfc, 0x10, 0x05, 0x31, 0x2e, 0xfa, 0x95, 0x81, 0x33, 0xac, 0xe6, 0xab, 0xaf,
	0xea, 0x91, 0x68, 0x42, 0x39, 0x5a, 0x5d, 0x85, 0x81, 0xdf, 0xdf, 0x52, 0x4e, 0xf4, 0x07, 0x20,
	0xd9, 0x12, 0xad, 0xec, 0xdf, 0x40, 0xc5, 0x4e, 0x60, 0xdf, 0x19, 0xb8, 0xc3, 0xda, 0xe3, 0x76,
	0xab, 0x3a, 0xe9, 0x05, 0xf4, 0xc6, 0x98, 0xf8, 0x71, 0x70, 0xf5, 0x05, 0x9b, 0xf1, 0x1e, 0x6a,
	0xa3, 0x5b, 0xf6, 0xa0, 0x25, 0x01, 0xf0, 0xcd, 0x71, 0x2d, 0x66, 0x17, 0xea, 0xa9, 0xcd, 0xaa,
	0xa9, 0x4a, 0xdb, 0x86, 0x66, 0x6a, 0x4d, 0x24, 0x93, 0xab, 0xc4, 0x00, 0x2a, 0x0e, 0x3f, 0x0c,
	0x90, 0x4b, 0x05, 0x50, 0xd4, 0xa6, 0x0e, 0xd4, 0x52, 0xd7, 0x38, 0x12, 0xfd, 0xd2, 0xc0, 0x19,
	0xba, 0xf4, 0x2f, 0xd8, 0xce, 0x57, 0x63, 0xe5, 0x78, 0x91, 0x9b, 0xdf, 0x27, 0xd5, 0x20, 0xbb,
	0x50, 0xb5, 0xa0, 0x49, 0xbf, 0xa0, 0x55, 0xeb, 0xad, 0xfd, 0x72, 0x25, 0xd9, 0xa2, 0x15, 0xb9,
	0xab, 0xc9, 0x29, 0x34, 0x8e, 0x50, 0x4e, 0x23, 0x91, 0x4a, 0x98, 0x9b, 0x21, 0xa5, 0xcc, 0x8f,
	0xd0, 0x4c, 0x7d, 0xd6, 0xd7, 0x23, 0x8e, 0xc4, 0x3c, 0xe0, 0xd7, 0x22, 0xd1, 0x4e, 0x75, 0xd2,
	0x07, 0x6f, 0x0d, 0x6e, 0xbf, 0x28, 0x7d, 0xea, 0xf4, 0x3b, 0xa8, 0x8f, 0xb4, 0x0e, 0x23, 0xc1,
	0xaf, 0x83, 0x1b, 0x35, 0x30, 0x32, 0x58, 0xa2, 0x58, 0x49, 0x1d, 0xea, 0x6a, 0xa9, 0x8d, 0x50,
	0x92, 0xdd, 0x18, 0x51, 0xe9, 0x14, 0x9a, 0x23, 0xc1, 0x39, 0xfa, 0xf2, 0x99, 0xc4, 0x54, 0x3f,
	0xbe, 0x85, 0x86, 0x0d, 0xf4, 0x35, 0xb4, 0x8e, 0xad, 0x1d, 0x6c, 0x67, 0xca, 0xcf, 0x10, 0xd3,
	0x17, 0xd0, 0x7a, 0xc0, 0x5c, 0x17, 0xb2, 0xee, 0x91, 0xb9, 0xe7, 0x37, 0x50, 0xb1, 0xa2, 0x3d,
	0x39, 0x03, 0x2d, 0xa8, 0xbc, 0xc3, 0x38, 0x09, 0x04, 0xd7, 0xa3, 0xe4, 0x92, 0x5d, 0x28, 0x3f,
	0xb4, 0x5d, 0x6d, 0xa8, 0x9d, 0x47, 0xe2, 0x5f, 0xe8, 0xcf, 0xea, 0x0a, 0x2c, 0x50, 0xb2, 0x20,
	0xd4, 0xc3, 0x50, 0xa7, 0x6f, 0xc1, 0x7b, 0x83, 0x2c, 0x96, 0x57, 0xc8, 0x3e, 0x56, 0xe4, 0x46,
	0x8a, 0x66, 0x7a, 0xbf, 0xce, 0x74, 0xdc, 0xd5, 0x1d, 0x6f, 0x3f, 0x22, 0xa5, 0xdf, 0x43, 0x3b,
	0x03, 0x6f, 0xeb, 0xcd, 0x46, 0x3a, 0xcf, 0x45, 0xbe, 0x82, 0xd6, 0xc5, 0xed, 0x4a, 0x2e, 0xc4,
	0x7b, 0xfe, 0x49, 0x79, 0x51, 0x02, 0xde, 0x3a, 0xd0, 0xee, 0xb2, 0x08, 0xc8, 0x89, 0xf0, 0xef,
	0x2c, 0xf6, 0xa7, 0xd5, 0xb9, 0xa9, 0xbf, 0x9b, 0xea, 0x1f, 0x0a, 0xff, 0xce, 0xdc, 0x29, 0x6b,
	0x48, 0xc7, 0x49, 0xed, 0x27, 0x97, 0xf6, 0xa0, 0xb3, 0xc1, 0x68, 0x13, 0x61, 0xd0, 0xbd, 0xe4,
	0xe1, 0xff, 0x99, 0x0a, 0xdd, 0x81, 0x5e, 0x8e, 0xc2, 0x72, 0x9f, 0x43, 0xf7, 0x08, 0xe5, 0xe8,
	0x16, 0xfd, 0xbb, 0x48, 0x04, 0x5c, 0x7e, 0x36, 0x37, 0x1d, 0x43, 0x2f, 0x87, 0x68, 0x3b, 0xac,
	0x9d, 0x53, 0xab, 0xc5, 0xdc, 0x81, 0x56, 0xa2, 0x18, 0xf5, 0x6e, 0x5f, 0x2d, 0xaf, 0x30, 0x36,
	0xb3, 0x4b, 0xff, 0x84, 0xf6, 0x17, 0x4c, 0x2a, 0xc7, 0x5d, 0x7c, 0x8e, 0xdb, 0xb4, 0xa9, 0x0b,
	0xe4, 0x71, 0xfa, 0xf4, 0x2d, 0x90, 0x29, 0xb2, 0xc5, 0x14, 0x7d, 0x11, 0x2f, 0x92, 0xcf, 0x4f,
	0xa9, 0x01, 0x25, 0x29, 0xee, 0x90, 0xdb, 0x0e, 0x8d, 0xa0, 0x6c, 0xa0, 0xd5, 0xeb, 0x82, 0xf9,
	0x32, 0x10, 0xdc, 0xac, 0x72, 0x27, 0xff, 0xba, 0x38, 0xd4, 0x1f, 0xd5, 0xeb, 0x42, 0x5d, 0xdc,
	0x58, 0x07, 0x69, 0x9e, 0x3a, 0x3d, 0x81, 0xce, 0x46, 0x8e, 0x56, 0xf9, 0xaf, 0xa0, 0x62, 0xdc,
	0xd2, 0xab, 0x95, 0x79, 0x6e, 0x58, 0x52, 0x02, 0xc0, 0xf1, 0x83, 0x9c, 0x9b, 0x94, 0xcc, 0xa5,
	0xd9, 0x83, 0xd2, 0x4c, 0x1d, 0xb3, 0x9b, 0xc5, 0xd1, 0x9b, 0xa5, 0x05, 0x15, 0x5f, 0x70, 0x89,
	0x5c, 0x5a, 0xe2, 0x37, 0x50, 0xd7, 0xae, 0x23, 0x63, 0x55, 0x7f, 0x27, 0x51, 0x1c, 0x2c, 0x59,
	0x7c, 0x3f, 0xbf, 0xc3, 0x7b, 0xbb, 0x88, 0x3d, 0xa8, 0x06, 0x12, 0x63, 0x26, 0x45, 0x9c, 0x79,
	0x8e, 0x05, 0x4b, 0x4c, 0x24, 0x5b, 0x46, 0x76, 0xed, 0xcf, 0xa1, 0x99, 0x45, 0xfa, 0xf5, 0xe0,
	0xbf, 0x63, 0xe9, 0x3f, 0x58, 0x21, 0x59, 0x38, 0xf7, 0xc5, 0x4a, 0xb7, 0xdd, 0x19, 0xba, 0x2f,
	0x5f, 0xa7, 0x0f, 0x13, 0xad, 0x60, 0x1d, 0xaa, 0x3f, 0xb1, 0x04, 0xc7, 0x4c, 0x32, 0xcf, 0x21,
	0x00, 0xe5, 0x0b, 0xfd, 0xa6, 0xf0, 0x0a, 0xa4, 0x0d, 0x0d, 0xf5, 0xe5, 0x90, 0x2f, 0xac, 0xc9,
	0x7d, 0x79, 0x08, 0x8d, 0xcd, 0xc5, 0x59, 0x85, 0xe2, 0xd9, 0xf9, 0xe4, 0xd4, 0x73, 0x48, 0x0d,
	0x2a, 0xa3, 0x93, 0xb3, 0x8b, 0xe3, 0xd3, 0x23, 0xaf, 0x40, 0xb6, 0xa0, 0xa4, 0x0e, 0x13, 0xcf,
	0x25, 0x4d, 0x80, 0xd9, 0x64, 0xfa, 0xf3, 0xf1, 0xe9, 0xe1, 0x6c, 0x32, 0xf6, 0x8a, 0x8a, 0x3d,
	0xd3, 0xbf, 0x1a, 0x54, 0xce, 0x2f, 0x67, 0xf3, 0xe9, 0xd9, 0x6f, 0x9e, 0xa3, 0x5c, 0x2f, 0xcf,
	0xc7, 0x87, 0xb3, 0x89, 0x3e, 0x17, 0xd4, 0x79, 0x3c, 0x39, 0x99, 0xd8, 0xb3, 0xfb, 0x4f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x42, 0x42, 0x63, 0x69, 0x03, 0x0b, 0x00, 0x00,
}
