package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayFileShare invokes the sgw.CreateGatewayFileShare API synchronously
func (client *Client) CreateGatewayFileShare(request *CreateGatewayFileShareRequest) (response *CreateGatewayFileShareResponse, err error) {
	response = CreateCreateGatewayFileShareResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayFileShareWithChan invokes the sgw.CreateGatewayFileShare API asynchronously
func (client *Client) CreateGatewayFileShareWithChan(request *CreateGatewayFileShareRequest) (<-chan *CreateGatewayFileShareResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayFileShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayFileShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayFileShareWithCallback invokes the sgw.CreateGatewayFileShare API asynchronously
func (client *Client) CreateGatewayFileShareWithCallback(request *CreateGatewayFileShareRequest, callback func(response *CreateGatewayFileShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayFileShareResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayFileShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayFileShareRequest is the request struct for api CreateGatewayFileShare
type CreateGatewayFileShareRequest struct {
	*requests.RpcRequest
	InPlace                requests.Boolean `position:"Query" name:"InPlace"`
	OssEndpoint            string           `position:"Query" name:"OssEndpoint"`
	ReadWriteClientList    string           `position:"Query" name:"ReadWriteClientList"`
	BypassCacheRead        requests.Boolean `position:"Query" name:"BypassCacheRead"`
	BackendLimit           requests.Integer `position:"Query" name:"BackendLimit"`
	Squash                 string           `position:"Query" name:"Squash"`
	ReadOnlyClientList     string           `position:"Query" name:"ReadOnlyClientList"`
	SecurityToken          string           `position:"Query" name:"SecurityToken"`
	KmsRotatePeriod        requests.Integer `position:"Query" name:"KmsRotatePeriod"`
	RemoteSyncDownload     requests.Boolean `position:"Query" name:"RemoteSyncDownload"`
	ShareProtocol          string           `position:"Query" name:"ShareProtocol"`
	NfsV4Optimization      requests.Boolean `position:"Query" name:"NfsV4Optimization"`
	AccessBasedEnumeration requests.Boolean `position:"Query" name:"AccessBasedEnumeration"`
	GatewayId              string           `position:"Query" name:"GatewayId"`
	SupportArchive         requests.Boolean `position:"Query" name:"SupportArchive"`
	CacheMode              string           `position:"Query" name:"CacheMode"`
	LocalFilePath          string           `position:"Query" name:"LocalFilePath"`
	PartialSyncPaths       string           `position:"Query" name:"PartialSyncPaths"`
	DownloadLimit          requests.Integer `position:"Query" name:"DownloadLimit"`
	ReadOnlyUserList       string           `position:"Query" name:"ReadOnlyUserList"`
	FastReclaim            requests.Boolean `position:"Query" name:"FastReclaim"`
	WindowsAcl             requests.Boolean `position:"Query" name:"WindowsAcl"`
	Name                   string           `position:"Query" name:"Name"`
	OssBucketName          string           `position:"Query" name:"OssBucketName"`
	TransferAcceleration   requests.Boolean `position:"Query" name:"TransferAcceleration"`
	ClientSideCmk          string           `position:"Query" name:"ClientSideCmk"`
	PathPrefix             string           `position:"Query" name:"PathPrefix"`
	Browsable              requests.Boolean `position:"Query" name:"Browsable"`
	ReadWriteUserList      string           `position:"Query" name:"ReadWriteUserList"`
	PollingInterval        requests.Integer `position:"Query" name:"PollingInterval"`
	Enabled                requests.Boolean `position:"Query" name:"Enabled"`
	ServerSideAlgorithm    string           `position:"Query" name:"ServerSideAlgorithm"`
	ServerSideCmk          string           `position:"Query" name:"ServerSideCmk"`
	ServerSideEncryption   requests.Boolean `position:"Query" name:"ServerSideEncryption"`
	IgnoreDelete           requests.Boolean `position:"Query" name:"IgnoreDelete"`
	LagPeriod              requests.Integer `position:"Query" name:"LagPeriod"`
	DirectIO               requests.Boolean `position:"Query" name:"DirectIO"`
	ClientSideEncryption   requests.Boolean `position:"Query" name:"ClientSideEncryption"`
	OssBucketSsl           requests.Boolean `position:"Query" name:"OssBucketSsl"`
	RemoteSync             requests.Boolean `position:"Query" name:"RemoteSync"`
	FrontendLimit          requests.Integer `position:"Query" name:"FrontendLimit"`
}

// CreateGatewayFileShareResponse is the response struct for api CreateGatewayFileShare
type CreateGatewayFileShareResponse struct {
	*responses.BaseResponse
	TaskId    string `json:"TaskId" xml:"TaskId"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateGatewayFileShareRequest creates a request to invoke CreateGatewayFileShare API
func CreateCreateGatewayFileShareRequest() (request *CreateGatewayFileShareRequest) {
	request = &CreateGatewayFileShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateGatewayFileShare", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayFileShareResponse creates a response to parse from CreateGatewayFileShare response
func CreateCreateGatewayFileShareResponse() (response *CreateGatewayFileShareResponse) {
	response = &CreateGatewayFileShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
