package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserCount invokes the sddp.DescribeUserCount API synchronously
func (client *Client) DescribeUserCount(request *DescribeUserCountRequest) (response *DescribeUserCountResponse, err error) {
	response = CreateDescribeUserCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserCountWithChan invokes the sddp.DescribeUserCount API asynchronously
func (client *Client) DescribeUserCountWithChan(request *DescribeUserCountRequest) (<-chan *DescribeUserCountResponse, <-chan error) {
	responseChan := make(chan *DescribeUserCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserCountWithCallback invokes the sddp.DescribeUserCount API asynchronously
func (client *Client) DescribeUserCountWithCallback(request *DescribeUserCountRequest, callback func(response *DescribeUserCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserCountRequest is the request struct for api DescribeUserCount
type DescribeUserCountRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeUserCountResponse is the response struct for api DescribeUserCount
type DescribeUserCountResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	UserCount UserCount `json:"UserCount" xml:"UserCount"`
}

// CreateDescribeUserCountRequest creates a request to invoke DescribeUserCount API
func CreateDescribeUserCountRequest() (request *DescribeUserCountRequest) {
	request = &DescribeUserCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeUserCount", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUserCountResponse creates a response to parse from DescribeUserCount response
func CreateDescribeUserCountResponse() (response *DescribeUserCountResponse) {
	response = &DescribeUserCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
