package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableJob invokes the schedulerx2.DisableJob API synchronously
func (client *Client) DisableJob(request *DisableJobRequest) (response *DisableJobResponse, err error) {
	response = CreateDisableJobResponse()
	err = client.DoAction(request, response)
	return
}

// DisableJobWithChan invokes the schedulerx2.DisableJob API asynchronously
func (client *Client) DisableJobWithChan(request *DisableJobRequest) (<-chan *DisableJobResponse, <-chan error) {
	responseChan := make(chan *DisableJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableJobWithCallback invokes the schedulerx2.DisableJob API asynchronously
func (client *Client) DisableJobWithCallback(request *DisableJobRequest, callback func(response *DisableJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableJobResponse
		var err error
		defer close(result)
		response, err = client.DisableJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableJobRequest is the request struct for api DisableJob
type DisableJobRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Query" name:"NamespaceSource"`
	GroupId         string           `position:"Query" name:"GroupId"`
	JobId           requests.Integer `position:"Query" name:"JobId"`
	Namespace       string           `position:"Query" name:"Namespace"`
}

// DisableJobResponse is the response struct for api DisableJob
type DisableJobResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDisableJobRequest creates a request to invoke DisableJob API
func CreateDisableJobRequest() (request *DisableJobRequest) {
	request = &DisableJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "DisableJob", "", "")
	request.Method = requests.GET
	return
}

// CreateDisableJobResponse creates a response to parse from DisableJob response
func CreateDisableJobResponse() (response *DisableJobResponse) {
	response = &DisableJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
