package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEmptyNumberNoMoreCallsInfo invokes the outboundbot.GetEmptyNumberNoMoreCallsInfo API synchronously
func (client *Client) GetEmptyNumberNoMoreCallsInfo(request *GetEmptyNumberNoMoreCallsInfoRequest) (response *GetEmptyNumberNoMoreCallsInfoResponse, err error) {
	response = CreateGetEmptyNumberNoMoreCallsInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetEmptyNumberNoMoreCallsInfoWithChan invokes the outboundbot.GetEmptyNumberNoMoreCallsInfo API asynchronously
func (client *Client) GetEmptyNumberNoMoreCallsInfoWithChan(request *GetEmptyNumberNoMoreCallsInfoRequest) (<-chan *GetEmptyNumberNoMoreCallsInfoResponse, <-chan error) {
	responseChan := make(chan *GetEmptyNumberNoMoreCallsInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEmptyNumberNoMoreCallsInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEmptyNumberNoMoreCallsInfoWithCallback invokes the outboundbot.GetEmptyNumberNoMoreCallsInfo API asynchronously
func (client *Client) GetEmptyNumberNoMoreCallsInfoWithCallback(request *GetEmptyNumberNoMoreCallsInfoRequest, callback func(response *GetEmptyNumberNoMoreCallsInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEmptyNumberNoMoreCallsInfoResponse
		var err error
		defer close(result)
		response, err = client.GetEmptyNumberNoMoreCallsInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEmptyNumberNoMoreCallsInfoRequest is the request struct for api GetEmptyNumberNoMoreCallsInfo
type GetEmptyNumberNoMoreCallsInfoRequest struct {
	*requests.RpcRequest
	StrategyLevel requests.Integer `position:"Query" name:"StrategyLevel"`
	EntryId       string           `position:"Query" name:"EntryId"`
}

// GetEmptyNumberNoMoreCallsInfoResponse is the response struct for api GetEmptyNumberNoMoreCallsInfo
type GetEmptyNumberNoMoreCallsInfoResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	Success                bool   `json:"Success" xml:"Success"`
	Code                   string `json:"Code" xml:"Code"`
	Message                string `json:"Message" xml:"Message"`
	HttpStatusCode         int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	EmptyNumberNoMoreCalls bool   `json:"EmptyNumberNoMoreCalls" xml:"EmptyNumberNoMoreCalls"`
}

// CreateGetEmptyNumberNoMoreCallsInfoRequest creates a request to invoke GetEmptyNumberNoMoreCallsInfo API
func CreateGetEmptyNumberNoMoreCallsInfoRequest() (request *GetEmptyNumberNoMoreCallsInfoRequest) {
	request = &GetEmptyNumberNoMoreCallsInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GetEmptyNumberNoMoreCallsInfo", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEmptyNumberNoMoreCallsInfoResponse creates a response to parse from GetEmptyNumberNoMoreCallsInfo response
func CreateGetEmptyNumberNoMoreCallsInfoResponse() (response *GetEmptyNumberNoMoreCallsInfoResponse) {
	response = &GetEmptyNumberNoMoreCallsInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
