package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConcurrentConversationQuota invokes the outboundbot.GetConcurrentConversationQuota API synchronously
func (client *Client) GetConcurrentConversationQuota(request *GetConcurrentConversationQuotaRequest) (response *GetConcurrentConversationQuotaResponse, err error) {
	response = CreateGetConcurrentConversationQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// GetConcurrentConversationQuotaWithChan invokes the outboundbot.GetConcurrentConversationQuota API asynchronously
func (client *Client) GetConcurrentConversationQuotaWithChan(request *GetConcurrentConversationQuotaRequest) (<-chan *GetConcurrentConversationQuotaResponse, <-chan error) {
	responseChan := make(chan *GetConcurrentConversationQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConcurrentConversationQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConcurrentConversationQuotaWithCallback invokes the outboundbot.GetConcurrentConversationQuota API asynchronously
func (client *Client) GetConcurrentConversationQuotaWithCallback(request *GetConcurrentConversationQuotaRequest, callback func(response *GetConcurrentConversationQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConcurrentConversationQuotaResponse
		var err error
		defer close(result)
		response, err = client.GetConcurrentConversationQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConcurrentConversationQuotaRequest is the request struct for api GetConcurrentConversationQuota
type GetConcurrentConversationQuotaRequest struct {
	*requests.RpcRequest
}

// GetConcurrentConversationQuotaResponse is the response struct for api GetConcurrentConversationQuota
type GetConcurrentConversationQuotaResponse struct {
	*responses.BaseResponse
	Code                string `json:"Code" xml:"Code"`
	HttpStatusCode      int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	MaxConcurrent       int    `json:"MaxConcurrent" xml:"MaxConcurrent"`
	Message             string `json:"Message" xml:"Message"`
	RemainingConcurrent int    `json:"RemainingConcurrent" xml:"RemainingConcurrent"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
	Success             bool   `json:"Success" xml:"Success"`
}

// CreateGetConcurrentConversationQuotaRequest creates a request to invoke GetConcurrentConversationQuota API
func CreateGetConcurrentConversationQuotaRequest() (request *GetConcurrentConversationQuotaRequest) {
	request = &GetConcurrentConversationQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GetConcurrentConversationQuota", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetConcurrentConversationQuotaResponse creates a response to parse from GetConcurrentConversationQuota response
func CreateGetConcurrentConversationQuotaResponse() (response *GetConcurrentConversationQuotaResponse) {
	response = &GetConcurrentConversationQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
