package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEdgeDriverVersion invokes the iot.QueryEdgeDriverVersion API synchronously
func (client *Client) QueryEdgeDriverVersion(request *QueryEdgeDriverVersionRequest) (response *QueryEdgeDriverVersionResponse, err error) {
	response = CreateQueryEdgeDriverVersionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEdgeDriverVersionWithChan invokes the iot.QueryEdgeDriverVersion API asynchronously
func (client *Client) QueryEdgeDriverVersionWithChan(request *QueryEdgeDriverVersionRequest) (<-chan *QueryEdgeDriverVersionResponse, <-chan error) {
	responseChan := make(chan *QueryEdgeDriverVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEdgeDriverVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEdgeDriverVersionWithCallback invokes the iot.QueryEdgeDriverVersion API asynchronously
func (client *Client) QueryEdgeDriverVersionWithCallback(request *QueryEdgeDriverVersionRequest, callback func(response *QueryEdgeDriverVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEdgeDriverVersionResponse
		var err error
		defer close(result)
		response, err = client.QueryEdgeDriverVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEdgeDriverVersionRequest is the request struct for api QueryEdgeDriverVersion
type QueryEdgeDriverVersionRequest struct {
	*requests.RpcRequest
	VersionState  requests.Integer `position:"Query" name:"VersionState"`
	DriverId      string           `position:"Query" name:"DriverId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	DriverVersion string           `position:"Query" name:"DriverVersion"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QueryEdgeDriverVersionResponse is the response struct for api QueryEdgeDriverVersion
type QueryEdgeDriverVersionResponse struct {
	*responses.BaseResponse
	RequestId    string                       `json:"RequestId" xml:"RequestId"`
	Success      bool                         `json:"Success" xml:"Success"`
	Code         string                       `json:"Code" xml:"Code"`
	ErrorMessage string                       `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryEdgeDriverVersion `json:"Data" xml:"Data"`
}

// CreateQueryEdgeDriverVersionRequest creates a request to invoke QueryEdgeDriverVersion API
func CreateQueryEdgeDriverVersionRequest() (request *QueryEdgeDriverVersionRequest) {
	request = &QueryEdgeDriverVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryEdgeDriverVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEdgeDriverVersionResponse creates a response to parse from QueryEdgeDriverVersion response
func CreateQueryEdgeDriverVersionResponse() (response *QueryEdgeDriverVersionResponse) {
	response = &QueryEdgeDriverVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
