package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VideoSyncScan invokes the green.VideoSyncScan API synchronously
func (client *Client) VideoSyncScan(request *VideoSyncScanRequest) (response *VideoSyncScanResponse, err error) {
	response = CreateVideoSyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// VideoSyncScanWithChan invokes the green.VideoSyncScan API asynchronously
func (client *Client) VideoSyncScanWithChan(request *VideoSyncScanRequest) (<-chan *VideoSyncScanResponse, <-chan error) {
	responseChan := make(chan *VideoSyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VideoSyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VideoSyncScanWithCallback invokes the green.VideoSyncScan API asynchronously
func (client *Client) VideoSyncScanWithCallback(request *VideoSyncScanRequest, callback func(response *VideoSyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VideoSyncScanResponse
		var err error
		defer close(result)
		response, err = client.VideoSyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VideoSyncScanRequest is the request struct for api VideoSyncScan
type VideoSyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VideoSyncScanResponse is the response struct for api VideoSyncScan
type VideoSyncScanResponse struct {
	*responses.BaseResponse
}

// CreateVideoSyncScanRequest creates a request to invoke VideoSyncScan API
func CreateVideoSyncScanRequest() (request *VideoSyncScanRequest) {
	request = &VideoSyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VideoSyncScan", "/green/video/syncscan", "", "")
	request.Method = requests.POST
	return
}

// CreateVideoSyncScanResponse creates a response to parse from VideoSyncScan response
func CreateVideoSyncScanResponse() (response *VideoSyncScanResponse) {
	response = &VideoSyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
