package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyResourceQueue invokes the emr.ModifyResourceQueue API synchronously
func (client *Client) ModifyResourceQueue(request *ModifyResourceQueueRequest) (response *ModifyResourceQueueResponse, err error) {
	response = CreateModifyResourceQueueResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyResourceQueueWithChan invokes the emr.ModifyResourceQueue API asynchronously
func (client *Client) ModifyResourceQueueWithChan(request *ModifyResourceQueueRequest) (<-chan *ModifyResourceQueueResponse, <-chan error) {
	responseChan := make(chan *ModifyResourceQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyResourceQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyResourceQueueWithCallback invokes the emr.ModifyResourceQueue API asynchronously
func (client *Client) ModifyResourceQueueWithCallback(request *ModifyResourceQueueRequest, callback func(response *ModifyResourceQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyResourceQueueResponse
		var err error
		defer close(result)
		response, err = client.ModifyResourceQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyResourceQueueRequest is the request struct for api ModifyResourceQueue
type ModifyResourceQueueRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	QualifiedName   string                       `position:"Query" name:"QualifiedName"`
	ResourcePoolId  requests.Integer             `position:"Query" name:"ResourcePoolId"`
	ClusterId       string                       `position:"Query" name:"ClusterId"`
	Leaf            requests.Boolean             `position:"Query" name:"Leaf"`
	ParentQueueId   requests.Integer             `position:"Query" name:"ParentQueueId"`
	Name            string                       `position:"Query" name:"Name"`
	Id              string                       `position:"Query" name:"Id"`
	Config          *[]ModifyResourceQueueConfig `position:"Query" name:"Config"  type:"Repeated"`
}

// ModifyResourceQueueConfig is a repeated param struct in ModifyResourceQueueRequest
type ModifyResourceQueueConfig struct {
	ConfigKey   string `name:"ConfigKey"`
	Note        string `name:"Note"`
	ConfigValue string `name:"ConfigValue"`
	Id          string `name:"Id"`
	Category    string `name:"Category"`
}

// ModifyResourceQueueResponse is the response struct for api ModifyResourceQueue
type ModifyResourceQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyResourceQueueRequest creates a request to invoke ModifyResourceQueue API
func CreateModifyResourceQueueRequest() (request *ModifyResourceQueueRequest) {
	request = &ModifyResourceQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyResourceQueue", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyResourceQueueResponse creates a response to parse from ModifyResourceQueue response
func CreateModifyResourceQueueResponse() (response *ModifyResourceQueueResponse) {
	response = &ModifyResourceQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
