package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOperationLogs invokes the edas.ListOperationLogs API synchronously
func (client *Client) ListOperationLogs(request *ListOperationLogsRequest) (response *ListOperationLogsResponse, err error) {
	response = CreateListOperationLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListOperationLogsWithChan invokes the edas.ListOperationLogs API asynchronously
func (client *Client) ListOperationLogsWithChan(request *ListOperationLogsRequest) (<-chan *ListOperationLogsResponse, <-chan error) {
	responseChan := make(chan *ListOperationLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOperationLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOperationLogsWithCallback invokes the edas.ListOperationLogs API asynchronously
func (client *Client) ListOperationLogsWithCallback(request *ListOperationLogsRequest, callback func(response *ListOperationLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOperationLogsResponse
		var err error
		defer close(result)
		response, err = client.ListOperationLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOperationLogsRequest is the request struct for api ListOperationLogs
type ListOperationLogsRequest struct {
	*requests.RoaRequest
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	BeginTime   requests.Integer `position:"Query" name:"BeginTime"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	UserId      string           `position:"Query" name:"UserId"`
}

// ListOperationLogsResponse is the response struct for api ListOperationLogs
type ListOperationLogsResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Code        int    `json:"Code" xml:"Code"`
	Message     string `json:"Message" xml:"Message"`
	TotalSize   int    `json:"TotalSize" xml:"TotalSize"`
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	LogList     []Log  `json:"LogList" xml:"LogList"`
}

// CreateListOperationLogsRequest creates a request to invoke ListOperationLogs API
func CreateListOperationLogsRequest() (request *ListOperationLogsRequest) {
	request = &ListOperationLogsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListOperationLogs", "/pop/v5/operationlog/log_list", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListOperationLogsResponse creates a response to parse from ListOperationLogs response
func CreateListOperationLogsResponse() (response *ListOperationLogsResponse) {
	response = &ListOperationLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
