package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnRefreshTaskById invokes the dcdn.DescribeDcdnRefreshTaskById API synchronously
func (client *Client) DescribeDcdnRefreshTaskById(request *DescribeDcdnRefreshTaskByIdRequest) (response *DescribeDcdnRefreshTaskByIdResponse, err error) {
	response = CreateDescribeDcdnRefreshTaskByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnRefreshTaskByIdWithChan invokes the dcdn.DescribeDcdnRefreshTaskById API asynchronously
func (client *Client) DescribeDcdnRefreshTaskByIdWithChan(request *DescribeDcdnRefreshTaskByIdRequest) (<-chan *DescribeDcdnRefreshTaskByIdResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnRefreshTaskByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnRefreshTaskById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnRefreshTaskByIdWithCallback invokes the dcdn.DescribeDcdnRefreshTaskById API asynchronously
func (client *Client) DescribeDcdnRefreshTaskByIdWithCallback(request *DescribeDcdnRefreshTaskByIdRequest, callback func(response *DescribeDcdnRefreshTaskByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnRefreshTaskByIdResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnRefreshTaskById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnRefreshTaskByIdRequest is the request struct for api DescribeDcdnRefreshTaskById
type DescribeDcdnRefreshTaskByIdRequest struct {
	*requests.RpcRequest
	TaskId  string           `position:"Query" name:"TaskId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnRefreshTaskByIdResponse is the response struct for api DescribeDcdnRefreshTaskById
type DescribeDcdnRefreshTaskByIdResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	TotalCount int64     `json:"TotalCount" xml:"TotalCount"`
	Tasks      []CDNTask `json:"Tasks" xml:"Tasks"`
}

// CreateDescribeDcdnRefreshTaskByIdRequest creates a request to invoke DescribeDcdnRefreshTaskById API
func CreateDescribeDcdnRefreshTaskByIdRequest() (request *DescribeDcdnRefreshTaskByIdRequest) {
	request = &DescribeDcdnRefreshTaskByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnRefreshTaskById", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnRefreshTaskByIdResponse creates a response to parse from DescribeDcdnRefreshTaskById response
func CreateDescribeDcdnRefreshTaskByIdResponse() (response *DescribeDcdnRefreshTaskByIdResponse) {
	response = &DescribeDcdnRefreshTaskByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
