package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSSLCertificateList invokes the cas.DescribeSSLCertificateList API synchronously
func (client *Client) DescribeSSLCertificateList(request *DescribeSSLCertificateListRequest) (response *DescribeSSLCertificateListResponse, err error) {
	response = CreateDescribeSSLCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSSLCertificateListWithChan invokes the cas.DescribeSSLCertificateList API asynchronously
func (client *Client) DescribeSSLCertificateListWithChan(request *DescribeSSLCertificateListRequest) (<-chan *DescribeSSLCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeSSLCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSSLCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSSLCertificateListWithCallback invokes the cas.DescribeSSLCertificateList API asynchronously
func (client *Client) DescribeSSLCertificateListWithCallback(request *DescribeSSLCertificateListRequest, callback func(response *DescribeSSLCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSSLCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSSLCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSSLCertificateListRequest is the request struct for api DescribeSSLCertificateList
type DescribeSSLCertificateListRequest struct {
	*requests.RpcRequest
	ShowSize    requests.Integer `position:"Query" name:"ShowSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	SearchValue string           `position:"Query" name:"SearchValue"`
}

// DescribeSSLCertificateListResponse is the response struct for api DescribeSSLCertificateList
type DescribeSSLCertificateListResponse struct {
	*responses.BaseResponse
	RequestId    string            `json:"RequestId" xml:"RequestId"`
	TotalCount   int               `json:"TotalCount" xml:"TotalCount"`
	ShowSize     int               `json:"ShowSize" xml:"ShowSize"`
	CurrentPage  int               `json:"CurrentPage" xml:"CurrentPage"`
	PageCount    int               `json:"PageCount" xml:"PageCount"`
	CertMetaList []CertificateInfo `json:"CertMetaList" xml:"CertMetaList"`
}

// CreateDescribeSSLCertificateListRequest creates a request to invoke DescribeSSLCertificateList API
func CreateDescribeSSLCertificateListRequest() (request *DescribeSSLCertificateListRequest) {
	request = &DescribeSSLCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "DescribeSSLCertificateList", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSSLCertificateListResponse creates a response to parse from DescribeSSLCertificateList response
func CreateDescribeSSLCertificateListResponse() (response *DescribeSSLCertificateListResponse) {
	response = &DescribeSSLCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
