﻿using System;
using System.Diagnostics;
using Cake.Core.Configuration;
using Cake.Core.Diagnostics;
using Cake.Core.IO;
using Cake.Core.Tooling;
using Cake.Testing;
using NSubstitute;

namespace Cake.Core.Tests.Fixtures
{
    public sealed class ProcessRunnerFixture
    {
        public FakeFileSystem FileSystem { get; set; }
        public FakeEnvironment Environment { get; set; }
        public ICakeLog Log { get; set; }
        public IToolLocator Tools { get; set; }
        public ICakeConfiguration Configuration { get; set; }
        public FilePath ProcessFilePath { get; set; }
        public ProcessSettings ProcessSettings { get; set; }
        public IFile MonoFile { get; }

        public ProcessRunnerFixture(bool windows = false)
        {
            var environment = windows
                ? FakeEnvironment.CreateWindowsEnvironment()
                : FakeEnvironment.CreateUnixEnvironment();

            environment.WorkingDirectory = "/Working";

            Environment = environment;
            FileSystem = new FakeFileSystem(Environment);
            Log = Substitute.For<ICakeLog>();
            Tools = Substitute.For<IToolLocator>();
            Configuration = Substitute.For<ICakeConfiguration>();
            ProcessFilePath = "/Program Files/Cake.exe";
            ProcessSettings = new ProcessSettings();

            FileSystem.CreateDirectory("/Working");
            FileSystem.CreateDirectory("/Program Files");
            FileSystem.CreateFile("/Program Files/Cake.exe", ClrAssemblyData);
            MonoFile = FileSystem.CreateFile("/Program Files/mono.exe", NonClrAssemblyData);

            Tools.Resolve("mono").Returns(file => MonoFile.Exists ? MonoFile.Path : null);
        }

        public void GivenIsCoreClr()
        {
            Environment.SetIsCoreClr(true);
        }

        public void GivenConfigNoMonoCoersion()
        {
            Configuration.GetValue(Constants.Settings.NoMonoCoersion).Returns("true");
        }

        public void GivenMonoNotResolved()
        {
            MonoFile.Delete();
        }

        internal void GivenSecretArgument()
        {
            ProcessSettings.Arguments = new ProcessArgumentBuilder().AppendSecret("TopSecret");
        }

        public ProcessRunner CreateProcessRunner()
        {
            return new ProcessRunner(FileSystem, Environment, Log, Tools, Configuration);
        }

        public IProcess Start()
        {
            return CreateProcessRunner().Start(ProcessFilePath, ProcessSettings);
        }

        public ProcessStartInfo GetProcessStartInfo()
        {
            return CreateProcessRunner().GetProcessStartInfo(ProcessFilePath, ProcessSettings, out _);
        }

        private static readonly byte[] ClrAssemblyData = new byte[]
        {
            0x4d, 0x5a, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
            0x0e, 0x1f, 0xba, 0x0e, 0x00, 0xb4, 0x09, 0xcd, 0x21, 0xb8, 0x01, 0x4c, 0xcd, 0x21, 0x54, 0x68, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x20, 0x63, 0x61, 0x6e, 0x6e, 0x6f,
            0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x44, 0x4f, 0x53, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x0d, 0x0d, 0x0a, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x50, 0x45, 0x00, 0x00, 0x4c, 0x01, 0x03, 0x00, 0x8a, 0x54, 0x4a, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x22, 0x20, 0x0b, 0x01, 0x30, 0x00, 0x00, 0x84, 0x00, 0x00,
            0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xa2, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60, 0x85,
            0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x2e, 0xa2, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x88, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xe0, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x94, 0xa1, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x00, 0x00, 0x48
        };

        private static readonly byte[] NonClrAssemblyData = new byte[]
        {
            0x4d, 0x5a, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00,
            0x0e, 0x1f, 0xba, 0x0e, 0x00, 0xb4, 0x09, 0xcd, 0x21, 0xb8, 0x01, 0x4c, 0xcd, 0x21, 0x54, 0x68, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x20, 0x63, 0x61, 0x6e, 0x6e, 0x6f,
            0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x44, 0x4f, 0x53, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x0d, 0x0d, 0x0a, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0xab, 0x04, 0x28, 0x30, 0xef, 0x65, 0x46, 0x63, 0xef, 0x65, 0x46, 0x63, 0xef, 0x65, 0x46, 0x63, 0x71, 0xc5, 0x81, 0x63, 0xea, 0x65, 0x46, 0x63, 0xa9, 0x34, 0xa7, 0x63, 0xc2, 0x65, 0x46, 0x63,
            0xa9, 0x34, 0xa6, 0x63, 0x71, 0x65, 0x46, 0x63, 0xa9, 0x34, 0x99, 0x63, 0xe4, 0x65, 0x46, 0x63, 0x32, 0x9a, 0x88, 0x63, 0xed, 0x65, 0x46, 0x63, 0x32, 0x9a, 0x8d, 0x63, 0xe0, 0x65, 0x46, 0x63,
            0xef, 0x65, 0x47, 0x63, 0x43, 0x65, 0x46, 0x63, 0x5a, 0xfb, 0xa2, 0x63, 0x4d, 0x65, 0x46, 0x63, 0x5a, 0xfb, 0x9a, 0x63, 0xee, 0x65, 0x46, 0x63, 0xe2, 0x37, 0x9d, 0x63, 0xee, 0x65, 0x46, 0x63,
            0xef, 0x65, 0xd1, 0x63, 0xee, 0x65, 0x46, 0x63, 0x5a, 0xfb, 0x98, 0x63, 0xee, 0x65, 0x46, 0x63, 0x52, 0x69, 0x63, 0x68, 0xef, 0x65, 0x46, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x45, 0x00, 0x00, 0x64, 0x86, 0x06, 0x00, 0xe2, 0xac, 0x47, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x22, 0x20,
            0x0b, 0x02, 0x0c, 0x00, 0x00, 0x6e, 0x0d, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x87, 0x0c, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x11, 0x00, 0x00, 0x04, 0x00, 0x00,
            0xfe, 0x24, 0x12, 0x00, 0x03, 0x00, 0x60, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xd9, 0x0f, 0x00, 0x8a, 0x62, 0x00, 0x00, 0x8c, 0x3b, 0x10, 0x00, 0xa0, 0x00, 0x00, 0x00,
            0x00, 0x90, 0x11, 0x00, 0xb8, 0x05, 0x00, 0x00, 0x00, 0xb0, 0x10, 0x00, 0xb4, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x11, 0x00, 0x3c, 0x09, 0x00, 0x00,
            0xa0, 0x85, 0x0d, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x90, 0xcd, 0x0e, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0d, 0x00, 0x20, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00
        };
    }
}
