/* $Id: xkbselx.h,v 1.2 1999/07/24 15:13:16 stano Exp $

   X Library functions to be used by the callers. They are
   not toolkit-dependent.

   This is the only file to be included by the clients that are using X

   (C) 1999 Stanislav Meduna <stano@eunet.sk>

*/

#ifndef _XKBSELX_H_
#define _XKBSELX_H_

#include <xkbsel.h>

#include <X11/Xlib.h>

#ifdef __cplusplus
  extern "C" {
#endif

/* === Interfacing between selector and indicator === */

/* Publish the current selection and inform the indicator, if any */
int publish_current_sel(Display *disp, const sel_info_t *sel);

/* Get the current selection */
int get_current_sel(Display *disp, sel_info_t *sel, int *found);

/* Tell the system that we want/don't want to be informed about changes */
int notify_me(Display *disp, Window win, int yes);

#ifdef __cplusplus
  }
#endif

#endif /* _XKBSELX_H_ */
