/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.QuarkusBootstrap;

public class BootstrapProfile {
    public static final String QUARKUS_PROFILE_ENV = "QUARKUS_PROFILE";
    public static final String QUARKUS_PROFILE_PROP = "quarkus.profile";
    public static final String QUARKUS_TEST_PROFILE_PROP = "quarkus.test.profile";
    private static final String BACKWARD_COMPATIBLE_QUARKUS_PROFILE_PROP = "quarkus-profile";
    public static final String DEV = "dev";
    public static final String PROD = "prod";
    public static final String TEST = "test";
    private static String runtimeDefaultProfile = null;

    public static void setRuntimeDefaultProfile(String profile) {
        runtimeDefaultProfile = profile;
    }

    public static String getActiveProfile(QuarkusBootstrap.Mode mode) {
        if (mode == QuarkusBootstrap.Mode.TEST) {
            String profile = System.getProperty(QUARKUS_TEST_PROFILE_PROP);
            if (profile != null) {
                return profile;
            }
            return TEST;
        }
        String profile = System.getProperty(QUARKUS_PROFILE_PROP);
        if (profile != null) {
            return profile;
        }
        profile = System.getProperty(BACKWARD_COMPATIBLE_QUARKUS_PROFILE_PROP);
        if (profile != null) {
            return profile;
        }
        profile = System.getenv(QUARKUS_PROFILE_ENV);
        if (profile != null) {
            return profile;
        }
        profile = runtimeDefaultProfile;
        if (profile != null) {
            return profile;
        }
        switch (mode) {
            case REMOTE_DEV_SERVER: 
            case DEV: 
            case CONTINUOUS_TEST: {
                return DEV;
            }
            case REMOTE_DEV_CLIENT: 
            case PROD: 
            case RUN: {
                return PROD;
            }
        }
        throw new RuntimeException("unknown mode:" + String.valueOf((Object)mode));
    }
}

