/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.gcp.gcs.GcsClient;
import org.gradle.internal.resource.transport.gcp.gcs.GcsResource;
import org.gradle.internal.resource.transport.gcp.gcs.ResourceMapper;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsResourceConnector
extends AbstractExternalResourceAccessor
implements ExternalResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcsResourceConnector.class);
    private final GcsClient gcsClient;

    public GcsResourceConnector(GcsClient gcsClient) {
        this.gcsClient = gcsClient;
    }

    public @Nullable List<String> list(ExternalResourceName parent) throws ResourceException {
        LOGGER.debug("Listing parent resources: {}", (Object)parent);
        return this.gcsClient.list(parent.getUri());
    }

    public @Nullable ExternalResourceReadResponse openResource(ExternalResourceName location, boolean revalidate) throws ResourceException {
        LOGGER.debug("Attempting to get resource: {}", (Object)location);
        StorageObject gcsObject = this.gcsClient.getResource(location.getUri());
        if (gcsObject == null) {
            return null;
        }
        return new GcsResource(this.gcsClient, gcsObject, location.getUri());
    }

    public @Nullable ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) throws ResourceException {
        LOGGER.debug("Attempting to get resource metadata: {}", (Object)location);
        StorageObject gcsObject = this.gcsClient.getResource(location.getUri());
        if (gcsObject == null) {
            return null;
        }
        return ResourceMapper.toExternalResourceMetaData(location.getUri(), gcsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        LOGGER.debug("Attempting to upload stream to: {}", (Object)destination);
        try (InputStream inputStream = resource.open();){
            this.gcsClient.put(inputStream, resource.getContentLength(), destination.getUri());
        }
    }
}

