//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "langdefloader.h"

#include "fileutil.h"
#include "langdefparserfun.h"
#include "langelems.h"
#include "regexpstatebuilder.H"

using namespace std;

RegExpStateBuilder builder;
// moved here so that the nested lists of states and formatters are still alive
// (i.e., the shared_ptr are still reachable)

LangDefLoader::LangDefLoader()
{
}


LangDefLoader::~LangDefLoader()
{
}

RegExpStatePtr
LangDefLoader::get_lang_def(const string &path, const string &file)
{
  LangElems *elems = parse_lang_def(path.c_str(), file.c_str());
  RegExpStatePtr state = builder.build(elems);
  delete elems;

  return state;
}

bool
LangDefLoader::check_lang_def(const string &path, const string &file)
{
  RegExpStatePtr state = get_lang_def(path, file);
  if (state.get()) {
    return true;
  }

  return false;
}
