

CWEB(1L)                   Unix Programmer's Manual                   CWEB(1L)


NAME
     ctangle, cweave - translate CWEB to C and/or TeX

SYNOPSIS
     ctangle [ -bhp ] [ +s ] webfile[.w] [changefile[.ch]] [outputfile[.c]]
     cweave [ -bfhpx ] [ +s ] webfile[.w] [changefile[.ch]] [outputfile[.tex]]


DESCRIPTION
     The ctangle program converts a CWEB source document into a C program that
     may  be  compiled  in  the  usual  way.   The  output file includes #line
     specifications so that debugging can be done in terms of the CWEB  source
     file.

     The cweave program converts the same CWEB file into a TeX file  that  may
     be  formatted and printed in the usual way.  It takes appropriate care of
     typographic details like page layout and the use of indentation, italics,
     boldface, etc., and it supplies extensive cross-index information that it
     gathers automatically.

     CWEB  allows  you  to  prepare  a  single  document  containing  all  the
     information  that is needed both to produce a compilable C program and to
     produce a well-formatted document  describing  the  program  in  as  much
     detail  as  the writer may desire.  The user of CWEB ought to be familiar
     with TeX as well as C.

     The command line should have one, two, or three names on it.   The  first
     is  taken as the CWEB file (and .w is added if there is no extension). If
     that file cannot be opened, the extension .web is tried instead. (But  .w
     is recommended, since .web usually implies Pascal.)  If there is a second
     name, it is a change file (and .ch is added if there  is  no  extension).
     The  change  file  overrides  parts  of the WEB file, as described in the
     documentation. If there is a third name, it overrides the default name of
     the  output  file,  which is ordinarily the same as the name of the input
     file (but on the current directory) with the extension .c or .tex.

     Options in the command line may be either turned off with - (if they  are
     on by default) or turned on with + (if they are off by default). In fact,
     the options are processed from left to right, so a sequence  like  -f  +f
     corresponds to +f (which is the default).

     The -b option suppresses the banner line that normally  appears  on  your
     terminal  when  ctangle  or  cweave  begins. The -h option suppresses the
     happy message that normally appears if the processing was successful. The
     -p  option  suppresses  progress  reports (starred module numbers) as the
     processing takes place. If you  say  -bhp,  you  get  nothing  but  error
     messages.

     The +s option prints statistics about memory usage at the end  of  a  run
     (assuming that the programs have been compiled with the -DSTAT switch).

     There are two other options applicable to cweave only:  -f means  do  not
     force  a newline after every statement in the formatted output.  -x means
     omit the index and table of contents.




                                   6/15/92                                   1



CWEB(1L)                   Unix Programmer's Manual                   CWEB(1L)


FILES
     /usr/local/lib/tex/inputs/cwebmac.tex   TeX macros used by cweave output.
     /usr/local/src/cweb/cwebman.tex      The user manual.
     /usr/local/src/cweb/examples/wc.w   An introductory example.
     /usr/local/lib/cweb    Directory for cweb "include" files.

SEE ALSO
     Literate Programming by D.E. Knuth.
     Weaving a Program by Wayne Sewell
     tex(1), cc(1)

AUTHORS
     Don Knuth wrote  WEB  for  TeX  and  Pascal.  Silvio  Levy  designed  and
     developed  CWEB  by  adapting  the  WEB  conventions to C and by recoding
     everything in CWEB.  Knuth began using CWEB and made further refinements.











































                                   6/15/92                                   2

