---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, installation, Computer Modern
---

# Comment installer la version Type 1 des fontes *Computer Modern* ? 

Il s'agit d'un cas particulier 
d'[installation d'une police](/5_fichiers/formats/fontes/installation_de_fontes/installer_une_nouvelle_police). 
En effet, il n'est presque jamais nécessaire de procéder à cette installation : 
il est inconcevable qu'un système récent n'ait pas les polices déjà installées. 
Vous pouvez vérifier cela en testant les polices 
avec un document fourni dans les distributions de LaTeX. 
Exécutez le code suivant en ligne de commande :

::::{tab-set}

:::{tab-item} Avec latex puis dvips
```bash
latex sample2e
dvips -o sample2e.ps sample2e
```
:::

:::{tab-item} Avec pdflatex

```bash
pdflatex sample2e
```
:::

::::

Si la commande fonctionne, la sortie de la console de la commande 
inclura une séquence de noms de fichiers de polices de type 1, 
comme `cmr10.pfb` et ainsi de suite.
Ici, `dvips` comme `pdflatex` vous disent qu'ils copient les informations de la police de type 1 
et que vous n'avez rien à faire de plus.

Si ce test a échoué, vous devez installer votre propre jeu de fontes.
L'extension <ctanpkg:amsfonts> contient toutes les polices que l'AMS a conçues et produites elle-même. 
Elle contient donc tous les fichiers de métriques et de correspondances, 
autrement dit tout ce dont vous avez besoin pour 
[installer les polices](/5_fichiers/formats/fontes/installation_de_fontes/installer_une_police_t1).

:::{sources}
[Installing the Type 1 versions of the CM fonts](faquk:FAQ-inst1cm)
:::