---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, fontes, police italique, upright italics,
              romain et italique, histoire de l'italique
---

# Comment obtenir de l'italique droit ?

Aussi étonnant que cela puisse paraître, oui, cette version droite de 
l'[italique](wpfr:Italique_(typographie)) existe. Voici deux sites donnant des éléments 
sur celui-ci :
- [Design avec FontForge : Italique](http://designwithfontforge.com/fr-FR/Italic.html) ;
- [Italic type](wp:Italic_type), paragraphe **Upright italics**.

Avec les commandes de LaTeX, vous évitez sans le savoir beaucoup de bizarreries typographiques
et l'italique droit en fait partie. Il reste cependant quelques cas qui peuvent être souhaités 
et qu'empêche par défaut le système de sélection de fonte.


## Cas de l'italique droit

Cet italique droit correspondrait intuitivement à une fonte cumulant forme 
italique (`\itshape`) et forme droite (`\upshape`). Donald Knuth a mis à disposition 
une telle fonte et LaTeX l'utilise pour le symbole de la livre sterling "£" 
dans le jeu de polices par défaut. Cette combinaison est suffisamment étrange pour que, 
bien qu'il y ait une fonte définie, aucune commande ne l'utilise par défaut. 
Si jamais vous deviez en avoir besoin, il vous faudra utiliser les commandes de sélection 
de police de bas niveau de LaTeX :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
{\fontshape{ui}\selectfont La typographie... demande à rester 
raisonnable avec les caractères !}
\end{document}
```


## Cas de l'italique en petites capitales

Il s'agit ici d'obtenir une fonte italique (`\itshape`) ou penchée (`\slshape`) 
en petites capitales (`\scshape`). Si certains considèrent ce choix comme malheureux, 
de telles fontes existent. 

En l'occurrence, l'extension <ctanpkg:smallcap> de Daniel Taupin permet de les obtenir 
pour les fontes *[European Computer](/5_fichiers/formats/fontes/que_sont_les_fontes_ec)* 
et des techniques similaires peuvent être appliquées à de nombreux autres jeux de fontes. 
Cette extension n'est pas dans les distributions courantes (et donc dans les éléments 
utilisables par cette FAQ), mais vous pouvez toujours en télécharger les deux fichiers 
depuis CTAN. Son idée est de faire des petites capitales une *famille*, 
au lieu d'une *forme*. Donc remplacer la commande `\scshape` par `\scfamily`. 
Ainsi, il devient possible de sélectionner des petites capitales grasses penchées 
en écrivant :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{smallcap}

\begin{document}
\textbf{\scfamily\slshape C'est la vie !}
\end{document}
```
