---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              disposition d'équations, alignement, align, split, flalign, 
              alignat, eqnarray
---

# Comment aligner des équations ?

Pour aligner des équations sur un signe de relation, 
il est possible sous LaTeX d'appeler l'environnement `eqnarray` avec 
ou sans la commande `lefteqn`. Cependant, cette méthode n'est 
[pas recommandée](arguments_contre_eqnarray) et il vaut mieux utiliser 
des extensions dédiées proposant plusieurs environnements mieux adaptés.


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) met à disposition 
différents environnements pour ce type de présentation.


### Les environnements classiques

Les environnements couramment utilisés sont :
- `align` pour un bloc d'équations centrées. L'alignement se fait 
  sur le caractère `&`. Comme le montre l'exemple suivant 
  avec la dernière équation présentée, il est possible de placer 
  plusieurs équations sur une même ligne en répétant le caractère `&` 
  (à l'image de ce qui se fait pour un tableau avec les environnements 
  `tabular` et `array`, comme le montre la question
  "[](/3_composition/tableaux/construire_un_tableau)") ;
- `flalign` pour un bloc d'équations non plus centrées mais alignées à gauche.
  Une nouvelle fois, l'alignement se fait sur le caractère `&`. 
  De plus, chaque ligne de l'équation, exceptée la dernière, doit finir 
  par un caractère `&` : sans cela, les équations seraient centrées, 
  comme avec `align` ;
- `split` pour faire un bloc d'équation au sein d'une équation. 
  L'alignement se fait sur le caractère `&` et toutes les équations 
  sont regroupées avec un seul numéro (ce qui est logique pour notre exemple
  ci-dessous avec l'équation 5). La question 
  "[](/4_domaines_specialises/mathematiques/equations/disposition_d_equations/mettre_en_page_des_formules_longues)" 
  illustre l'utilisation de cet environnement.

Ces environnements, hors `split`, disposent tous de versions avec numérotation
par défaut et de versions sans numérotation en ajoutant `*` au nom 
de l'environnement, comme l'illustre la dernière équation ci-dessous.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Un exemple d'environnement \texttt{align} :
\begin{align}
  f(x) & = x^2 + 8x + 16 \\
       & = (x+4)^2
\end{align}
Un exemple d'environnement \texttt{flalign} :
\begin{flalign}
  f(x) & = x^2 + 8x + 16 & \\
       & = (x+4)^2
\end{flalign}
Un exemple d'environnement \texttt{split} dans un environnement 
\texttt{align} :
\begin{align}
  \begin{split}
    A & = B + C + D + E + F + G \\
      & \quad + H + I
  \end{split} \\
   F & = G + H
\end{align}
Un exemple d'environnement \texttt{align} non numéroté, avec deux 
équations en parallèle :
\begin{align*}
  f(x) & = x^2 + 8x + 16 & g(x) & = (3x)^2 - 9x^2 \\
       & = (x+4)^2       &      & = 0
\end{align*}
\end{document}
```


### L'environnement `alignat`

Pour produire des systèmes d'équations, on peut utiliser l'environnement 
`alignat`. Toutefois, il faut noter que cet environnement est alors détourné
de son utilisation normale. En effet, ce dernier est prévu pour aligner 
des objets différents sur des colonnes alternativement justifiées à droite 
puis à gauche. L'utilisation de colonnes vides permet alors de choisir 
la justification voulue. De plus, l'utilisation de `{}` permet d'obtenir 
des espacements "normaux".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Voici quelques exemples :
\begin{alignat}{2}
  x   & = y   &&+ z   \\
  x_1 & = y_1 &&+ z_1
\end{alignat}

\begin{alignat}{5}
  10a& ={}&  3x&& 3y& +{}& 18z&&  2w&  \\
   6a& ={}& 17x&&   & +{}&  5z&& 19w&
\end{alignat}
\end{document}
```


## Avec l'extension <ctanpkg:eqnarray>

L'environnement `equationarray` de l'extension <ctanpkg:eqnarray> 
associe les environnements `eqnarray` et `array`. 
Il n'est pas limité en nombre de colonnes.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{eqnarray}

\begin{document}
Voici quelques exemples :
\begin{equationarray}{ccccc}
  10a & = & 3x  3y & + & 18z  2w \\
   6a & = & 17x    & + &  5z 19w
\end{equationarray}
\end{document}
```