/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.FieldValueElement;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueGroupMatch
implements FieldValueElement {
    private String name;
    private int index;

    public FieldValueGroupMatch(String string) {
        this.name = string;
        this.index = 0;
    }

    public FieldValueGroupMatch(int n) {
        this.index = n;
        this.name = null;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        TeXObjectList teXObjectList;
        TeXParser teXParser = bib2GlsEntry.getResource().getBibParser();
        String string = this.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        if (string.indexOf("\\") != -1) {
            teXObjectList = new TeXObjectList();
            teXParser.scan(string, teXObjectList);
        } else {
            teXObjectList = teXParser.getListener().createString(string);
        }
        return new BibUserString((TeXObject)teXObjectList);
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException {
        if (this.name == null) {
            return bib2GlsEntry.getResource().getLastMatchGroup(this.index);
        }
        return bib2GlsEntry.getResource().getLastMatchGroup(this.name);
    }

    public String toString() {
        if (this.name == null) {
            return String.format("\\MGP{%d}", this.index);
        }
        return String.format("\\MGP{%s}", this.name);
    }
}

