/* dvipage.cpp							-*- C++ -*-
   Time-stamp: "97/02/26 18:11:35 cschenk"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/*
  @todo
  implement greyscaling
  @end todo
  */

#include <string.h>
#include <limits.h>

#include "common.h"
#include "dvi.h"

dvi_page::dvi_page ()

  : items (0),
    nitems (0),
    curitem (0),
    x1 (INT_MAX),
    y1 (INT_MAX),
    x2 (INT_MIN),
    y2 (INT_MIN),
    nbitmaps (0),
    curbitmap (0),
    bitmaps (0)

{
  ;
}

dvi_page::dvi_page (dvi_integer loc,
		    dvi_integer c0,
		    dvi_integer c1,
		    dvi_integer c2,
		    dvi_integer c3,
		    dvi_integer c4,
		    dvi_integer c5,
		    dvi_integer c6,
		    dvi_integer c7,
		    dvi_integer c8,
		    dvi_integer c9)

  : x1 (INT_MAX),
    y1 (INT_MAX),
    x2 (INT_MIN),
    y2 (INT_MIN),
    nbitmaps (0),
    curbitmap (0),
    bitmaps (0)

{
  dprintf3 ("dvi_page::dvi_page (%p, %ld, %ld, ...)\n",
	    this, (long) loc, (long) c0);
  location = loc;
  count_reg[0] = c0;
  count_reg[1] = c1;
  count_reg[2] = c2;
  count_reg[3] = c3;
  count_reg[4] = c4;
  count_reg[5] = c5;
  count_reg[6] = c6;
  count_reg[7] = c7;
  count_reg[8] = c8;
  count_reg[9] = c9;
  nitems = 1024;
  curitem = 0;
  items = (dvi_item *) malloc (sizeof (dvi_item) * nitems);
}

enum dvi_bool
dvi_page::additem (const dvi_item &item)

{
  if (curitem == nitems - 1)
    {
      nitems *= 2;
      items = (dvi_item *) realloc (items, sizeof (dvi_item) * nitems);
    }
  if (item.y - item.height + 1 < y1)
    y1 = item.y - item.height + 1;
  if (item.x < x1)
    x1 = item.x;
  if (item.y > y2)
    y2 = item.y;
  if (item.x + item.width - 1 > x2)
    x2 = item.x + item.width - 1;
  items[curitem++] = item;
  if (item.bitmap)
    dprintf6 ("bitmap: '%c' (0x%x), %ld, %ld, %ld, %ld\n",
	      (char) item.code, item.code,
	      item.x, item.y, item.width, item.height);
  return (dvi_true);
}

int
compareitems (const void *itemptr1,
	      const void *itemptr2)

{
  const dvi_item &item1 = * (const dvi_item *) itemptr1;
  const dvi_item &item2 = * (const dvi_item *) itemptr2;
  return (item1.y - item1.height + 1 < item2.y - item2.height + 1
	  ? -1
	  : (item1.y - item1.height + 1 > item2.y - item2.height + 1
	     ? 1
	     : 0));
}

void
dvi_page::preparebitmaps ()

{
  destroybitmaps ();
  if (curitem == 0)
    return;
  dvi_pixel max_white = 20;	// FIXME
  nbitmaps = 10;
  bitmaps = (dvi_bitmap *) malloc (sizeof (dvi_bitmap) * nbitmaps);
  dvi_pixel first_y;
  dvi_pixel last_y = INT_MIN;
  dvi_pixel lastidx = 0;
  bitmaps[0].x = x1;
  bitmaps[0].y = y1;
  bitmaps[0].width = x2 - x1 + 1;
  bitmaps[0].height = items[0].height;
  bitmaps[0].bitmap = 0;
  for (dvi_integer i = 1; i < curitem; i++)
    {
      if (items[i].y - items[i].height + 1
	  >= bitmaps[curbitmap].y + bitmaps[curbitmap].height + max_white)
	{
	  curbitmap++;
	  if (curbitmap == nbitmaps)
	    {
	      nbitmaps *= 2;
	      bitmaps = (dvi_bitmap *) realloc (bitmaps,
						sizeof (dvi_bitmap) * nbitmaps);
	    }
	  bitmaps[curbitmap].x = x1;
	  bitmaps[curbitmap].y = items[i].y - items[i].height + 1;
	  bitmaps[curbitmap].width = x2 - x1 + 1;
	  bitmaps[curbitmap].height = items[i].height;
	  bitmaps[curbitmap].bitmap = 0;
	}
      if (items[i].y > bitmaps[curbitmap].y + bitmaps[curbitmap].height - 1)
	bitmaps[curbitmap].height = items[i].y - bitmaps[curbitmap].y + 1;
    }
  curbitmap++;
}

void
dvi_page::makebitmaps (size_t bytesperrword)

{
  if (curitem == 0)
    return;
  if (bitmaps == 0)
    {
      qsort (items, curitem, sizeof(dvi_item), compareitems);
      preparebitmaps ();
      dvi_pixel width = x2 - x1 + 1;
      size_t bitsperrword = bytesperrword * 8;
      dvi_integer raster_rword_width = ((width + (bitsperrword - 1))
					/ bitsperrword);
      dvi_integer raster_byte_width = raster_rword_width * bytesperrword;
      dvi_integer bmidx = 0;
      for (dvi_integer i = 0; i < curitem; i++)
	{
	  const dvi_item &item = (*this)[i];
	  if (item.y >= bitmaps[bmidx].y + bitmaps[bmidx].height)
	    bmidx++;
	  dvi_integer bit_offset = (item.x - x1) % 8;
	  dvi_integer item_rword_width = ((item.width + 15) / 16);
	  dvi_integer item_byte_width = item_rword_width * 2;
	  const dvi_byte *chrast = (const dvi_byte *) item.bitmap;
	  for (dvi_integer i = 0; i < item.height; i++)
	    {
	      for (dvi_integer j = 0; j < item_byte_width; j++)
		{
		  if ((item.x - x1) + j < 0)
		    continue;

		  if (bitmaps[bmidx].bitmap == 0)
		    {
		      dvi_integer rastersize;
		      rastersize = raster_byte_width * bitmaps[bmidx].height;
		      bitmaps[bmidx].bitmap = malloc (rastersize);
		      memset ((dvi_byte *) bitmaps[bmidx].bitmap,
			      0xff, rastersize);
		    }

		  dvi_integer rasteridx = (((item.y - item.height + i + 1
					     - bitmaps[bmidx].y)
					    * raster_byte_width)
					   + ((item.x - x1) / 8)
					   + j);
		  dvi_integer chrastidx = i * item_byte_width + j;
		  dvi_byte thebyte;
		  if (chrast)
		    thebyte = chrast[chrastidx];
		  else if (j * 8 > item.width)
		    thebyte = 0xff;
		  else if ((j + 1) * 8 > item.width)
		    thebyte = ~ (255 << (8 - (item.width % 8)));
		  else
		    thebyte = 0;
		  dvi_byte mask = (255 << (8 - bit_offset));
		  mask |= thebyte >> bit_offset;
		  dvi_byte *raster = (dvi_byte *) bitmaps[bmidx].bitmap;
		  raster[rasteridx] &= mask;
		  if (bit_offset && (8 * j + 8 - bit_offset < item.width))
		    {
		      unsigned mask = (1 << (8 - bit_offset)) - 1;
		      mask |= (thebyte << (8 - bit_offset)) & 0xff;
		      raster[rasteridx + 1] &= mask;
		    }
		}
	    }
	}
    }
}

void
dvi_page::destroybitmaps ()

{
  if (bitmaps)
    {
      for (dvi_integer i = 0; i < curbitmap; i++)
	{
	  if (bitmaps[i].bitmap)
	    free ((void *) bitmaps[i].bitmap);
	}
      free ((void *) bitmaps);
      bitmaps = 0;
    }
  nbitmaps = 0;
  curbitmap = 0;
}

dvi_page::~dvi_page ()

{
  dprintf1 ("dvi_page::~dvi_page (%p)\n", this);
  if (items)
    {
      free (items);
      items = 0;
      nitems = 0;
      curitem = 0;
    }
  destroybitmaps ();
}
