/*
 * 	Module: color.c
 *		by: Andre Hentz 
 *		date: 24 Mar 1995 
 */ 

/*
 * TO DO
 * 	error handling
 */ 
#include "slang.h"
#include "jmalloc.h"
#include "buffer.h"
#include <stdio.h>
#include <string.h>
static long line_len;  /* line lenght */
extern void tex_syntax_highlight(unsigned short *, unsigned short *);

void do_syntax_highlight(register unsigned short *p, register unsigned short *pmax)
{
	char string[pmax-p+1];
	char attr[pmax-p+1];
	char *r;
	int flag;
	int i;
	unsigned short color;
	
	line_len = pmax-p;
	/* preprocess arguments */
	for(i=0;i<line_len;i++)
	{
		string[i] = (char)(*(p+i) & 0xFF);
		attr[i] = (char)(*(p+i) >> 8)+1/*48*/;
	}
	string[i] = '\0';
	attr[i] = '\0';
	if (SLang_Error)
	{
		SLang_restart(1);
		return;
	}
		
	/* call Slang function */
	if (!SLang_run_hooks("Highlight", string, attr))
	{
		SLang_doerror("SLang function Highlight not defined");
		SLang_restart(1);
		return;
	}
	
	/* pop results */
	if(SLang_pop_string(&r, &flag))
	{
		SLang_doerror("Cannot get string of attributes");
		SLang_restart(1);
		return;
	}
	strncpy(attr, r, line_len);
	attr[line_len] = 0;
	
	/* postprocess results */
	for(i=0;i<line_len;i++)
	{
		color = (unsigned short)(attr[i]-1/*48*/);
		*p++ |= color << 8;
	}
	
	/* free result */
	if (flag == 1)
		FREE(r); 
}

int internal_highlight_syntax()
{
	int i;
	char *s;
	char *a;
	char string[line_len+1];
	char attr[line_len+1];
	int flag_str, flag_attr;
	unsigned short line[line_len+1];
	unsigned char color, ch;
	register unsigned short *p, *pmax;

	/* pop arguments */ 
	if(SLang_pop_string(&s, &flag_str))
	{
		SLang_doerror("Cannot pop string");
		SLang_restart(1);
		return;
	}
	strncpy(string, s, line_len);
	string[line_len] = 0;
	
	if(SLang_pop_string(&a, &flag_attr))
	{
		SLang_doerror("Cannot pop attributes");
		SLang_restart(1);
		return;
	}
	strncpy(attr, a, line_len);
	attr[line_len] = 0;
		
	/* preprocess arguments */
	for(i=0;i<line_len;i++)
	{		
		color = (unsigned char)(attr[i]-1/*48*/);
		ch = (unsigned char)(string[i]);
		line[i] = (color << 8) | ch;
	}	
	p = &line[0];
	pmax = &line[line_len];
	
	/* do highlight */
	if (!strcmp(CBuf->mode_str,"TeX")) 	
		tex_syntax_highlight(p,pmax);
	else if (CBuf->modes & C_MODE)
		syntax_highlight(p,pmax);
	
	/* postprocess results */
	for(i=0;i<line_len;i++)
		attr[i] = (char)( *p++ >> 8 ) + 1/*48*/;

	/* push results */ 
	SLang_push_string(attr);
		
	/* free arguments */
	if (flag_str)
		FREE(s);
	if (flag_attr)
		FREE(a); 
}


/* Some useful functions */
int is_one_of(char *set, int *elem)
{
	if (strchr(set,(char)*elem))
		return 1;
	return 0;
}


int number_length(char *str, int *pos)
{
	char *index;
	int str_len;
	int len = 0;
	int state = 0;
	
	index = str + *pos;
	str_len = strlen(index);

	while(len<str_len)
	{
		if(strchr("0123456789",*index))
		{
		switch(state)
			{
			 case 1: state = 1;
			 case 2: state = 2;
			 case 3: state = 3;
			 case 4: state = 2;
			 case 5: state = 3;
			 case 6: state = 3;
			 case 0: state = 1;				
			}
		}
		else if ((*index=='.')&&(state==0||state==1))
			state = 4;
		else if ((*index=='e'||*index=='E')&&(state==1||state==2))
			state = 5;
		else if ((*index=='+'||*index=='-')&&state==5)
			state = 6;
		else
			break;
		index++;
		len++;
	}
	if (state != 1 && state != 2 && state != 3)
		len--;

	if (len>1) 
		return len;
	if (len==1)
		if (*(index-1)!='0')
			return 1;

	/* test if is an hexa */ 	
	len = 0;
	state = 0;
	index = str + *pos;
	
	while(len<str_len)
	{
		if(state==3 && strchr("0123456789ABCDEFabcdef",*index))
		{
		}
		else if ((state==0) && (*index=='0'))
			state = 1;
		else if ((state==1) && (*index=='x'))
			state = 2;
		else if ((state==2) && strchr("0123456789ABCDEFabcdef",*index))
			state = 3;
		else
			break;
		index++;
		len++;
	}
	if ( state == 2 )
		len--;
	if (len<=0) len=0;
	else return len;

	return len;	
}
