.TH DLH 1 "Text Utilities" "GNU" \" -*- nroff -*-
.SH NAME
dlh \- translate LaTeX into HTML
.SH SYNOPSIS
.B dlh
[\-fhivV] [\-\-force] [\-\-help] [\-\-icon-dir=directory] [\-\-verbose] [\-\-version]
name...
.SH DESCRIPTION
This manual page documents the command line usage of
.BR dlh ,
the GNU LaTeX to HTML translator.  Each filename listed on the command
line is assumed to be a LaTeX file (with an optional extension of .tex)
which
.B dlh
translates into a set of HTML and image files.  All output files are
stored in a directory that is named after the document name (without
the .tex extension).  For example, the files for a file called
sample.tex would be stored in a directory called sample.  The
top-level file for that document is stored in sample/index.html.

When
.B dlh
starts up, it implicitly loads site-start.sty (as if the command
\\usepackage{site-start} had been given).  This allows site-wide
customization of
.B dlh
without having to modify the C source code.  Note that
.B dlh
quitely ignores \\usepackage{} style files that do not exist (unless
option \-\-verbose is given).

For a tutorial and detailed
description on using
.BR dlh ,
please refer to the
.B dlh
manual.
.SS OPTIONS
.TP
.I "\-f, \-\-force"
Force creation of all output files.  Normally,
.B dlh
does not recreate images etc. that already exist.  This makes
.B dlh
execute much faster, but it may occasionally result in an inconsistent
document (e.g., if the order of the figures in a document changes).
This option forces the generation of a consistent document.
.TP
.I "\-i, \-\-icon-dir=url"
Use the specified url to refer to the icons that
.B dlh
requires internally.  Normally, the value for this url is "../icons".
This value works as long as the icons are in a directory called
"icons" and that directory is in the parent directory of the directory
that holds the generated HTML files.
.TP
.I "\-v, \-\-verbose"
Be verbose during processing.  For example, with this option in effect,
.B dlh
prints messages about what files its reusing.
.TP
.I "\-h, \-\-help"
Print a usage message on standard output and exit successfully.
.TP
.I "\-V, \-\-version"
Print version information on standard output then exit successfully.
.SH ENVIRONMENT
.TP
DLHINPUTS
This environment variable can be set to a colon-separated
list of directories.  Its default value is @DLHINPUTSDIR@.  The
directories listed in this environment variable are searched for each
LaTeX class or style file (similar to LaTeX's TEXINPUTS environment
variable).  Many LaTeX style files contain TeX commands which are
unsuitable for processing by
.BR dlh .
For this reason, it is generally not a good idea to set DLHINPUTS to
the same value as TEXINPUTS.  Instead, DLHINPUTS should be set to
a directory list that is known to contain only style files that are
suitable for
.BR dlh.
Style files that work both for LaTeX and
.B dlh
can be shared either by putting them into a directory that is listed
both in TEXINPUTS and in DLHINPUTS or, alternatively, by symlinking
the LaTeX style file into a directory that is listed in DLHINPUTS.
.SH FILES
.TP
@BINDIR@/dlh
The
.B dlh
executable
.TP
@DATADIR@/inputs
additional LaTeX style files
.TP
@DATADIR@/inputs/dlh
substitute style files that
.B dlh
uses in lieu of their (complex) LaTeX counterparts
.SH AUTHORS
.RS
David Mosberger-Tang (primary author)
.br
davidm@cs.arizona.edu
.PP
Fabio Cozman
.br
fgcozman@cs.cmu.edu
.PP
Erick Branderhorst
.SH BUGS
Math mode support is minimalistic.
