/*
 *	Run_Options data structure
 */

#define ROPTIONS

struct Pages_Spec {
	struct Pages_Spec *Link;	/* Pointer to next in chain */
	long Low_Page[10];		/* Starting page number */
	long High_Page[10];		/* Ending page or search flags */
	int Range;			/* 0: Search; 1: Range */
};

struct Run_Options {
	struct Device_Table *Device_Ptr;/* /DEVICE=        */
	struct Pages_Spec *Pages_Head;	/* /PAGES=         */
	int (*Pixel_Load_Func)();	/* /PIXEL_SOURCE   */
	struct Ratio Form_Size[2];	/* /FORM=          */
	unsigned long Magnification;	/* /MAGNIFICATION= */
	long Hoffset;			/* /HOFFSET=       */
	long Voffset;			/* /VOFFSET=       */
	unsigned long Memory_Size;	/* /MEMORY=        */
	unsigned long Flags, Neg_Flags;	/* Various flags   */
#define DEVICE        0x00000001
#define PAGES         0x00000002
#define MAGNIFICATION 0x00000004
#define HOFFSET       0x00000008
#define VOFFSET       0x00000010
#define LANDSCAPE     0x00000020
#define MEMORY        0x00000040
#define COPIES        0x00000080
#define OUTPUT        0x00000100
#define INTERACTIVE   0x00000200
#define USETFM        0x00000400
#define ODD_PAGES     0x00000800
#define EVEN_PAGES    0x00001000
#define TWO_SIDED     0x00002000
#define PORTRAIT      0x00004000
#define CONCATENATE   0x00008000
#define REVERSE       0x00010000
#define EXCLUDE       0x00020000
#define PIXEL_SOURCE  0x00040000
#define DELETE        0x00080000
#define MARK          0x00100000
#define MKFONT        0x00200000
#define MKSCALE       0x00400000
#define SORTED        0x00800000
#define FORM_WIDTH    0x01000000
#define FORM_HEIGHT   0x02000000
#define ROTATED       0x04000000
#define VARIABLE      0x08000000
#define DEFAULT_FLAG  USETFM
	unsigned long Trace, Neg_Trace;	/* /TRACE=         */
	unsigned long Mark_Font_Scale;	/* /MKSCALE=       */
	unsigned short Number_of_Copies;/* /COPIES=        */
	char Output[256];		/* /OUTPUT=        */
	char Page_Mark[40];		/* /MARK=          */
	char Mark_Font_Name[40];	/* /MKFONT=        */
};
