(* Random file access; used in DVIReader and FontReader *)

CONST
   bufflen  = 1024;          (* size of buffer for holding DVI/PK bytes *)
   bufflenm = bufflen - 1;

   O_RDONLY = 0;             (* SYSDEP: read-only flag for open;
                                value came from /usr/include/sys/fcntl.h
                             *)

TYPE
   buffer  = PACKED ARRAY [0..bufflenm] OF CHAR;

FUNCTION open (VAR path : string; flags, mode : integer) : integer;   EXTERNAL;
FUNCTION lseek(f, offset, whence : integer) : integer;                EXTERNAL;
FUNCTION read (f : integer; VAR b : buffer; n : integer) : integer;   EXTERNAL;
FUNCTION write(f : integer; VAR b : buffer; n : integer) : integer;   EXTERNAL;
FUNCTION close(f : integer) : integer;                                EXTERNAL;
